/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.et.m_multiblocks.m_voidminer.registry;

import com.valkyrieofnight.et.m_multiblocks.m_voidminer.registry.ITargetableRegistry;
import com.valkyrieofnight.et.m_multiblocks.m_voidminer.registry.json.JsonTargetedStack;
import com.valkyrieofnight.et.m_multiblocks.m_voidminer.registry.json.TargetableJsonHandler;
import com.valkyrieofnight.vliblegacy.lib.module.IFeature;
import com.valkyrieofnight.vliblegacy.lib.stack.WeightedRandomUtil;
import com.valkyrieofnight.vliblegacy.lib.stack.WeightedStackBase;
import com.valkyrieofnight.vliblegacy.lib.sys.init.IModInit;
import com.valkyrieofnight.vliblegacy.lib.sys.init.IModPostInit;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;

public abstract class TargetableRegistry
implements ITargetableRegistry,
IFeature,
IModPostInit,
IModInit {
    private ArrayList<WeightedStackBase> weightedStacks = new ArrayList();
    private HashMap<String, List<ItemStack>> targetedStacks = new HashMap();
    private File file;
    public HashMap<String, List<ItemStack>> targeters;

    public TargetableRegistry(File path, String configName) {
        this(new File(path.getPath() + "/" + configName));
    }

    public TargetableRegistry(File file) {
        this.file = file != null && !file.getPath().endsWith(".json") ? new File(file.getPath() + ".json") : file;
    }

    @Override
    public List<WeightedStackBase> getTargetedList(String focusTarget, float boostMultiplier) {
        if (!this.targetedStacks.containsKey(focusTarget) && focusTarget == null || focusTarget.equals("")) {
            return this.getList();
        }
        ArrayList<WeightedStackBase> wisl = new ArrayList<WeightedStackBase>(this.weightedStacks.size());
        WeightedRandomUtil.copyWSList(wisl, this.weightedStacks);
        List<ItemStack> sedCo = this.targetedStacks.get(focusTarget);
        if (sedCo == null || sedCo.isEmpty()) {
            return this.getList();
        }
        int boost = WeightedRandom.func_76272_a(this.weightedStacks) / (this.weightedStacks.size() / 2);
        for (ItemStack itemStack : sedCo) {
            if (itemStack == ItemStack.field_190927_a) continue;
            for (WeightedStackBase stack : wisl) {
                if (!stack.isStackEqual(itemStack)) continue;
                stack.field_76292_a = (int)((float)stack.field_76292_a + (float)boost * (MathHelper.func_76135_e((float)boostMultiplier) + 1.0f));
            }
        }
        return wisl;
    }

    @Override
    public List<WeightedStackBase> getList() {
        return this.weightedStacks;
    }

    @Override
    public boolean hasResource(ItemStack other) {
        for (WeightedStackBase stack : this.weightedStacks) {
            if (!stack.isStackEqual(other)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addResource(WeightedStackBase wis, String focusTarget) {
        if (wis != null && !this.hasResource(wis.getMainStack()) && wis.getMainStack() != null && wis.getMainStack() != ItemStack.field_190927_a) {
            this.weightedStacks.add(wis);
            this.createTargetedStackList(focusTarget);
            List<ItemStack> stacks = this.targetedStacks.get(focusTarget);
            stacks.add(wis.getMainStack());
            return true;
        }
        return false;
    }

    protected void createTargetedStackList(String target) {
        if (!this.targetedStacks.containsKey(target)) {
            this.targetedStacks.put(target, new ArrayList());
        }
    }

    @Override
    public String getPriorityTarget(ItemStack stack) {
        for (String str : this.targetedStacks.keySet()) {
            List<ItemStack> stacks = this.targetedStacks.get(str);
            for (ItemStack is : stacks) {
                if (!is.equals(stack)) continue;
                return str;
            }
        }
        return "";
    }

    @Override
    public WeightedStackBase getWeightedStack(ItemStack stack) {
        for (WeightedStackBase ws : this.weightedStacks) {
            if (!ws.isStackEqual(stack)) continue;
            return ws;
        }
        return null;
    }

    @Override
    public List<ItemStack> getLensesOfTarget(String focusTarget) {
        return this.targeters.get(focusTarget);
    }

    public void initFeature(ConfigCategory config) {
    }

    public void init(FMLInitializationEvent event) {
    }

    public void postInit(FMLPostInitializationEvent event) {
        this.targeters = this.getTargeters();
        if (!this.file.exists()) {
            ArrayList<JsonTargetedStack> defaults = this.addDefaults();
            TargetableJsonHandler.saveRegistryDefaultsToJson(this.file, defaults);
        }
        TargetableJsonHandler.loadRegistryFromJson(this.file, this);
    }

    public abstract ArrayList<JsonTargetedStack> addDefaults();

    public abstract HashMap<String, List<ItemStack>> getTargeters();
}

