/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.textures;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.textures.ConnectedTexturesHelper;
import com.rwtema.extrautils2.textures.SpriteLoader;
import com.rwtema.extrautils2.utils.LogHelper;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.util.ResourceLocation;

public class SpriteConnectedTextures
extends SpriteLoader {
    public static final String basePath = "textures";
    public final int texID;

    protected SpriteConnectedTextures(String spriteName, int texID) {
        super(spriteName);
        this.texID = texID;
    }

    public static String iconName(String name, int offset) {
        return name + "_" + offset;
    }

    @Nonnull
    public String func_94215_i() {
        return SpriteConnectedTextures.iconName(super.func_94215_i(), this.texID);
    }

    @Override
    protected void loadSprite(BufferedImage[] abufferedimage, AnimationMetadataSection animationmetadatasection) {
        this.func_110968_a(Lists.newArrayList());
        int size = abufferedimage[0].getWidth();
        int h = abufferedimage[0].getHeight();
        this.field_130223_c = size;
        this.field_130224_d = size;
        if (size % 2 != 0) {
            throw new RuntimeException("Wrong width (must be divisible by 2)");
        }
        if (h != size * 5) {
            throw new RuntimeException("Wrong aspect ratio (must be 1x5)");
        }
        int[][] aint = new int[abufferedimage.length][];
        BufferedImage bufferedimage = abufferedimage[0];
        aint[0] = new int[size * size];
        int textureIndexMask = ConnectedTexturesHelper.textureIds[this.texID];
        int half_size = size / 2;
        int subImageIndex = textureIndexMask / 125;
        bufferedimage.getRGB(0, subImageIndex * size, half_size, half_size, aint[0], 0, size);
        textureIndexMask -= subImageIndex * 125;
        subImageIndex = textureIndexMask / 25;
        bufferedimage.getRGB(0, subImageIndex * size + half_size, half_size, half_size, aint[0], half_size * size, size);
        textureIndexMask -= subImageIndex * 25;
        subImageIndex = textureIndexMask / 5;
        bufferedimage.getRGB(half_size, subImageIndex * size + half_size, half_size, half_size, aint[0], half_size * (size + 1), size);
        textureIndexMask -= subImageIndex * 5;
        subImageIndex = textureIndexMask;
        bufferedimage.getRGB(half_size, subImageIndex * size, half_size, half_size, aint[0], half_size, size);
        this.field_110976_a.clear();
        this.field_110976_a.add(aint);
    }

    @Override
    public boolean load(IResourceManager par1ResourceManager, ResourceLocation location) {
        ResourceLocation resourcelocation = new ResourceLocation("extrautils2:connected/" + super.func_94215_i());
        ResourceLocation resourcelocation1 = Textures.completeTextureResourceLocation(resourcelocation);
        try (IResource iresource = par1ResourceManager.func_110536_a(resourcelocation1);){
            int mipmapLevels = Minecraft.func_71410_x().field_71474_y.field_151442_I;
            BufferedImage[] abufferedimage = new BufferedImage[1 + mipmapLevels];
            abufferedimage[0] = ImageIO.read(iresource.func_110527_b());
            this.loadSprite(abufferedimage, null);
            this.func_147963_d(mipmapLevels);
        }
        catch (IOException ioexception1) {
            LogHelper.logger.error("Using missing texture, unable to load " + resourcelocation1, (Throwable)ioexception1);
            return true;
        }
        return false;
    }
}

