/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory.gui;

import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.common.ShadingValidator;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory.ValidatedSlot;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory.gui.widget.WItemSlot;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory.gui.widget.WPanel;
import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.inventory.gui.widget.WPlainPanel;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConcreteContainer
extends Container {
    private final IInventory playerInventory;
    private final IInventory container;
    private WPanel rootPanel;
    private int[] syncFields = new int[0];
    private boolean drawPanel = true;
    private int panelColor = -3750202;
    private int titleColor = -12566464;

    public ConcreteContainer(@Nonnull IInventory player, @Nullable IInventory container) {
        this.playerInventory = player;
        this.container = container;
    }

    public void validate() {
        if (this.rootPanel != null && !this.rootPanel.isValid()) {
            this.field_75151_b.clear();
            this.field_75153_a.clear();
            this.rootPanel.validate(this);
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        if (this.container != null) {
            return this.container.func_70300_a(playerIn);
        }
        return true;
    }

    public void addSlotPeer(Slot slot) {
        this.func_75146_a(slot);
    }

    public void initContainerSlot(int slot, int x, int y) {
        this.func_75146_a(new ValidatedSlot(this.container, slot, x * 18, y * 18));
    }

    public void initPlayerInventory(int x, int y) {
        for (int yi = 0; yi < 3; ++yi) {
            for (int xi = 0; xi < 9; ++xi) {
                this.func_75146_a(new Slot(this.playerInventory, xi + yi * 9 + 9, x + xi * 18, y + yi * 18));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot(this.playerInventory, i, x + i * 18, y + 54 + 4));
        }
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        if (this.container != null) {
            listener.func_175173_a((Container)this, this.container);
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.container != null && this.container.func_174890_g() > 0) {
            int numFields = this.container.func_174890_g();
            if (this.syncFields.length < numFields) {
                this.syncFields = new int[numFields];
            }
            for (IContainerListener listener : this.field_75149_d) {
                for (int field = 0; field < numFields; ++field) {
                    int newValue = this.container.func_174887_a_(field);
                    if (this.syncFields[field] == newValue) continue;
                    listener.func_71112_a((Container)this, field, newValue);
                    this.syncFields[field] = newValue;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        if (this.container != null) {
            this.container.func_174885_b(id, data);
        }
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        if (this.rootPanel != null && !this.rootPanel.isValid()) {
            this.rootPanel.validate(this);
        }
        ItemStack srcStack = ItemStack.field_190927_a;
        Slot src = (Slot)this.field_75151_b.get(index);
        if (src != null && src.func_75216_d()) {
            srcStack = src.func_75211_c();
            if (src.field_75224_c == this.playerInventory) {
                ItemStack remaining = this.transferToInventory(srcStack, this.container);
                src.func_75215_d(remaining);
                return ItemStack.field_190927_a;
            }
            ItemStack remaining = this.transferToInventory(srcStack, this.playerInventory);
            src.func_75215_d(remaining);
            return ItemStack.field_190927_a;
        }
        src.func_75215_d(srcStack);
        return ItemStack.field_190927_a;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (this.rootPanel != null && !this.rootPanel.isValid()) {
            this.rootPanel.validate(this);
        }
        ItemStack result = super.func_184996_a(slotId, dragType, clickTypeIn, player);
        return result;
    }

    public void setRootPanel(WPanel panel) {
        this.field_75151_b.clear();
        this.field_75153_a.clear();
        this.rootPanel = panel;
    }

    public WPanel getRootPanel() {
        return this.rootPanel;
    }

    public ItemStack transferToInventory(ItemStack stack, IInventory inventory) {
        ItemStack result = stack.func_77946_l();
        for (Slot s : this.field_75151_b) {
            if (s.field_75224_c != inventory || !s.func_75214_a(result) || !s.func_75216_d()) continue;
            ItemStack dest = s.func_75211_c();
            if (this.canStackTogether(result, dest) && dest.func_190916_E() < s.func_178170_b(dest)) {
                int sum = dest.func_190916_E() + result.func_190916_E();
                int toDeposit = Math.min(s.func_178170_b(dest), sum);
                int remaining = sum - toDeposit;
                dest.func_190920_e(toDeposit);
                result.func_190920_e(remaining);
                s.func_75218_e();
            }
            if (!result.func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        for (Slot s : this.field_75151_b) {
            if (s.field_75224_c == inventory && s.func_75214_a(result) && !s.func_75216_d()) {
                s.func_75215_d(result.func_77979_a(s.func_75219_a()));
            }
            if (!result.func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return result;
    }

    public boolean canStackTogether(ItemStack src, ItemStack dest) {
        if (src.func_190926_b() || dest.func_190926_b()) {
            return false;
        }
        boolean compoundComparison = dest.func_77942_o() && src.func_77942_o() ? dest.func_77978_p().equals((Object)src.func_77978_p()) : !dest.func_77942_o() && !src.func_77942_o();
        return dest.func_77985_e() && dest.func_77973_b() == src.func_77973_b() && dest.func_77952_i() == src.func_77952_i() && compoundComparison && dest.areCapsCompatible(src);
    }

    public String getLocalizedName() {
        ITextComponent displayName = this.container.func_145748_c_();
        if (displayName == null) {
            return "Container";
        }
        return displayName.func_150261_e();
    }

    public boolean shouldDrawPanel() {
        return this.drawPanel;
    }

    public void setDrawPanel(boolean drawPanel) {
        this.drawPanel = drawPanel;
    }

    public int getColor() {
        return this.panelColor;
    }

    public void setColor(int color) {
        this.panelColor = color;
    }

    public int getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(int color) {
        this.titleColor = color;
    }

    public WPanel createPlayerInventoryPanel() {
        WPlainPanel inv = new WPlainPanel();
        inv.add(WItemSlot.ofPlayerStorage(this.playerInventory), 0, 0);
        inv.add(WItemSlot.of(this.playerInventory, 0, 9, 1), 0, 58);
        return inv;
    }

    static {
        ShadingValidator.ensureShaded();
    }
}

