/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.common.shape;

import com.elytradev.architecture.common.ArchitectureContent;
import com.elytradev.architecture.common.helpers.Utils;
import com.elytradev.architecture.common.helpers.Vector3;
import com.elytradev.architecture.common.shape.Shape;
import com.elytradev.architecture.common.tile.TileShape;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemShape
extends ItemBlock {
    static Random rand = new Random();

    public ItemShape(Block block) {
        super(block);
        this.func_77637_a(ArchitectureContent.SHAPE_TAB);
    }

    public boolean func_77614_k() {
        return true;
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!world.func_180501_a(pos, newState, 3)) {
            return false;
        }
        Vec3i d = Vector3.getDirectionVec(face);
        Vector3 hit = new Vector3((double)(hitX - (float)d.func_177958_n()) - 0.5, (double)(hitY - (float)d.func_177956_o()) - 0.5, (double)(hitZ - (float)d.func_177952_p()) - 0.5);
        TileShape te = TileShape.get((IBlockAccess)world, pos);
        if (te != null) {
            te.readFromItemStack(stack);
            if (te.shape != null) {
                BlockPos npos = te.func_174877_v().func_177972_a(face.func_176734_d());
                IBlockState nstate = world.func_180495_p(npos);
                TileEntity nte = world.func_175625_s(npos);
                te.shape.orientOnPlacement(player, te, npos, nstate, nte, face, hit);
            }
        }
        return true;
    }

    public boolean func_77651_p() {
        return true;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> lines, ITooltipFlag flagIn) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            int id = tag.func_74762_e("Shape");
            Shape shape = Shape.forId(id);
            if (shape != null) {
                lines.set(0, shape.title);
            } else {
                lines.set(0, lines.get(0) + " (" + id + ")");
            }
            Block baseBlock = Block.func_149684_b((String)tag.func_74779_i("BaseName"));
            int baseMetadata = tag.func_74762_e("BaseData");
            if (baseBlock != null) {
                lines.add(Utils.displayNameOfBlock(baseBlock, baseMetadata));
            }
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab.equals(ArchitectureContent.SHAPE_TAB)) {
            for (Shape shape : Shape.values()) {
                ItemStack defaultStack = new ItemStack((Item)this, 1);
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("Shape", shape.id);
                tag.func_74778_a("BaseName", Blocks.field_150344_f.getRegistryName().toString());
                tag.func_74768_a("BaseData", 0);
                defaultStack.func_77982_d(tag);
                items.add((Object)defaultStack);
            }
        }
    }

    public ItemStack func_190903_i() {
        ItemStack defaultStack = new ItemStack((Item)this, 1);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("Shape", Shape.ROOF_TILE.id);
        tag.func_74778_a("BaseName", Blocks.field_150344_f.getRegistryName().toString());
        tag.func_74768_a("BaseData", 0);
        defaultStack.func_77982_d(tag);
        return defaultStack;
    }
}

