/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.tabula.components;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import thut.core.client.render.animation.CapabilityAnimation;
import thut.core.client.render.model.IAnimationChanger;
import thut.core.client.render.model.IPartTexturer;
import thut.core.client.render.tabula.components.Animation;
import thut.core.client.render.tabula.components.AnimationComponent;
import thut.core.client.render.tabula.components.CubeGroup;
import thut.core.client.render.tabula.components.CubeInfo;
import thut.core.client.render.tabula.model.modelbase.TabulaModelBase;
import thut.core.client.render.tabula.model.modelbase.TabulaRenderer;
import thut.core.client.render.tabula.model.tabula.TabulaModel;

@SideOnly(value=Side.CLIENT)
public class ModelJson
extends TabulaModelBase {
    public TabulaModel tabulaModel;
    public Map<String, TabulaRenderer> nameMap = Maps.newHashMap();
    public Map<String, TabulaRenderer> identifierMap = Maps.newHashMap();
    ArrayList<String> groupIdents = Lists.newArrayList();
    public Map<String, Collection<TabulaRenderer>> groupMap = Maps.newHashMap();
    public HashMap<String, List<Animation>> animationMap = Maps.newHashMap();
    public IPartTexturer texturer;
    public IAnimationChanger changer;

    public ModelJson(TabulaModel model) {
        this.tabulaModel = model;
        this.field_78090_t = model.getTextureWidth();
        this.field_78089_u = model.getTextureHeight();
        ArrayList<Animation> animations = model.getAnimations();
        for (Animation animation : animations) {
            ArrayList anims = this.animationMap.get(animation.name);
            if (anims == null) {
                anims = Lists.newArrayList();
                this.animationMap.put(animation.name, anims);
            }
            anims.add((Animation)animation);
        }
        for (CubeInfo c : model.getCubes()) {
            this.cube(c, null, "null");
        }
        for (CubeGroup g : model.getCubeGroups()) {
            this.cubeGroup(g);
        }
        Collections.reverse(this.groupIdents);
        this.setInitPose();
    }

    private TabulaRenderer createModelRenderer(CubeInfo cubeInfo) {
        TabulaRenderer cube = new TabulaRenderer(this, cubeInfo.txOffset[0], cubeInfo.txOffset[1]);
        cube.name = cubeInfo.name;
        cube.identifier = cubeInfo.identifier;
        cube.func_78793_a((float)cubeInfo.position[0], (float)cubeInfo.position[1], (float)cubeInfo.position[2]);
        cube.field_78795_f = (float)Math.toRadians((float)cubeInfo.rotation[0]);
        cube.field_78796_g = (float)Math.toRadians((float)cubeInfo.rotation[1]);
        cube.field_78808_h = (float)Math.toRadians((float)cubeInfo.rotation[2]);
        if ((double)Math.abs(cube.field_78795_f) < 1.0E-6) {
            cube.field_78795_f = 0.0f;
        }
        if ((double)Math.abs(cube.field_78796_g) < 1.0E-6) {
            cube.field_78796_g = 0.0f;
        }
        if ((double)Math.abs(cube.field_78808_h) < 1.0E-6) {
            cube.field_78808_h = 0.0f;
        }
        cube.scaleX = (float)cubeInfo.scale[0];
        cube.scaleY = (float)cubeInfo.scale[1];
        cube.scaleZ = (float)cubeInfo.scale[2];
        cube.field_78809_i = cubeInfo.txMirror;
        cube.field_78807_k = cubeInfo.hidden;
        if (cubeInfo.metadata != null) {
            for (String s : cubeInfo.metadata) {
                if (!s.equalsIgnoreCase("trans")) continue;
                cube.transluscent = true;
            }
        }
        cube.func_78790_a((float)cubeInfo.offset[0], (float)cubeInfo.offset[1], (float)cubeInfo.offset[2], cubeInfo.dimensions[0], cubeInfo.dimensions[1], cubeInfo.dimensions[2], (float)cubeInfo.mcScale);
        return cube;
    }

    private void cube(CubeInfo cube, TabulaRenderer parent, String group) {
        TabulaRenderer modelRenderer = this.createModelRenderer(cube);
        this.nameMap.put(cube.name, modelRenderer);
        this.identifierMap.put(cube.identifier, modelRenderer);
        if (parent != null) {
            parent.func_78792_a(modelRenderer);
        }
        if (parent == null) {
            ArrayList cubes;
            if (this.groupMap.containsKey(group)) {
                cubes = (ArrayList)this.groupMap.get(group);
            } else {
                cubes = Lists.newArrayList();
                this.groupMap.put(group, cubes);
                this.groupIdents.add(group);
            }
            cubes.add(modelRenderer);
            Collections.sort(cubes, new Comparator<TabulaRenderer>(){

                @Override
                public int compare(TabulaRenderer o1, TabulaRenderer o2) {
                    String name1 = o1.name;
                    String name2 = o2.name;
                    if (o1.transluscent && !o2.transluscent) {
                        return 1;
                    }
                    if (o2.transluscent && !o1.transluscent) {
                        return -1;
                    }
                    return name1.compareTo(name2);
                }
            });
        }
        for (CubeInfo c : cube.children) {
            this.cube(c, modelRenderer, group);
        }
    }

    private void cubeGroup(CubeGroup group) {
        for (CubeInfo cube : group.cubes) {
            this.cube(cube, null, group.identifier);
        }
        for (CubeGroup c : group.cubeGroups) {
            this.cubeGroup(c);
        }
    }

    public TabulaRenderer getCube(String name) {
        return this.nameMap.get(name);
    }

    public boolean isAnimationInProgress(CapabilityAnimation.IAnimationHolder animate) {
        return !animate.getPlaying().isEmpty();
    }

    public void func_78088_a(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float scale) {
        this.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, rotationYaw, rotationPitch, scale, entity);
        double[] scales = this.tabulaModel.getScale();
        GL11.glScaled((double)scales[0], (double)scales[1], (double)scales[2]);
        for (String s : this.groupIdents) {
            Collection<TabulaRenderer> cubes = this.groupMap.get(s);
            for (TabulaRenderer cube : cubes) {
                if (cube == null) continue;
                if (this.texturer != null) {
                    this.texturer.bindObject(entity);
                }
                cube.setTexturer(this.texturer);
                cube.setAnimationChanger(this.changer);
                cube.render(0.0625f, entity);
            }
        }
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float rotationYaw, float rotationPitch, float scaleFactor, Entity entity) {
        super.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, rotationYaw, rotationPitch, scaleFactor, entity);
    }

    public void startAnimation(String id, CapabilityAnimation.IAnimationHolder animate) {
        if (!id.equals(animate.getCurrentAnimation())) {
            this.stopAnimation(animate);
        }
        if (animate.getPlaying().isEmpty()) {
            animate.setCurrentAnimation(id);
            List<Animation> anims = this.animationMap.get(id);
            if (anims == null) {
                this.stopAnimation(animate);
            } else {
                animate.getPlaying().addAll(anims);
            }
        }
    }

    public void startAnimation(List<Animation> list, CapabilityAnimation.IAnimationHolder animate) {
        if (list == null || list.isEmpty()) {
            this.stopAnimation(animate);
            return;
        }
        String name = list.get((int)0).name;
        if (!name.equals(animate.getCurrentAnimation())) {
            this.stopAnimation(animate);
        }
        if (animate.getPlaying().isEmpty()) {
            animate.setCurrentAnimation(name);
            List<Animation> anims = list;
            animate.getPlaying().addAll(anims);
        }
    }

    public void stopAnimation(CapabilityAnimation.IAnimationHolder animate) {
        animate.clean();
    }

    public void stopAnimation(Animation toStop, CapabilityAnimation.IAnimationHolder animate) {
        animate.getPlaying().remove(toStop);
        animate.setStep(toStop, 0);
    }

    public void updateAnimation(CapabilityAnimation.IAnimationHolder animate, Animation animation, int tick, float partialTick, float limbSwing) {
        int aniTick = animate.getStep(animation);
        if (aniTick == 0) {
            aniTick = tick;
        }
        float time1 = aniTick;
        float limbSpeedFactor = 2.0f;
        float time2 = 0.0f;
        int animationLength = animation.getLength();
        time2 = (time2 + limbSwing * limbSpeedFactor) % (float)animationLength;
        time1 = (time1 + partialTick) % (float)animationLength;
        animate.setStep(animation, tick);
        for (Map.Entry<String, ArrayList<AnimationComponent>> entry : animation.sets.entrySet()) {
            TabulaRenderer animating = this.identifierMap.get(entry.getKey());
            for (AnimationComponent component : entry.getValue()) {
                float f = component.limbBased ? time2 : time1;
                float time = f;
                if (!(time >= (float)component.startKey)) continue;
                float componentTimer = time - (float)component.startKey;
                if (componentTimer > (float)component.length) {
                    componentTimer = component.length;
                }
                animating.scaleX += (float)(component.scaleChange[0] / (double)component.length * (double)componentTimer);
                animating.scaleY += (float)(component.scaleChange[1] / (double)component.length * (double)componentTimer);
                animating.scaleZ += (float)(component.scaleChange[2] / (double)component.length * (double)componentTimer);
                animating.field_78800_c = (float)((double)animating.field_78800_c + component.posChange[0] / (double)component.length * (double)componentTimer);
                animating.field_78797_d = (float)((double)animating.field_78797_d + component.posChange[1] / (double)component.length * (double)componentTimer);
                animating.field_78798_e = (float)((double)animating.field_78798_e + component.posChange[2] / (double)component.length * (double)componentTimer);
                animating.field_78795_f = (float)((double)animating.field_78795_f + Math.toRadians(component.rotChange[0] / (double)component.length * (double)componentTimer));
                animating.field_78796_g = (float)((double)animating.field_78796_g + Math.toRadians(component.rotChange[1] / (double)component.length * (double)componentTimer));
                animating.field_78808_h = (float)((double)animating.field_78808_h + Math.toRadians(component.rotChange[2] / (double)component.length * (double)componentTimer));
                animating.field_78800_c = (float)((double)animating.field_78800_c + component.posOffset[0]);
                animating.field_78797_d = (float)((double)animating.field_78797_d + component.posOffset[1]);
                animating.field_78798_e = (float)((double)animating.field_78798_e + component.posOffset[2]);
                animating.field_78795_f = (float)((double)animating.field_78795_f + Math.toRadians(component.rotOffset[0]));
                animating.field_78796_g = (float)((double)animating.field_78796_g + Math.toRadians(component.rotOffset[1]));
                animating.field_78808_h = (float)((double)animating.field_78808_h + Math.toRadians(component.rotOffset[2]));
            }
        }
    }
}

