/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thut.core.client.render.tabula.components.Animation;

public class CapabilityAnimation {
    private static final Set<Class<? extends Entity>> ANIMATE = Sets.newHashSet();
    private static final ResourceLocation ANIM = new ResourceLocation("thutcore:animations");
    @CapabilityInject(value=IAnimationHolder.class)
    public static final Capability<IAnimationHolder> CAPABILITY = null;

    public static void setup() {
        CapabilityManager.INSTANCE.register(IAnimationHolder.class, (Capability.IStorage)new Capability.IStorage<IAnimationHolder>(){

            public NBTBase writeNBT(Capability<IAnimationHolder> capability, IAnimationHolder instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<IAnimationHolder> capability, IAnimationHolder instance, EnumFacing side, NBTBase nbt) {
            }
        }, DefaultImpl::new);
        MinecraftForge.EVENT_BUS.register(CapabilityAnimation.class);
    }

    public static void registerAnimateClass(Class<? extends Entity> clazz) {
        ANIMATE.add(clazz);
    }

    @SubscribeEvent
    public static void attachCap(AttachCapabilitiesEvent<Entity> event) {
        if (ANIMATE.contains(((Entity)event.getObject()).getClass())) {
            event.addCapability(ANIM, (ICapabilityProvider)new DefaultImpl());
        }
    }

    public static class DefaultImpl
    implements IAnimationHolder,
    ICapabilityProvider {
        Map<UUID, Integer> stepsMap = Maps.newHashMap();
        Set<Animation> playing = Sets.newHashSet();
        private String pending;
        private String current;

        @Override
        public int getStep(Animation animation) {
            if (this.stepsMap.containsKey(animation.id)) {
                return this.stepsMap.get(animation.id);
            }
            return 0;
        }

        @Override
        public void setStep(Animation animation, int step) {
            this.stepsMap.put(animation.id, step);
        }

        @Override
        public void clean() {
            this.stepsMap.clear();
            this.current = null;
            this.pending = null;
            this.playing.clear();
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (this.hasCapability(capability, facing)) {
                return (T)CAPABILITY.cast((Object)this);
            }
            return null;
        }

        @Override
        public void setPendingAnimation(String name) {
            this.pending = name;
        }

        @Override
        public String getPendingAnimation() {
            return this.pending;
        }

        @Override
        public Set<Animation> getPlaying() {
            return this.playing;
        }

        @Override
        public void setCurrentAnimation(String name) {
            this.current = name;
        }

        @Override
        public String getCurrentAnimation() {
            return this.current;
        }
    }

    public static interface IAnimationHolder {
        public void setPendingAnimation(String var1);

        public String getPendingAnimation();

        public void setCurrentAnimation(String var1);

        public String getCurrentAnimation();

        public int getStep(Animation var1);

        public void setStep(Animation var1, int var2);

        public Set<Animation> getPlaying();

        public void clean();
    }
}

