/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.util;

public enum WootColor {
    BLACK(0x191919),
    RED(0xCC4C4C),
    GREEN(6717235),
    BROWN(8349260),
    BLUE(0x3366CC),
    PURPLE(11691749),
    CYAN(5020034),
    LIGHTGRAY(0x999999),
    GRAY(0x4C4C4C),
    PINK(15905484),
    LIME(8375321),
    YELLOW(0xE5E533),
    LIGHTBLUE(10072818),
    MAGENTA(15040472),
    ORANGE(15905331),
    WHITE(0xFFFFFF);

    public static WootColor[] VALID_COLORS;
    private int v;
    private float red;
    private float green;
    private float blue;

    public static WootColor getColor(int id) {
        if (id >= 0 && id < VALID_COLORS.length) {
            return VALID_COLORS[id];
        }
        return WHITE;
    }

    private WootColor(int v) {
        this.v = v;
        this.red = (v & 0xFF0000) >> 16 & 0xFF;
        this.green = (v & 0xFF00) >> 8 & 0xFF;
        this.blue = v & 0xFF;
        this.red /= 255.0f;
        this.green /= 255.0f;
        this.blue /= 255.0f;
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public int getV() {
        return this.v;
    }

    public WootColor getNext() {
        int next = this.ordinal();
        if (++next < 0 || next >= VALID_COLORS.length) {
            next = 0;
        }
        return VALID_COLORS[next];
    }

    public String toString() {
        return super.toString() + " " + this.v + " R:" + this.red + " G:" + this.getGreen() + " B:" + this.getBlue();
    }

    static {
        VALID_COLORS = new WootColor[]{BLACK, RED, GREEN, BROWN, BLUE, PURPLE, CYAN, LIGHTGRAY, GRAY, PINK, LIME, YELLOW, LIGHTBLUE, MAGENTA, ORANGE, WHITE};
    }
}

