/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.plugins.bloodmagic;

import WayofTime.bloodmagic.api.impl.BloodMagicAPI;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.tile.TileDemonCrystal;
import ipsis.Woot;
import ipsis.woot.plugins.bloodmagic.BloodMagicHelper;
import ipsis.woot.plugins.bloodmagic.IBloodMagicHandler;
import ipsis.woot.tileentity.TileEntityMobFactoryHeart;
import ipsis.woot.util.DebugSetup;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

@RitualRegister(value="ritualClonedSoul")
public class RitualClonedSoul
extends Ritual {
    private static final String RITUAL_NAME = "ritualClonedSoul";
    private static final int CRYSTAL_LEVEL = 0;
    private static final int ACTIVATION_COST = 40000;
    private static final int REFRESH_COST = 2;
    private static final int REFRESH_TIME = 25;
    private static final int HEALTH_THRESHOLD = 20;
    private static final String HEART_RANGE = "heart";
    private static final String CRYSTAL_RANGE = "crystal";
    private double crystalBuffer = 0.0;
    private double willBuffer = 0.0;
    private BlockPos heartOffsetPos = new BlockPos(0, 0, 0);
    private static final String WILL_TAG = "willBuffer";
    private static final String CRYSTAL_TAG = "crystalBuffer";

    public RitualClonedSoul() {
        super(RITUAL_NAME, 0, 40000, "ritual.woot.ritualClonedSoul");
        this.addBlockRange(CRYSTAL_RANGE, (AreaDescriptor)new AreaDescriptor.Rectangle(new BlockPos(-3, 2, -3), 7, 5, 7));
        this.addBlockRange(HEART_RANGE, (AreaDescriptor)new AreaDescriptor.Rectangle(new BlockPos(-10, -10, -10), 21));
        this.setMaximumVolumeAndDistanceOfRange(CRYSTAL_RANGE, 250, 5, 7);
        this.setMaximumVolumeAndDistanceOfRange(HEART_RANGE, 0, 15, 15);
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.willBuffer = tag.func_74769_h(WILL_TAG);
        this.crystalBuffer = tag.func_74769_h(CRYSTAL_TAG);
    }

    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74780_a(WILL_TAG, this.willBuffer);
        tag.func_74780_a(CRYSTAL_TAG, this.crystalBuffer);
    }

    private boolean isValidFactory(TileEntity te) {
        if (!(te instanceof TileEntityMobFactoryHeart)) {
            return false;
        }
        TileEntityMobFactoryHeart heart = (TileEntityMobFactoryHeart)te;
        return heart.getRunning() == 1;
    }

    private IBloodMagicHandler findHandler(World world, BlockPos pos) {
        BlockPos heartPos = pos.func_177971_a((Vec3i)this.heartOffsetPos);
        TileEntity te = world.func_175625_s(heartPos);
        AreaDescriptor heartRange = this.getBlockRange(HEART_RANGE);
        if (!heartRange.isWithinArea(this.heartOffsetPos) || !this.isValidFactory(te)) {
            for (BlockPos newPos : heartRange.getContainedPositions(pos)) {
                TileEntity nextTile = world.func_175625_s(newPos);
                if (!(nextTile instanceof IBloodMagicHandler)) continue;
                te = nextTile;
                this.heartOffsetPos = newPos.func_177973_b((Vec3i)pos);
                heartRange.resetCache();
                break;
            }
        }
        return this.isValidFactory(te) && te instanceof IBloodMagicHandler ? (IBloodMagicHandler)te : null;
    }

    public void performRitual(IMasterRitualStone masterRitualStone) {
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_BM_CRYSTAL, "performRitual - ClonedSoul", "");
        if (!BloodMagicHelper.canPerformRitual(masterRitualStone, this.getRefreshCost())) {
            return;
        }
        BlockPos pos = masterRitualStone.getBlockPos();
        World world = masterRitualStone.getWorldObj();
        int maxEffects = 100;
        int totalEffects = 0;
        IBloodMagicHandler bloodMagicHandler = this.findHandler(world, masterRitualStone.getBlockPos());
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_BM_CRYSTAL, "performRitual - ClonedSoul", bloodMagicHandler);
        if (bloodMagicHandler != null && bloodMagicHandler.getCrystalNumMobs() > 0 && bloodMagicHandler.getWootMobName() != null && !BloodMagicAPI.INSTANCE.getBlacklist().getSacrifice().contains(bloodMagicHandler.getWootMobName().getResourceLocation())) {
            ArrayList<TileDemonCrystal> crystalList = new ArrayList<TileDemonCrystal>();
            AreaDescriptor crystalRange = this.getBlockRange(CRYSTAL_RANGE);
            crystalRange.resetIterator();
            while (crystalRange.hasNext()) {
                BlockPos nextPos = ((BlockPos)crystalRange.next()).func_177971_a((Vec3i)pos);
                TileEntity te = world.func_175625_s(nextPos);
                if (!(te instanceof TileDemonCrystal)) continue;
                crystalList.add((TileDemonCrystal)te);
            }
            int health = Woot.mobCosting.getMobSpawnCost(world, bloodMagicHandler.getWootMobName());
            if (health > 0) {
                int realHealth = (int)((float)health / 100.0f * (float)bloodMagicHandler.getCrystalMobHealthPercentage());
                Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_BM_CRYSTAL, "performRitual - ClonedSoul", "health:" + health + "/" + realHealth);
                health = realHealth;
                for (int mob = 0; mob < bloodMagicHandler.getCrystalNumMobs(); ++mob) {
                    this.feedWillAndCrystal(health);
                    if (++totalEffects >= maxEffects) break;
                }
                if (!crystalList.isEmpty() && this.crystalBuffer > 0.0) {
                    Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_BM_CRYSTAL, "performRitual - ClonedSoul", "crystals:" + crystalList.size());
                    TileDemonCrystal crystal = (TileDemonCrystal)crystalList.get(world.field_73012_v.nextInt(crystalList.size()));
                    this.tryFeedTheCrystal(crystal);
                }
            }
            bloodMagicHandler.clearCrystalNumMobs();
        }
        masterRitualStone.getOwnerNetwork().syphon(this.getRefreshCost() * totalEffects);
    }

    private void feedWillAndCrystal(int mobHealth) {
        boolean uniqueness = true;
        double modifier = 1.0;
        double willForUniqueness = Math.max(50.0 - 15.0 * Math.sqrt((double)uniqueness), 0.0);
        double willBufferInc = modifier * willForUniqueness / 20.0 * (double)mobHealth;
        double crystalBufferInc = modifier * (double)mobHealth / 20.0;
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_BM_CRYSTAL, "performRitual - ClonedSoul", "feedWillAndCrystal health:" + mobHealth + " willInc:" + willBufferInc + " crystalInc:" + crystalBufferInc);
        this.willBuffer += willBufferInc;
        this.crystalBuffer += crystalBufferInc;
    }

    private void tryFeedTheCrystal(TileDemonCrystal crystal) {
        if (crystal == null) {
            return;
        }
        double growth = Math.min(this.crystalBuffer, 1.0);
        double willSyphonAmount = growth * this.willBuffer / this.crystalBuffer;
        double willDrain = growth * this.willBuffer / this.crystalBuffer;
        double progressPercentage = growth;
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_BM_CRYSTAL, "performRitual - ClonedSoul", "tryFeedTheCrystal willDrain:" + willDrain + " progress:" + progressPercentage);
        double actualGrowthPercentage = crystal.growCrystalWithWillAmount(willDrain, progressPercentage);
        if (actualGrowthPercentage > 0.0) {
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_BM_CRYSTAL, "performRitual - ClonedSoul", "tryFeedTheCrystal grew:" + actualGrowthPercentage);
            this.crystalBuffer -= actualGrowthPercentage;
            this.willBuffer -= actualGrowthPercentage * willSyphonAmount;
        }
    }

    public int getRefreshCost() {
        return 2;
    }

    public int getRefreshTime() {
        return 25;
    }

    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 0, EnumRuneType.AIR);
        this.addParallelRunes(components, 1, 0, EnumRuneType.DUSK);
        this.addCornerRunes(components, 2, 0, EnumRuneType.EARTH);
        this.addParallelRunes(components, 2, 0, EnumRuneType.FIRE);
        this.addCornerRunes(components, 2, 1, EnumRuneType.FIRE);
        this.addCornerRunes(components, 2, 2, EnumRuneType.EARTH);
        this.addParallelRunes(components, 3, 1, EnumRuneType.FIRE);
        this.addParallelRunes(components, 3, 2, EnumRuneType.FIRE);
        this.addCornerRunes(components, 4, 2, EnumRuneType.EARTH);
    }

    public Ritual getNewCopy() {
        return new RitualClonedSoul();
    }
}

