/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.event;

import ipsis.woot.item.ItemEnderShard;
import ipsis.woot.util.WootMobName;
import ipsis.woot.util.WootMobNameBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HandlerLivingDeathEvent {
    private final int MAX_UUID_CACHE_SIZE = 10;
    private List<String> uuidList = new ArrayList<String>();

    private boolean ignoreDeathEvent(Entity entity) {
        String uuid = entity.func_189512_bd();
        if (this.uuidList.contains(uuid)) {
            return true;
        }
        this.uuidList.add(uuid);
        if (this.uuidList.size() > 10) {
            this.uuidList.remove(0);
        }
        return false;
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        World world = event.getEntity().func_130014_f_();
        if (world.field_72995_K) {
            return;
        }
        if (!(event.getSource().func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        if (event.getEntityLiving() == null) {
            return;
        }
        EntityPlayer entityPlayer = (EntityPlayer)event.getSource().func_76346_g();
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        if (entityPlayer instanceof FakePlayer) {
            return;
        }
        if (!(entityLivingBase instanceof EntityLiving)) {
            return;
        }
        if (this.ignoreDeathEvent(event.getEntity())) {
            return;
        }
        WootMobName wootMobName = WootMobNameBuilder.create((EntityLiving)entityLivingBase);
        if (!wootMobName.isValid()) {
            return;
        }
        ItemStack itemStack = HandlerLivingDeathEvent.findPrism(entityPlayer, wootMobName);
        if (!itemStack.func_190926_b()) {
            ItemEnderShard.incrementDeaths(itemStack, 1);
        }
    }

    private static ItemStack findPrism(EntityPlayer entityPlayer, WootMobName wootMobName) {
        ItemStack foundStack = ItemStack.field_190927_a;
        for (int i = 0; i <= 8; ++i) {
            ItemStack itemStack = entityPlayer.field_71071_by.func_70301_a(i);
            if (itemStack.func_190926_b() || !ItemEnderShard.isMob(itemStack, wootMobName)) continue;
            foundStack = itemStack;
            break;
        }
        return foundStack;
    }
}

