/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.api.configurator;

import net.minecraft.nbt.NBTTagCompound;
import sonar.core.translate.Localisation;
import sonar.flux.FluxTranslate;
import sonar.flux.api.AdditionType;
import sonar.flux.api.ConnectionSettings;
import sonar.flux.api.EnumActivationType;
import sonar.flux.api.EnumPriorityType;
import sonar.flux.api.RemovalType;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.common.tileentity.TileFlux;
import sonar.flux.network.FluxNetworkCache;

public class FluxConfigurationType {
    public static FluxConfigurationType NETWORK = new FluxConfigurationType(0, "network", FluxTranslate.NETWORK_NAME, FluxConfigurationType::copyNetwork, FluxConfigurationType::pasteNetwork);
    public static FluxConfigurationType REDSTONE_SETTING = new FluxConfigurationType(1, "r_setting", FluxTranslate.ENABLE_LIMIT, FluxConfigurationType::copyRedstoneSetting, FluxConfigurationType::pasteRedstoneSetting);
    public static FluxConfigurationType PRIORITY = new FluxConfigurationType(2, "priority", FluxTranslate.PRIORITY, FluxConfigurationType::copyPriority, FluxConfigurationType::pastePriority);
    public static FluxConfigurationType PRIORITY_SETTING = new FluxConfigurationType(3, "p_setting", FluxTranslate.PRIORITY_MODE, FluxConfigurationType::copyPrioritySetting, FluxConfigurationType::pastePrioritySetting);
    public static FluxConfigurationType TRANSFER = new FluxConfigurationType(4, "transfer", FluxTranslate.TRANSFER_LIMIT, FluxConfigurationType::copyTransfer, FluxConfigurationType::pasteTransfer);
    public static FluxConfigurationType TRANSFER_SETTING = new FluxConfigurationType(5, "t_setting", FluxTranslate.ENABLE_LIMIT, FluxConfigurationType::copyTransferSetting, FluxConfigurationType::pasteTransferSetting);
    public static FluxConfigurationType[] VALUES = new FluxConfigurationType[]{NETWORK, REDSTONE_SETTING, PRIORITY, PRIORITY_SETTING, TRANSFER, TRANSFER_SETTING};
    public int ordinal;
    public String key;
    public Localisation translate;
    public ICopyMethod copy;
    public IPasteMethod paste;

    public FluxConfigurationType(int ordinal, String key, Localisation translate, ICopyMethod copy, IPasteMethod paste) {
        this.ordinal = ordinal;
        this.key = key;
        this.translate = translate;
        this.copy = copy;
        this.paste = paste;
    }

    public String getNBTName() {
        return this.key;
    }

    public static void copyNetwork(NBTTagCompound nbt, String key, TileFlux tile) {
        if (!tile.getNetwork().isFakeNetwork() && tile.getNetworkID() != -1) {
            nbt.func_74768_a(key, tile.getNetworkID());
        }
    }

    public static void pasteNetwork(NBTTagCompound nbt, String key, TileFlux tile) {
        int storedID = nbt.func_74762_e(key);
        if (storedID != -1) {
            IFluxNetwork newNetwork = FluxNetworkCache.instance().getNetwork(storedID);
            tile.getNetwork().queueConnectionRemoval(tile, RemovalType.REMOVE);
            newNetwork.queueConnectionAddition(tile, AdditionType.ADD);
        }
    }

    public static void copyRedstoneSetting(NBTTagCompound nbt, String key, TileFlux tile) {
        nbt.func_74768_a(key, ((EnumActivationType)((Object)tile.activation_type.getValue())).ordinal());
    }

    public static void pasteRedstoneSetting(NBTTagCompound nbt, String key, TileFlux tile) {
        tile.activation_type.setValue((Object)EnumActivationType.values()[nbt.func_74762_e(key)]);
    }

    public static void copyPriority(NBTTagCompound nbt, String key, TileFlux tile) {
        nbt.func_74768_a(key, ((Integer)tile.priority.getValue()).intValue());
    }

    public static void pastePriority(NBTTagCompound nbt, String key, TileFlux tile) {
        tile.priority.setValue((Object)nbt.func_74762_e(key));
        tile.markSettingChanged(ConnectionSettings.PRIORITY);
    }

    public static void copyPrioritySetting(NBTTagCompound nbt, String key, TileFlux tile) {
        nbt.func_74768_a(key, ((EnumPriorityType)((Object)tile.priority_type.getValue())).ordinal());
    }

    public static void pastePrioritySetting(NBTTagCompound nbt, String key, TileFlux tile) {
        tile.priority_type.setValue((Object)EnumPriorityType.values()[nbt.func_74762_e(key)]);
    }

    public static void copyTransfer(NBTTagCompound nbt, String key, TileFlux tile) {
        nbt.func_74772_a(key, ((Long)tile.limit.getValue()).longValue());
    }

    public static void pasteTransfer(NBTTagCompound nbt, String key, TileFlux tile) {
        tile.limit.setValue((Object)nbt.func_74763_f(key));
        tile.markSettingChanged(ConnectionSettings.TRANSFER_LIMIT);
    }

    public static void copyTransferSetting(NBTTagCompound nbt, String key, TileFlux tile) {
        nbt.func_74757_a(key, ((Boolean)tile.disableLimit.getValue()).booleanValue());
    }

    public static void pasteTransferSetting(NBTTagCompound nbt, String key, TileFlux tile) {
        tile.disableLimit.setValue((Object)nbt.func_74767_n(key));
        tile.markSettingChanged(ConnectionSettings.TRANSFER_LIMIT);
    }

    public static interface IPasteMethod<T> {
        public void pasteToTile(NBTTagCompound var1, String var2, TileFlux var3);
    }

    public static interface ICopyMethod<T> {
        public void copyFromTile(NBTTagCompound var1, String var2, TileFlux var3);
    }
}

