/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.tileentity;

import com.minemaarten.signals.rail.network.mc.MCPos;
import com.minemaarten.signals.tileentity.TileEntityRailLinkBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityTeleportRail
extends TileEntityRailLinkBase {
    @Override
    protected boolean isDestinationValid(MCPos destination, EntityPlayer player) {
        if (this.func_145831_w().field_73011_w.getDimension() == destination.getDimID()) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("signals.message.teleport_rail_failed_same_dimension", new Object[]{destination.getX(), destination.getY(), destination.getZ()}));
            return false;
        }
        Pair<MCPos, MCPos> allowedDestinationRange = this.getAllowedDestinationRange(destination.getWorld());
        if (allowedDestinationRange == null) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("signals.message.teleport_rail_failed_unloaded_destination_dimension", new Object[]{destination.getX(), destination.getY(), destination.getZ()}));
            return false;
        }
        if (destination.isInAABB((MCPos)allowedDestinationRange.getLeft(), (MCPos)allowedDestinationRange.getRight())) {
            return true;
        }
        player.func_145747_a((ITextComponent)new TextComponentTranslation("signals.message.teleport_rail_failed_invalid_location", new Object[]{destination.getX(), destination.getY(), destination.getZ(), ((MCPos)allowedDestinationRange.getLeft()).getX(), ((MCPos)allowedDestinationRange.getRight()).getX(), ((MCPos)allowedDestinationRange.getLeft()).getZ(), ((MCPos)allowedDestinationRange.getRight()).getZ()}));
        return false;
    }

    public Pair<MCPos, MCPos> getAllowedDestinationRange(World destinationDimension) {
        if (destinationDimension == null) {
            return null;
        }
        double moveFactor = this.func_145831_w().field_73011_w.getMovementFactor() / destinationDimension.field_73011_w.getMovementFactor();
        double destX = MathHelper.func_151237_a((double)((double)this.func_174877_v().func_177958_n() * moveFactor), (double)(destinationDimension.func_175723_af().func_177726_b() + 16.0), (double)(destinationDimension.func_175723_af().func_177728_d() - 16.0));
        double destZ = MathHelper.func_151237_a((double)((double)this.func_174877_v().func_177952_p() * moveFactor), (double)(destinationDimension.func_175723_af().func_177736_c() + 16.0), (double)(destinationDimension.func_175723_af().func_177733_e() - 16.0));
        destX = MathHelper.func_76125_a((int)((int)destX), (int)-29999872, (int)29999872);
        destZ = MathHelper.func_76125_a((int)((int)destZ), (int)-29999872, (int)29999872);
        int maxDiff = 8;
        MCPos min = new MCPos(destinationDimension, new BlockPos(destX - (double)maxDiff, 0.0, destZ - (double)maxDiff));
        MCPos max = new MCPos(destinationDimension, new BlockPos(destX + (double)maxDiff, (double)destinationDimension.func_72940_L(), destZ + (double)maxDiff));
        return new ImmutablePair((Object)min, (Object)max);
    }
}

