/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.tileentity;

import com.google.common.collect.Lists;
import com.minemaarten.signals.api.ICartHopperBehaviour;
import com.minemaarten.signals.api.IRail;
import com.minemaarten.signals.api.access.ICartHopper;
import com.minemaarten.signals.capabilities.CapabilityMinecartDestination;
import com.minemaarten.signals.init.ModBlocks;
import com.minemaarten.signals.network.GuiSynced;
import com.minemaarten.signals.rail.RailManager;
import com.minemaarten.signals.rail.network.mc.RailNetworkManager;
import com.minemaarten.signals.tileentity.IGUIButtonSensitive;
import com.minemaarten.signals.tileentity.TileEntityBase;
import com.minemaarten.signals.tileentity.carthopperbehaviour.CartHopperBehaviourItems;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class TileEntityCartHopper
extends TileEntityBase
implements ITickable,
IGUIButtonSensitive,
ICartHopper {
    @GuiSynced
    private ICartHopper.HopperMode hopperMode = ICartHopper.HopperMode.CART_FULL;
    @GuiSynced
    private boolean interactEngine;
    private EnumFacing pushDir = EnumFacing.NORTH;
    private EntityMinecart managingCart;
    private UUID managingCartId;
    private boolean pushedLastTick;
    private int lastComparatorInputOverride;
    private boolean firstTick = true;
    private boolean extract;

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74774_a("hopperMode", (byte)this.hopperMode.ordinal());
        tag.func_74757_a("interactEngine", this.interactEngine);
        tag.func_74774_a("pushDir", (byte)this.pushDir.ordinal());
        tag.func_74757_a("pushedLastTick", this.pushedLastTick);
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.hopperMode = ICartHopper.HopperMode.values()[tag.func_74771_c("hopperMode")];
        this.interactEngine = tag.func_74767_n("interactEngine");
        this.pushDir = EnumFacing.field_82609_l[tag.func_74771_c("pushDir")];
        this.pushedLastTick = tag.func_74767_n("pushedLastTick");
    }

    public void updateCartAbove() {
        boolean hasNetworkRailAbove;
        boolean bl = hasNetworkRailAbove = RailNetworkManager.getInstance(this.field_145850_b.field_72995_K).getRail(this.func_145831_w(), this.func_174877_v().func_177984_a()) != null;
        if (hasNetworkRailAbove) {
            this.extract = true;
        } else {
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v().func_177984_a());
            IRail r = RailManager.getInstance().getRail(this.field_145850_b, this.func_174877_v().func_177984_a(), state);
            this.extract = r != null;
        }
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            int comparatorInputOverride;
            if (this.firstTick) {
                this.firstTick = false;
                this.updateCartAbove();
            }
            if (this.managingCartId != null) {
                List carts = this.func_145831_w().func_175644_a(EntityMinecart.class, input -> input.getPersistentID().equals(this.managingCartId));
                this.managingCart = carts.isEmpty() ? null : (EntityMinecart)carts.get(0);
                this.managingCartId = null;
            }
            this.updateManagingCart(new AxisAlignedBB(this.extract ? this.func_174877_v().func_177984_a() : this.func_174877_v().func_177977_b()));
            boolean shouldPush = this.managingCart != null ? (this.isDisabled() ? true : this.tryTransfer(this.extract)) : false;
            if (shouldPush && !this.pushedLastTick) {
                this.pushCart();
            }
            boolean notifyNeighbors = shouldPush != this.pushedLastTick;
            this.pushedLastTick = shouldPush;
            if (notifyNeighbors) {
                this.func_145831_w().func_175685_c(this.func_174877_v(), this.func_145838_q(), true);
            }
            if (this.lastComparatorInputOverride != (comparatorInputOverride = this.getComparatorInputOverride())) {
                this.field_145850_b.func_175666_e(this.field_174879_c, ModBlocks.CART_HOPPER);
                this.lastComparatorInputOverride = comparatorInputOverride;
            }
        }
    }

    private boolean isDisabled() {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (this.func_145831_w().func_175651_c(this.field_174879_c.func_177972_a(facing), facing) <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean emitsRedstone() {
        return this.pushedLastTick;
    }

    @Override
    public ICartHopper.HopperMode getHopperMode() {
        return this.hopperMode;
    }

    @Override
    public void setHopperMode(ICartHopper.HopperMode hopperMode) {
        Validate.notNull((Object)((Object)hopperMode));
        this.hopperMode = hopperMode;
    }

    @Override
    public boolean isInteractingWithEngine() {
        return this.interactEngine;
    }

    @Override
    public void setInteractingWithEngine(boolean interactWithEngine) {
        this.interactEngine = interactWithEngine;
    }

    private void pushCart() {
        this.managingCart.field_70159_w += (double)this.pushDir.func_82601_c() * 0.1;
        this.managingCart.field_70179_y += (double)this.pushDir.func_82599_e() * 0.1;
    }

    private boolean tryTransfer(boolean extract) {
        boolean active = false;
        boolean empty = false;
        boolean full = false;
        ArrayList filters = Lists.newArrayList();
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            TileEntity filter = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(dir));
            if (filter == null) continue;
            filters.add(new ImmutablePair((Object)filter, (Object)dir));
        }
        for (ICartHopperBehaviour iCartHopperBehaviour : this.getApplicableHopperBehaviours(this.managingCart)) {
            Capability cap = iCartHopperBehaviour.getCapability();
            Object cart = null;
            if (this.interactEngine && iCartHopperBehaviour instanceof CartHopperBehaviourItems) {
                if (!this.managingCart.hasCapability(CapabilityMinecartDestination.INSTANCE, null)) continue;
                cart = ((CapabilityMinecartDestination)this.managingCart.getCapability(CapabilityMinecartDestination.INSTANCE, null)).getEngineItemHandler();
            } else {
                cart = this.managingCart.getCapability(cap, null);
            }
            Object te = this.getCapabilityAt(cap, extract ? EnumFacing.DOWN : EnumFacing.UP);
            if (te != null && iCartHopperBehaviour.tryTransfer(extract ? cart : te, extract ? te : cart, filters)) {
                active = true;
            }
            if (this.hopperMode == ICartHopper.HopperMode.CART_EMPTY && iCartHopperBehaviour.isCartEmpty(cart, filters)) {
                empty = true;
            }
            if (this.hopperMode != ICartHopper.HopperMode.CART_FULL || !iCartHopperBehaviour.isCartFull(cart)) continue;
            full = true;
        }
        return this.hopperMode == ICartHopper.HopperMode.NO_ACTIVITY ? !active : empty || full;
    }

    private List<ICartHopperBehaviour<?>> getApplicableHopperBehaviours(EntityMinecart cart) {
        Stream<Object> behaviours = RailManager.getInstance().getHopperBehaviours().stream();
        behaviours = behaviours.filter(hopperBehaviour -> this.interactEngine && hopperBehaviour instanceof CartHopperBehaviourItems || this.managingCart.hasCapability(hopperBehaviour.getCapability(), null));
        return behaviours.collect(Collectors.toList());
    }

    private void updateManagingCart(AxisAlignedBB aabb) {
        List carts;
        if (this.managingCart != null && (this.managingCart.field_70128_L || !this.managingCart.func_174813_aQ().func_72326_a(aabb))) {
            this.managingCart = null;
        }
        if (this.managingCart == null && !(carts = this.func_145831_w().func_72872_a(EntityMinecart.class, aabb)).isEmpty()) {
            this.managingCart = (EntityMinecart)carts.get(0);
            this.pushDir = this.managingCart.func_184172_bi();
        }
    }

    private <T> T getCapabilityAt(Capability<T> cap, EnumFacing dir) {
        BlockPos pos = this.func_174877_v().func_177972_a(dir);
        TileEntity te = this.func_145831_w().func_175625_s(pos);
        return (T)(te != null && te.hasCapability(cap, dir.func_176734_d()) ? te.getCapability(cap, dir.func_176734_d()) : null);
    }

    @Override
    public void handleGUIButtonPress(EntityPlayer player, int ... data) {
        switch (data[0]) {
            case 0: {
                this.hopperMode = ICartHopper.HopperMode.values()[(this.hopperMode.ordinal() + 1) % ICartHopper.HopperMode.values().length];
                break;
            }
            case 1: {
                this.interactEngine = !this.interactEngine;
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getCapability(capability, facing) != null;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.managingCart != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.interactEngine) {
                CapabilityMinecartDestination destCap = (CapabilityMinecartDestination)this.managingCart.getCapability(CapabilityMinecartDestination.INSTANCE, null);
                if (destCap != null) {
                    return (T)destCap.getEngineItemHandler();
                }
            } else if (this.managingCart.hasCapability(capability, null)) {
                return (T)this.managingCart.getCapability(capability, null);
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getComparatorInputOverride() {
        if (this.managingCart != null) {
            if (this.interactEngine) {
                CapabilityMinecartDestination destCap = (CapabilityMinecartDestination)this.managingCart.getCapability(CapabilityMinecartDestination.INSTANCE, null);
                if (destCap != null && destCap.isMotorized()) {
                    return Container.func_94526_b((IInventory)destCap.getFuelInv());
                }
                return 0;
            }
            int comparatorValue = 0;
            for (ICartHopperBehaviour<?> hopperBehaviour : this.getApplicableHopperBehaviours(this.managingCart)) {
                Capability<?> cap = hopperBehaviour.getCapability();
                Object capabilityValue = this.managingCart.getCapability(cap, null);
                if (capabilityValue == null) continue;
                int behaviourComparatorValue = hopperBehaviour.getComparatorInputOverride(capabilityValue);
                comparatorValue = Math.max(comparatorValue, behaviourComparatorValue);
            }
            return comparatorValue;
        }
        return 0;
    }
}

