/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network.mc;

import com.minemaarten.signals.rail.network.EnumHeading;
import com.minemaarten.signals.rail.network.IPosition;
import com.minemaarten.signals.rail.network.NetworkSignal;
import com.minemaarten.signals.rail.network.mc.ISerializableNetworkObject;
import com.minemaarten.signals.rail.network.mc.MCPos;
import com.minemaarten.signals.rail.network.mc.NetworkSerializer;
import com.minemaarten.signals.rail.network.mc.RailNetworkManager;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;

public class MCNetworkSignal
extends NetworkSignal<MCPos>
implements ISerializableNetworkObject {
    public MCNetworkSignal(MCPos pos, EnumHeading heading, NetworkSignal.EnumSignalType type) {
        super(pos, heading, type);
    }

    public static MCNetworkSignal fromTag(NBTTagCompound tag) {
        byte b = tag.func_74771_c("t");
        return new MCNetworkSignal(new MCPos(tag), MCNetworkSignal.decodeHeadingFromByte(b), MCNetworkSignal.decodeSignalTypeFromByte(b));
    }

    public static MCNetworkSignal fromByteBuf(ByteBuf buf) {
        MCPos pos = new MCPos(buf);
        byte b = buf.readByte();
        return new MCNetworkSignal(pos, MCNetworkSignal.decodeHeadingFromByte(b), MCNetworkSignal.decodeSignalTypeFromByte(b));
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        ((MCPos)this.getPos()).writeToNBT(tag);
        tag.func_74774_a("t", this.encodeToByte());
    }

    @Override
    public void writeToBuf(ByteBuf b) {
        ((MCPos)this.getPos()).writeToBuf(b);
        b.writeByte((int)this.encodeToByte());
    }

    private byte encodeToByte() {
        return (byte)(this.type.ordinal() << 4 | this.heading.ordinal());
    }

    private static EnumHeading decodeHeadingFromByte(byte b) {
        return EnumHeading.VALUES[b & 0xF];
    }

    private static NetworkSignal.EnumSignalType decodeSignalTypeFromByte(byte b) {
        return NetworkSignal.EnumSignalType.VALUES[b >> 4];
    }

    @Override
    public int getColor() {
        return RailNetworkManager.getClientInstance().getState().getLampStatus((IPosition)this.getPos()).color;
    }

    @Override
    public NetworkSerializer.EnumNetworkObject getType() {
        return NetworkSerializer.EnumNetworkObject.SIGNAL;
    }
}

