/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network.mc;

import com.google.common.collect.ImmutableList;
import com.minemaarten.signals.lib.EnumSetUtils;
import com.minemaarten.signals.rail.network.EnumHeading;
import com.minemaarten.signals.rail.network.NetworkRail;
import com.minemaarten.signals.rail.network.mc.ISerializableNetworkObject;
import com.minemaarten.signals.rail.network.mc.MCPos;
import com.minemaarten.signals.rail.network.mc.NetworkSerializer;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class MCNetworkRail
extends NetworkRail<MCPos>
implements ISerializableNetworkObject {
    private static final Object NORMAL_RAIL_TYPE = new Object();
    private static final String NORMAL_RAIL_STRING = "r";
    private static final EnumSet<EnumHeading> STANDARD_NEIGHBOR_HEADINGS = EnumSet.allOf(EnumHeading.class);
    private static final BlockRailBase.EnumRailDirection[] ALL_RAIL_DIRECTIONS_ARRAY = BlockRailBase.EnumRailDirection.values();
    private static final EnumSet<BlockRailBase.EnumRailDirection> ALL_RAIL_DIRECTIONS = EnumSet.allOf(BlockRailBase.EnumRailDirection.class);
    private final String railType;
    private final BlockRailBase.EnumRailDirection curDir;
    private final ImmutableList<MCPos> potentialRailNeighbors;
    private final ImmutableList<MCPos> potentialObjectNeighbors;
    private final EnumSet<BlockRailBase.EnumRailDirection> validRailDirs;
    private final EnumSet<EnumHeading> validNeighborHeadings;
    private final EnumMap<EnumHeading, EnumSet<EnumHeading>> entryDirToNeighborHeadings;
    private final EnumMap<EnumHeading, Set<MCPos>> headingToNeighbors;

    public MCNetworkRail(MCPos pos, Block railBlock, BlockRailBase.EnumRailDirection curDir, EnumSet<BlockRailBase.EnumRailDirection> validRailDirs) {
        this(pos, railBlock == Blocks.field_150448_aq ? null : railBlock.getRegistryName().toString(), curDir, validRailDirs);
    }

    public MCNetworkRail(MCPos pos, String railType, BlockRailBase.EnumRailDirection curDir, EnumSet<BlockRailBase.EnumRailDirection> validRailDirs) {
        super(pos);
        this.railType = railType;
        this.curDir = curDir;
        if (validRailDirs.size() == ALL_RAIL_DIRECTIONS.size()) {
            this.validRailDirs = ALL_RAIL_DIRECTIONS;
            this.validNeighborHeadings = STANDARD_NEIGHBOR_HEADINGS;
        } else {
            this.validRailDirs = validRailDirs;
            this.validNeighborHeadings = MCNetworkRail.getValidHeadings(validRailDirs);
        }
        this.potentialObjectNeighbors = this.computePotentialObjectNeighbors();
        this.potentialRailNeighbors = ImmutableList.copyOf((Collection)this.potentialObjectNeighbors.stream().flatMap(this::plusOneMinusOneHeight).collect(Collectors.toList()));
        this.entryDirToNeighborHeadings = this.computeExitsForEntries(validRailDirs);
        this.headingToNeighbors = new EnumMap(EnumHeading.class);
        for (EnumHeading heading : this.validNeighborHeadings) {
            this.headingToNeighbors.put(heading, this.plusOneMinusOneHeight(pos.offset(heading)).collect(Collectors.toSet()));
        }
    }

    public static MCNetworkRail fromTag(NBTTagCompound tag) {
        return MCNetworkRail.fromTag(tag, MCNetworkRail::new);
    }

    protected static <T> T fromTag(NBTTagCompound tag, IRailCreator<T> factory) {
        BlockRailBase.EnumRailDirection curDir = ALL_RAIL_DIRECTIONS_ARRAY[tag.func_74771_c("c")];
        if (tag.func_74764_b("t")) {
            EnumSet validRailDirs = EnumSetUtils.toEnumSet(BlockRailBase.EnumRailDirection.class, (Enum[])ALL_RAIL_DIRECTIONS_ARRAY, (int)tag.func_74765_d(NORMAL_RAIL_STRING));
            return factory.create(new MCPos(tag), tag.func_74779_i("t"), curDir, validRailDirs);
        }
        return factory.create(new MCPos(tag), null, curDir, ALL_RAIL_DIRECTIONS);
    }

    public static MCNetworkRail fromByteBuf(ByteBuf b) {
        MCPos pos = new MCPos(b);
        BlockRailBase.EnumRailDirection curDir = ALL_RAIL_DIRECTIONS_ARRAY[b.readByte()];
        String type = ByteBufUtils.readUTF8String((ByteBuf)b);
        if (type.equals(NORMAL_RAIL_STRING)) {
            return new MCNetworkRail(pos, (String)null, curDir, ALL_RAIL_DIRECTIONS);
        }
        EnumSet validRailDirs = EnumSetUtils.toEnumSet(BlockRailBase.EnumRailDirection.class, (Enum[])ALL_RAIL_DIRECTIONS_ARRAY, (int)b.readShort());
        return new MCNetworkRail(pos, type, curDir, (EnumSet<BlockRailBase.EnumRailDirection>)validRailDirs);
    }

    public static <T> T fromByteBuf(ByteBuf b, IRailCreator<T> factory) {
        MCPos pos = new MCPos(b);
        BlockRailBase.EnumRailDirection curDir = ALL_RAIL_DIRECTIONS_ARRAY[b.readByte()];
        String type = ByteBufUtils.readUTF8String((ByteBuf)b);
        if (type.equals(NORMAL_RAIL_STRING)) {
            return factory.create(pos, null, curDir, ALL_RAIL_DIRECTIONS);
        }
        EnumSet validRailDirs = EnumSetUtils.toEnumSet(BlockRailBase.EnumRailDirection.class, (Enum[])ALL_RAIL_DIRECTIONS_ARRAY, (int)b.readShort());
        return factory.create(pos, type, curDir, validRailDirs);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        ((MCPos)this.getPos()).writeToNBT(tag);
        tag.func_74774_a("c", (byte)this.curDir.ordinal());
        if (this.railType != null) {
            tag.func_74778_a("t", this.railType);
            tag.func_74777_a(NORMAL_RAIL_STRING, EnumSetUtils.toShort(this.validRailDirs));
        }
    }

    @Override
    public void writeToBuf(ByteBuf b) {
        ((MCPos)this.getPos()).writeToBuf(b);
        b.writeByte(this.curDir.ordinal());
        ByteBufUtils.writeUTF8String((ByteBuf)b, (String)(this.railType == null ? NORMAL_RAIL_STRING : this.railType));
        if (this.railType != null) {
            b.writeShort((int)EnumSetUtils.toShort(this.validRailDirs));
        }
    }

    private Stream<MCPos> plusOneMinusOneHeight(MCPos pos) {
        return Stream.of(pos.offset(EnumFacing.UP), pos, pos.offset(EnumFacing.DOWN));
    }

    protected ImmutableList<MCPos> computePotentialObjectNeighbors() {
        return ImmutableList.copyOf((Collection)this.potentialObjectNeighborsStream().collect(Collectors.toList()));
    }

    protected Stream<MCPos> potentialObjectNeighborsStream() {
        return this.validNeighborHeadings.stream().map(((MCPos)this.getPos())::offset);
    }

    @Override
    public Object getRailType() {
        return this.railType == null ? NORMAL_RAIL_TYPE : this.railType;
    }

    public BlockRailBase.EnumRailDirection getCurDir() {
        return this.curDir;
    }

    @Override
    public List<MCPos> getPotentialNeighborRailLocations() {
        return this.potentialRailNeighbors;
    }

    @Override
    public Collection<MCPos> getPotentialNeighborRailLocations(EnumHeading side) {
        return this.headingToNeighbors.get((Object)side);
    }

    @Override
    public EnumSet<EnumHeading> getPotentialNeighborRailHeadings() {
        return this.validNeighborHeadings;
    }

    @Override
    public List<MCPos> getPotentialNeighborObjectLocations() {
        return this.potentialObjectNeighbors;
    }

    private EnumMap<EnumHeading, EnumSet<EnumHeading>> computeExitsForEntries(EnumSet<BlockRailBase.EnumRailDirection> validRailDirs) {
        EnumMap<EnumHeading, EnumSet<EnumHeading>> exitsForEntries = new EnumMap<EnumHeading, EnumSet<EnumHeading>>(EnumHeading.class);
        for (EnumHeading heading : EnumHeading.VALUES) {
            exitsForEntries.put(heading, EnumSet.noneOf(EnumHeading.class));
        }
        for (BlockRailBase.EnumRailDirection railDir : validRailDirs) {
            EnumSet<EnumHeading> railDirDirs = MCNetworkRail.getDirections(railDir);
            for (EnumHeading heading : railDirDirs) {
                exitsForEntries.get((Object)heading.getOpposite()).addAll(railDirDirs);
            }
        }
        return exitsForEntries;
    }

    private static EnumSet<EnumHeading> getValidHeadings(EnumSet<BlockRailBase.EnumRailDirection> validRailDirs) {
        EnumSet<EnumHeading> headings = EnumSet.noneOf(EnumHeading.class);
        for (BlockRailBase.EnumRailDirection dir : validRailDirs) {
            headings.addAll(MCNetworkRail.getDirections(dir));
        }
        return headings;
    }

    private static EnumSet<EnumHeading> getDirections(BlockRailBase.EnumRailDirection railDir) {
        switch (railDir) {
            case NORTH_SOUTH: 
            case ASCENDING_NORTH: 
            case ASCENDING_SOUTH: {
                return EnumSet.of(EnumHeading.NORTH, EnumHeading.SOUTH);
            }
            case EAST_WEST: 
            case ASCENDING_EAST: 
            case ASCENDING_WEST: {
                return EnumSet.of(EnumHeading.EAST, EnumHeading.WEST);
            }
            case SOUTH_EAST: {
                return EnumSet.of(EnumHeading.SOUTH, EnumHeading.EAST);
            }
            case SOUTH_WEST: {
                return EnumSet.of(EnumHeading.SOUTH, EnumHeading.WEST);
            }
            case NORTH_WEST: {
                return EnumSet.of(EnumHeading.NORTH, EnumHeading.WEST);
            }
            case NORTH_EAST: {
                return EnumSet.of(EnumHeading.NORTH, EnumHeading.EAST);
            }
        }
        return EnumSet.noneOf(EnumHeading.class);
    }

    @Override
    public NetworkSerializer.EnumNetworkObject getType() {
        return NetworkSerializer.EnumNetworkObject.RAIL;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MCNetworkRail) {
            MCNetworkRail other = (MCNetworkRail)obj;
            return super.equals(obj) && this.validRailDirs.equals(other.validRailDirs) && this.curDir.func_177018_c() == other.curDir.func_177018_c();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.validRailDirs.hashCode() * 2 + (this.curDir.func_177018_c() ? 1 : 0);
    }

    @Override
    public EnumSet<EnumHeading> getPathfindHeading(EnumHeading entryDir) {
        if (entryDir == null) {
            return EnumSet.noneOf(EnumHeading.class);
        }
        return this.entryDirToNeighborHeadings.get((Object)entryDir);
    }

    public static interface IRailCreator<T> {
        public T create(MCPos var1, String var2, BlockRailBase.EnumRailDirection var3, EnumSet<BlockRailBase.EnumRailDirection> var4);
    }
}

