/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Streams;
import com.minemaarten.signals.rail.network.EnumHeading;
import com.minemaarten.signals.rail.network.INetworkObject;
import com.minemaarten.signals.rail.network.IPosition;
import com.minemaarten.signals.rail.network.IRailLink;
import com.minemaarten.signals.rail.network.NetworkCache;
import com.minemaarten.signals.rail.network.NetworkRail;
import com.minemaarten.signals.rail.network.NetworkSignal;
import com.minemaarten.signals.rail.network.NetworkState;
import com.minemaarten.signals.rail.network.NetworkStation;
import com.minemaarten.signals.rail.network.RailEdge;
import com.minemaarten.signals.rail.network.RailObjectHolder;
import com.minemaarten.signals.rail.network.RailPathfinder;
import com.minemaarten.signals.rail.network.RailRoute;
import com.minemaarten.signals.rail.network.RailSection;
import com.minemaarten.signals.rail.network.Train;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RailNetwork<TPos extends IPosition<TPos>> {
    private static final int MAX_RAILS_IN_FRONT_SIGNAL = 5;
    public final RailObjectHolder<TPos> railObjects;
    public final RailObjectHolder<TPos> unfilteredRailObjects;
    private Map<TPos, RailSection<TPos>> railPosToRailSections;
    private Set<RailEdge<TPos>> allEdges;
    private Set<RailSection<TPos>> allSections;
    private TObjectIntMap<TPos> railLinkPosToDelays;
    private final Map<TPos, List<TPos>> signalToPositionsInFrontCache = new HashMap<TPos, List<TPos>>();
    private final ImmutableMap<TPos, NetworkCache<TPos>> cache;
    private String[] stationNames;
    private Multimap<TPos, RailEdge<TPos>> positionsToEdgesBackward;
    private Map<TPos, RailEdge<TPos>> railPosToRailEdges;

    public RailNetwork(Collection<INetworkObject<TPos>> allNetworkObjects) {
        this.unfilteredRailObjects = new RailObjectHolder<TPos>(allNetworkObjects);
        this.railObjects = this.unfilteredRailObjects.filterInvalidSignals();
        this.cache = (ImmutableMap)allNetworkObjects.stream().collect(ImmutableMap.toImmutableMap(INetworkObject::getPos, NetworkCache::new));
    }

    public RailNetwork(ImmutableMap<TPos, INetworkObject<TPos>> allNetworkObjects) {
        this.unfilteredRailObjects = new RailObjectHolder<TPos>(allNetworkObjects);
        this.railObjects = this.unfilteredRailObjects.filterInvalidSignals();
        this.cache = (ImmutableMap)allNetworkObjects.values().stream().collect(ImmutableMap.toImmutableMap(INetworkObject::getPos, NetworkCache::new));
    }

    public static <TPos extends IPosition<TPos>> RailNetwork<TPos> empty() {
        return new RailNetwork<TPos>(ImmutableMap.of());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RailNetwork<TPos> build() {
        if (this.railPosToRailSections == null) {
            RailNetwork railNetwork = this;
            synchronized (railNetwork) {
                if (this.railPosToRailSections == null) {
                    this.railPosToRailSections = new HashMap<TPos, RailSection<TPos>>();
                    this.allEdges = new HashSet<RailEdge<TPos>>();
                    this.allSections = new HashSet<RailSection<TPos>>();
                    this.railLinkPosToDelays = new TObjectIntHashMap();
                    this.railPosToRailEdges = new HashMap<TPos, RailEdge<TPos>>();
                    this.positionsToEdgesBackward = ArrayListMultimap.create();
                    this.buildRailSections();
                    Set<RailEdge<TPos>> allEdges = this.buildRoughRailEdges();
                    this.mergeCrossingEdges(allEdges).forEach(edge -> this.addEdge((RailEdge<TPos>)edge));
                    this.buildStationNames();
                    this.buildRailLinkToDelayMap();
                    this.onAfterBuild();
                }
            }
        }
        return this;
    }

    protected void onAfterBuild() {
    }

    private void buildStationNames() {
        Stream<String> stationNameStream = this.railObjects.getStations().stream().map(s -> s.stationName).filter(s -> !"".equals(s));
        stationNameStream = Streams.concat((Stream[])new Stream[]{stationNameStream, Stream.of("ITEM")}).distinct().sorted();
        this.stationNames = (String[])stationNameStream.toArray(String[]::new);
    }

    public String[] getStationNames() {
        this.build();
        return this.stationNames;
    }

    private void buildRailSections() {
        HashSet<NetworkRail<TPos>> toTraverse = new HashSet<NetworkRail<TPos>>(this.railObjects.getRails());
        while (!toTraverse.isEmpty()) {
            Iterator toTraverseIterator = toTraverse.iterator();
            NetworkRail first = (NetworkRail)toTraverseIterator.next();
            toTraverseIterator.remove();
            HashSet sectionSet = new HashSet();
            sectionSet.add(first);
            Stack<NetworkRail> sectionToTraverse = new Stack<NetworkRail>();
            sectionToTraverse.push(first);
            while (!sectionToTraverse.isEmpty()) {
                NetworkRail curRail = (NetworkRail)sectionToTraverse.pop();
                List neighbors = curRail.getSectionNeighborRails(this.railObjects).collect(Collectors.toList());
                for (NetworkRail neighbor : neighbors) {
                    EnumHeading dir = ((IPosition)neighbor.getPos()).getRelativeHeading(curRail.getPos());
                    if (dir != null && this.getSignalInDir(curRail, dir) != null || dir != null && this.getSignalInDir(neighbor, dir.getOpposite()) != null) continue;
                    if (toTraverse.remove(neighbor)) {
                        sectionToTraverse.push(neighbor);
                    }
                    sectionSet.add(neighbor);
                }
            }
            this.addSection(new RailSection<TPos>(this.railObjects, sectionSet));
        }
    }

    private void buildRailLinkToDelayMap() {
        for (IRailLink<TPos> railLink : this.railObjects.getRailLinks()) {
            if (railLink.getHoldDelay() <= 0) continue;
            for (EnumHeading heading : EnumHeading.VALUES) {
                IPosition neighbor = (IPosition)((IPosition)railLink.getPos()).offset(heading);
                if (this.railObjects.getRail(neighbor) == null) continue;
                this.railLinkPosToDelays.put((Object)neighbor, railLink.getHoldDelay());
            }
        }
    }

    public int getRailLinkDelayFor(TPos pos) {
        this.build();
        return this.railLinkPosToDelays.get(pos);
    }

    private NetworkSignal<TPos> getSignalInDir(NetworkRail<TPos> rail, EnumHeading dir) {
        return ((NetworkCache)this.cache.get(rail.getPos())).getObjectNeighbors(this).getSignals().stream().filter(s -> s.heading == dir && s.getRailPos().equals(rail.getPos())).findFirst().orElse(null);
    }

    public Collection<RailSection<TPos>> getAllSections() {
        this.build();
        return this.allSections;
    }

    public Collection<RailEdge<TPos>> getAllEdges() {
        this.build();
        return this.allEdges;
    }

    private void addSection(RailSection<TPos> section) {
        this.allSections.add(section);
        section.getRailPositions().forEach(pos -> this.railPosToRailSections.put(pos, section));
    }

    public RailSection<TPos> findSection(TPos pos) {
        this.build();
        return this.railPosToRailSections.get(pos);
    }

    private Set<RailEdge<TPos>> buildRoughRailEdges() {
        HashSet<NetworkRail<TPos>> toTraverse = new HashSet<NetworkRail<TPos>>(this.railObjects.getRails());
        HashSet<NetworkRail> edgeSet = new HashSet<NetworkRail>();
        ArrayList<NetworkRail> edge = new ArrayList<NetworkRail>();
        HashSet<RailEdge<TPos>> allEdges = new HashSet<RailEdge<TPos>>();
        while (!toTraverse.isEmpty()) {
            NetworkRail first = (NetworkRail)toTraverse.iterator().next();
            edge.clear();
            edge.add(first);
            edgeSet.clear();
            edgeSet.add(first);
            Stack<NetworkRail> edgeToTraverse = new Stack<NetworkRail>();
            edgeToTraverse.push(first);
            while (!edgeToTraverse.isEmpty()) {
                NetworkRail curEntry = (NetworkRail)edgeToTraverse.pop();
                List neighbors = curEntry.getSectionNeighborRails(this.railObjects).collect(Collectors.toList());
                if (neighbors.size() < 3) {
                    toTraverse.remove(curEntry);
                    for (NetworkRail neighbor : neighbors) {
                        if (!edgeSet.add(neighbor)) continue;
                        edgeToTraverse.push(neighbor);
                        if (((IPosition)((NetworkRail)edge.get(edge.size() - 1)).getPos()).equals(curEntry.getPos())) {
                            edge.add(neighbor);
                            continue;
                        }
                        if (((IPosition)((NetworkRail)edge.get(0)).getPos()).equals(curEntry.getPos())) {
                            edge.add(0, neighbor);
                            continue;
                        }
                        throw new IllegalStateException("Currently evaluated pos is not at the start or end of an edge!");
                    }
                    continue;
                }
                if (edge.size() != 1) continue;
                toTraverse.remove(curEntry);
                for (NetworkRail neighbor : neighbors) {
                    List neighborNeighbors = neighbor.getSectionNeighborRails(this.railObjects).collect(Collectors.toList());
                    if (neighborNeighbors.size() <= 2) continue;
                    ImmutableList e = ImmutableList.of((Object)curEntry, (Object)neighbor);
                    RailEdge<TPos> railEdge = new RailEdge<TPos>(this.railObjects, e);
                    allEdges.add(railEdge);
                }
            }
            if (edge.size() <= 1) continue;
            RailEdge<TPos> railEdge = new RailEdge<TPos>(this.railObjects, ImmutableList.copyOf(edge));
            allEdges.add(railEdge);
        }
        return allEdges;
    }

    private Set<RailEdge<TPos>> mergeCrossingEdges(Set<RailEdge<TPos>> allEdges) {
        SetMultimap connectedEdges = Multimaps.newSetMultimap(new HashMap(), HashSet::new);
        for (RailEdge<TPos> edge : allEdges) {
            connectedEdges.put(edge.startPos, edge);
            connectedEdges.put(edge.endPos, edge);
        }
        HashSet<RailEdge<TPos>> newEdges = new HashSet<RailEdge<TPos>>();
        HashSet<RailEdge<TPos>> curMergedEdges = new HashSet<RailEdge<TPos>>();
        while (!allEdges.isEmpty()) {
            RailEdge<TPos> first = allEdges.iterator().next();
            curMergedEdges.clear();
            curMergedEdges.add(first);
            RailEdge<TPos> combinedEdge = this.mergeEdgeFrom((Multimap<TPos, RailEdge<TPos>>)connectedEdges, (Set<RailEdge<TPos>>)curMergedEdges, first, first, first.get(0));
            if (!first.startPos.equals(first.endPos)) {
                combinedEdge = this.mergeEdgeFrom((Multimap<TPos, RailEdge<TPos>>)connectedEdges, (Set<RailEdge<TPos>>)curMergedEdges, combinedEdge, first, first.get(first.length - 1));
            }
            allEdges.removeAll(curMergedEdges);
            newEdges.add(combinedEdge);
        }
        return newEdges;
    }

    private RailEdge<TPos> mergeEdgeFrom(Multimap<TPos, RailEdge<TPos>> connectedEdges, Set<RailEdge<TPos>> curMergedEdges, RailEdge<TPos> combinedEdge, RailEdge<TPos> startEdge, NetworkRail<TPos> startPos) {
        boolean hasCombined;
        NetworkRail curRail = startPos;
        RailEdge prevEdge = startEdge;
        do {
            RailEdge nextEdge;
            hasCombined = false;
            EnumSet<EnumHeading> validHeadings = curRail.getPathfindHeading(prevEdge.headingForEndpoint((IPosition)curRail.getPos()));
            RailEdge fPrevEdge = prevEdge;
            NetworkRail fCurRail = curRail;
            List actualConnected = connectedEdges.get(curRail.getPos()).stream().filter(e -> e != fPrevEdge && (validHeadings.contains((Object)e.headingForEndpoint((IPosition)fCurRail.getPos())) || e.headingForEndpoint((IPosition)fCurRail.getPos()) == null)).collect(Collectors.toList());
            if (actualConnected.size() != 1 || !curMergedEdges.add(nextEdge = (RailEdge)actualConnected.get(0))) continue;
            combinedEdge = combinedEdge.combine(nextEdge, (IPosition)curRail.getPos());
            curRail = nextEdge.get(nextEdge.getIndex(nextEdge.other((IPosition)curRail.getPos())));
            prevEdge = nextEdge;
            hasCombined = true;
        } while (hasCombined);
        return combinedEdge;
    }

    private void addEdge(RailEdge<TPos> railEdge) {
        if (this.allEdges.add(railEdge)) {
            if (railEdge.directionality.canTravelBackwards) {
                this.positionsToEdgesBackward.put(railEdge.startPos, railEdge);
            }
            if (railEdge.directionality.canTravelForwards) {
                this.positionsToEdgesBackward.put(railEdge.endPos, railEdge);
            }
            for (int i = 0; i < railEdge.length; ++i) {
                this.railPosToRailEdges.put(railEdge.get(i).getPos(), railEdge);
            }
        }
    }

    public RailEdge<TPos> findEdge(TPos pos) {
        this.build();
        return this.railPosToRailEdges.get(pos);
    }

    public Collection<RailEdge<TPos>> findConnectedEdgesBackwards(TPos intersection) {
        this.build();
        return this.positionsToEdgesBackward.get(intersection);
    }

    public RailRoute<TPos> pathfind(NetworkState<TPos> state, TPos from, EnumHeading direction, Set<TPos> destinations) {
        return new RailPathfinder<TPos>(this, state).pathfindToDestination(from, direction, destinations);
    }

    public List<TPos> getPositionsInFront(NetworkSignal<TPos> signal) {
        this.build();
        List<Object> positions = this.signalToPositionsInFrontCache.get(signal.getPos());
        if (positions == null) {
            RailEdge<TPos> edge = this.findEdge(signal.getRailPos());
            if (edge == null) {
                positions = Collections.emptyList();
            } else {
                IPosition firstPosInFront = (IPosition)signal.getRailPos().offset(signal.heading.getOpposite());
                int index = edge.getIndex(signal.getRailPos());
                Object blockType = edge.get(index).getRailType();
                boolean countingUp = index < edge.length - 1 && firstPosInFront.equals(edge.get(index + 1));
                positions = new ArrayList<TPos>(5);
                if (countingUp) {
                    NetworkRail<TPos> rail;
                    int maxIndex = Math.min(index + 5, edge.length);
                    for (int i = index; i < maxIndex && blockType.equals((rail = edge.get(i)).getRailType()); ++i) {
                        positions.add(rail.getPos());
                    }
                } else {
                    NetworkRail<TPos> rail;
                    int minIndex = Math.max(index - 5 + 1, 1);
                    for (int i = index; i >= minIndex && blockType.equals((rail = edge.get(i)).getRailType()); --i) {
                        positions.add(rail.getPos());
                    }
                }
            }
            this.signalToPositionsInFrontCache.put(signal.getPos(), positions);
        }
        return positions;
    }

    public Set<TPos> getStationRails(Train<TPos> train, Pattern destinationRegex) {
        HashSet<TPos> rails = new HashSet<TPos>();
        HashSet<String> validNames = new HashSet<String>();
        List<NetworkStation<TPos>> stations = this.railObjects.getStations();
        for (NetworkStation<TPos> station : stations) {
            if (!station.isTrainApplicable(train, destinationRegex)) continue;
            rails.addAll(station.getConnectedRailPositions(this));
            validNames.add(station.stationName);
        }
        for (NetworkStation<TPos> station : stations) {
            if (!validNames.contains(station.stationName)) continue;
            rails.addAll(station.getConnectedRailPositions(this));
        }
        return rails;
    }

    public Set<TPos> getStations(Train<TPos> train, Pattern destinationRegex) {
        HashSet stationPositions = new HashSet();
        HashSet<String> validNames = new HashSet<String>();
        List<NetworkStation<TPos>> stations = this.railObjects.getStations();
        for (NetworkStation<TPos> station : stations) {
            if (!station.isTrainApplicable(train, destinationRegex)) continue;
            stationPositions.add(station.getPos());
            validNames.add(station.stationName);
        }
        for (NetworkStation<TPos> station : stations) {
            if (!validNames.contains(station.stationName)) continue;
            stationPositions.add(station.getPos());
        }
        return stationPositions;
    }
}

