/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network;

import com.minemaarten.signals.rail.network.EnumHeading;
import com.minemaarten.signals.rail.network.IPosition;
import com.minemaarten.signals.rail.network.NetworkObject;
import com.minemaarten.signals.rail.network.NetworkRail;
import com.minemaarten.signals.rail.network.RailNetwork;
import com.minemaarten.signals.rail.network.RailSection;
import java.util.Collections;
import java.util.List;

public class NetworkSignal<TPos extends IPosition<TPos>>
extends NetworkObject<TPos> {
    public final EnumHeading heading;
    public final EnumSignalType type;

    public NetworkSignal(TPos pos, EnumHeading heading, EnumSignalType type) {
        super(pos);
        this.heading = heading;
        this.type = type;
    }

    @Override
    public List<TPos> getNetworkNeighbors() {
        return Collections.singletonList(this.getRailPos());
    }

    public TPos getRailPos() {
        return (TPos)((IPosition)((IPosition)this.getPos()).offset(this.heading.rotateCCW()));
    }

    public RailSection<TPos> getNextRailSection(RailNetwork<TPos> network) {
        NetworkRail rail = (NetworkRail)network.railObjects.get(this.getRailPos());
        NetworkRail nextSectionRail = network.railObjects.getNeighborRails(rail.getPotentialNeighborRailLocations()).filter(r -> ((IPosition)r.getPos()).getRelativeHeading(rail.getPos()) == this.heading).findFirst().orElse(null);
        return nextSectionRail != null ? network.findSection((IPosition)nextSectionRail.getPos()) : null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof NetworkSignal) {
            NetworkSignal other = (NetworkSignal)obj;
            return super.equals(obj) && this.heading == other.heading && this.type == other.type;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (super.hashCode() * 31 + this.heading.hashCode()) * 31 + this.type.hashCode();
    }

    public static enum EnumSignalType {
        BLOCK,
        CHAIN;

        public static EnumSignalType[] VALUES;

        static {
            VALUES = EnumSignalType.values();
        }
    }
}

