/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail.network;

import com.minemaarten.signals.rail.network.INetworkObject;
import com.minemaarten.signals.rail.network.IPosition;
import com.minemaarten.signals.rail.network.NetworkRail;
import com.minemaarten.signals.rail.network.RailNetwork;
import com.minemaarten.signals.rail.network.RailObjectHolder;
import java.util.List;

public class NetworkCache<TPos extends IPosition<TPos>> {
    private final INetworkObject<TPos> thisObj;
    private RailObjectHolder<TPos> objectNeighbors;

    public NetworkCache(INetworkObject<TPos> thisObj) {
        this.thisObj = thisObj;
    }

    public RailObjectHolder<TPos> getObjectNeighbors(RailNetwork<TPos> network) {
        if (this.objectNeighbors == null && this.thisObj instanceof NetworkRail) {
            List potentialNeighbors = ((NetworkRail)this.thisObj).getPotentialNeighborObjectLocations();
            this.objectNeighbors = new RailObjectHolder(potentialNeighbors.stream().map(n -> network.railObjects.get((IPosition)n)).filter(n -> n != null));
        }
        return this.objectNeighbors;
    }
}

