/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail;

import com.minemaarten.signals.SignalsAccessor;
import com.minemaarten.signals.api.ICartHopperBehaviour;
import com.minemaarten.signals.api.ICartLinker;
import com.minemaarten.signals.api.IRail;
import com.minemaarten.signals.api.IRailMapper;
import com.minemaarten.signals.api.Signals;
import com.minemaarten.signals.api.access.SignalsAccessorProvidingEvent;
import com.minemaarten.signals.api.tileentity.IDestinationProvider;
import com.minemaarten.signals.capabilities.CapabilityDestinationProvider;
import com.minemaarten.signals.lib.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class RailManager {
    private static final RailManager INSTANCE = new RailManager();
    private final List<IRailMapper> railMappers = new ArrayList<IRailMapper>();
    private final Map<Block, IRail> blockToRails = new HashMap<Block, IRail>();
    private final List<IDestinationProvider> destinationProviders = new ArrayList<IDestinationProvider>();
    private final List<ICartHopperBehaviour<?>> hopperBehaviours = new ArrayList();
    private final List<ICartLinker> cartLinkers = new ArrayList<ICartLinker>();

    public static RailManager getInstance() {
        return INSTANCE;
    }

    public void initializeAPIImplementors(ASMDataTable asmData) {
        Set allAnnotatedClasses = asmData.getAll(Signals.class.getName());
        for (ASMDataTable.ASMData annotatedClass : allAnnotatedClasses) {
            try {
                Class<?> clazz = Class.forName(annotatedClass.getClassName());
                Log.info("Found class annotating @SignalRail : " + annotatedClass.getClassName());
                if (IRail.class.isAssignableFrom(clazz)) {
                    IRail rail = (IRail)clazz.newInstance();
                    for (Block applicableBlock : rail.getApplicableBlocks()) {
                        if (applicableBlock != null) {
                            this.registerRail(applicableBlock, rail);
                            continue;
                        }
                        Log.warning("IRail \"" + annotatedClass.getClassName() + "\" returned a null block as applicable!");
                    }
                    Log.info("Successfully registered the IRail for \"" + annotatedClass.getClassName() + "\".");
                }
                if (IRailMapper.class.isAssignableFrom(clazz)) {
                    IRailMapper railMapper = (IRailMapper)clazz.newInstance();
                    this.registerCustomRailMapper(railMapper);
                    Log.info("Successfully registered the IRailMapper for \"" + annotatedClass.getClassName() + "\".");
                }
                if (IDestinationProvider.class.isAssignableFrom(clazz)) {
                    IDestinationProvider destinationProvider = (IDestinationProvider)clazz.newInstance();
                    this.destinationProviders.add(destinationProvider);
                    Log.info("Successfully registered the IDestinationProvider for \"" + annotatedClass.getClassName() + "\".");
                }
                if (ICartHopperBehaviour.class.isAssignableFrom(clazz)) {
                    ICartHopperBehaviour hopperBehaviour = (ICartHopperBehaviour)clazz.newInstance();
                    this.hopperBehaviours.add(hopperBehaviour);
                    Log.info("Successfully registered the ICartHopperBehaviour for \"" + annotatedClass.getClassName() + "\".");
                }
                if (!ICartLinker.class.isAssignableFrom(clazz)) continue;
                ICartLinker cartLinker = (ICartLinker)clazz.newInstance();
                this.cartLinkers.add(cartLinker);
                Log.info("Successfully registered the ICartLinker for \"" + annotatedClass.getClassName() + "\".");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                Log.error("Annotated class \"" + annotatedClass.getClassName() + "\" could not be instantiated, probably because it is not marked public!");
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                Log.error("Annotated class \"" + annotatedClass.getClassName() + "\" could not be instantiated, probably because it either does not have a constructor without arguments, or because the class is abstract!");
                e.printStackTrace();
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new SignalsAccessorProvidingEvent(new SignalsAccessor()));
    }

    private void registerRail(Block railBlock, IRail rail) {
        if (railBlock == null) {
            throw new NullPointerException("Block is null!");
        }
        if (rail == null) {
            throw new NullPointerException("Rail is null!");
        }
        this.blockToRails.put(railBlock, rail);
    }

    private void registerCustomRailMapper(IRailMapper rail) {
        if (rail == null) {
            throw new NullPointerException("Rail Mapper is null!");
        }
        this.railMappers.add(rail);
    }

    public IRail getRailSimple(Block block) {
        return this.blockToRails.get(block);
    }

    public IRail getRail(World world, BlockPos pos, IBlockState state) {
        IRail rail = this.getRailSimple(state.func_177230_c());
        if (rail != null) {
            return rail;
        }
        for (IRailMapper mapper : this.railMappers) {
            rail = mapper.getRail(world, pos, state);
            if (rail == null) continue;
            return rail;
        }
        return null;
    }

    public void onTileEntityCapabilityAttachEvent(AttachCapabilitiesEvent<TileEntity> event) {
        CapabilityDestinationProvider.Provider provider = new CapabilityDestinationProvider.Provider();
        boolean requiresCap = false;
        CapabilityDestinationProvider cap = (CapabilityDestinationProvider)provider.getCapability(CapabilityDestinationProvider.INSTANCE, null);
        for (IDestinationProvider destinationProvider : this.destinationProviders) {
            if (!destinationProvider.isTileEntityApplicable((TileEntity)event.getObject())) continue;
            try {
                cap.addDestinationProvider((IDestinationProvider)destinationProvider.getClass().newInstance());
                if (requiresCap) continue;
                requiresCap = true;
                event.addCapability(new ResourceLocation("signals", "destinationProviderCapability"), (ICapabilityProvider)provider);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List<ICartHopperBehaviour<?>> getHopperBehaviours() {
        return this.hopperBehaviours;
    }

    public boolean areLinked(EntityMinecart cart1, EntityMinecart cart2) {
        for (ICartLinker linker : this.cartLinkers) {
            if (!linker.getLinkedCarts(cart1).contains(cart2)) continue;
            return true;
        }
        return false;
    }
}

