/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.rail;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;
import com.minemaarten.signals.capabilities.CapabilityMinecartDestination;
import com.minemaarten.signals.rail.network.INetworkObject;
import com.minemaarten.signals.rail.network.NetworkStation;
import com.minemaarten.signals.rail.network.RailNetwork;
import com.minemaarten.signals.rail.network.RailNetworkClient;
import com.minemaarten.signals.rail.network.RailRoute;
import com.minemaarten.signals.rail.network.Train;
import com.minemaarten.signals.rail.network.mc.MCPos;
import com.minemaarten.signals.rail.network.mc.RailNetworkManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class NetworkController {
    public static final int RAIL_COLOR = -10066330;
    public static final int PATH_COLOR = -5592406;
    public static final int TEXT_COLOR = 0xFFFFFF;
    public static final int STATION_COLOR = -2237184;
    public static final int NOTHING_COLOR = -14540254;
    private static Map<Integer, NetworkController> cache = new HashMap<Integer, NetworkController>();
    private static RailNetworkClient<MCPos> network = RailNetworkClient.empty();
    @SideOnly(value=Side.CLIENT)
    private DynamicTexture dynamicTexture;
    private int width;
    private int height;
    private int[] colors;
    private int startX;
    private int startZ;
    private final int dimensionId;
    private ResourceLocation textureLoc;

    public static NetworkController getInstance(World world) {
        if (!world.field_72995_K) {
            throw new IllegalStateException("Can only be called client side!");
        }
        return NetworkController.getInstance(world.field_73011_w.getDimension());
    }

    public static NetworkController getInstance(int dimension) {
        NetworkController controller;
        if (network != RailNetworkManager.getClientInstance().getClientNetwork()) {
            network = RailNetworkManager.getClientInstance().getClientNetwork();
            cache = NetworkController.rebuildAll();
        }
        if ((controller = cache.get(dimension)) == null) {
            controller = new NetworkController(dimension);
            controller.setColors(new int[]{0}, 1, 1, 0, 0);
            cache.put(dimension, controller);
        }
        return controller;
    }

    public NetworkController(int dimensionId) {
        this.dimensionId = dimensionId;
    }

    @SideOnly(value=Side.CLIENT)
    public void setColors(int[] colors, int width, int height, int startX, int startZ) {
        this.startX = startX;
        this.startZ = startZ;
        if (this.dynamicTexture == null || this.width != width || this.height != height) {
            this.width = width;
            this.height = height;
            if (this.dynamicTexture != null) {
                this.dynamicTexture.func_147631_c();
            }
            this.dynamicTexture = new DynamicTexture(width, height);
            this.textureLoc = Minecraft.func_71410_x().func_110434_K().func_110578_a("networkController/" + this.dimensionId, this.dynamicTexture);
        }
        System.arraycopy(colors, 0, this.dynamicTexture.func_110565_c(), 0, colors.length);
        this.dynamicTexture.func_110564_a();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getStartX() {
        return this.startX;
    }

    public int getStartZ() {
        return this.startZ;
    }

    private List<RailRoute<MCPos>> getAllRoutes() {
        return RailNetworkManager.getClientInstance().getAllTrains().map(t -> t.getCurRoute()).filter((Predicate<RailRoute>)Predicates.notNull()).collect(Collectors.toList());
    }

    @SideOnly(value=Side.CLIENT)
    public void render(World world) {
        double scale;
        if (this.textureLoc == null) {
            this.setColors(new int[1], 1, 1, 0, 0);
        }
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(this.textureLoc);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Gui.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (float)this.width, (float)this.height);
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder buffer = t.func_178180_c();
        for (RailRoute<MCPos> route : this.getAllRoutes()) {
            for (MCPos pathPos : route.routeRails) {
                if (pathPos.getDimID() != this.dimensionId) continue;
                int pathX = pathPos.getX() - this.startX;
                int pathZ = pathPos.getZ() - this.startZ;
                Gui.func_73734_a((int)pathX, (int)pathZ, (int)(pathX + 1), (int)(pathZ + 1), (int)-5592406);
            }
        }
        GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179090_x();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (Train train : RailNetworkManager.getClientInstance().getAllTrains().collect(Collectors.toList())) {
            for (MCPos pos : train.getPositions()) {
                if (pos.getDimID() != this.dimensionId) continue;
                double x = pos.getX() - this.startX;
                double y = pos.getZ() - this.startZ;
                buffer.func_181662_b(x, y, 0.0).func_181675_d();
                buffer.func_181662_b(x, y + 1.0, 0.0).func_181675_d();
                buffer.func_181662_b(x + 1.0, y + 1.0, 0.0).func_181675_d();
                buffer.func_181662_b(x + 1.0, y, 0.0).func_181675_d();
            }
        }
        t.func_78381_a();
        GlStateManager.func_179098_w();
        for (EntityMinecart cart : world.func_72872_a(EntityMinecart.class, new AxisAlignedBB((double)this.startX, 0.0, (double)this.startZ, (double)(this.startX + this.width), 255.0, (double)(this.startZ + this.height)))) {
            double x = cart.field_70165_t - (double)this.startX - 0.5;
            double y = cart.field_70161_v - (double)this.startZ - 0.5;
            GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)1.0f);
            String dest = ((CapabilityMinecartDestination)cart.getCapability(CapabilityMinecartDestination.INSTANCE, null)).getCurrentDestination();
            if (dest == null) continue;
            GlStateManager.func_179094_E();
            scale = 0.25;
            GlStateManager.func_179137_b((double)(x + 1.5), (double)y, (double)0.0);
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
            mc.field_71466_p.func_78276_b(dest, 0, 0, 0xFFFFFF);
            GlStateManager.func_179121_F();
        }
        RailNetwork<MCPos> network = RailNetworkManager.getClientInstance().getNetwork();
        for (NetworkStation station : network.railObjects.getStations()) {
            double x = (double)(((MCPos)station.getPos()).getX() - this.startX) - 0.5;
            double y = (double)(((MCPos)station.getPos()).getZ() - this.startZ) - 0.5;
            GlStateManager.func_179094_E();
            scale = 0.25;
            GlStateManager.func_179137_b((double)(x + 2.0), (double)y, (double)0.0);
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
            mc.field_71466_p.func_78276_b(station.stationName, 0, 0, -256);
            GlStateManager.func_179121_F();
        }
    }

    private void setColor(int x, int z, int color) {
        this.setColor(x, z, color, true);
    }

    private void setColor(int x, int z, int color, boolean sendPacket) {
        int index = x - this.startX + (z - this.startZ) * this.width;
        if (index < 0 || index >= this.colors.length) {
            NetworkController.rebuildAll();
        } else {
            this.colors[index] = color;
        }
    }

    public void updateColor(int color, BlockPos ... positions) {
        boolean rebuildAll = false;
        for (BlockPos pos : positions) {
            if (color == -14540254) {
                if (pos.func_177958_n() == this.startX || pos.func_177958_n() == this.startX + this.width || pos.func_177952_p() == this.startZ || pos.func_177952_p() == this.startZ + this.height) {
                    rebuildAll = true;
                }
            } else if (pos.func_177958_n() < this.startX || pos.func_177958_n() >= this.startX + this.width || pos.func_177952_p() < this.startZ || pos.func_177952_p() >= this.startZ + this.height) {
                rebuildAll = true;
            }
            if (rebuildAll) continue;
            this.setColor(pos.func_177958_n(), pos.func_177952_p(), color);
            this.setColors(this.colors, this.width, this.height, this.startX, this.startZ);
        }
        if (rebuildAll) {
            NetworkController.rebuildAll();
        }
    }

    public static Map<Integer, NetworkController> rebuildAll() {
        HashMap<Integer, NetworkController> cache = new HashMap<Integer, NetworkController>();
        ImmutableCollection allObjects = RailNetworkManager.getClientInstance().getNetwork().railObjects.getAllNetworkObjects().values();
        Map<Integer, List<INetworkObject>> objsByDim = allObjects.stream().collect(Collectors.groupingBy(o -> ((MCPos)o.getPos()).getDimID()));
        for (Map.Entry<Integer, List<INetworkObject>> entry : objsByDim.entrySet()) {
            NetworkController controller = new NetworkController(entry.getKey());
            controller.rebuild((Collection<INetworkObject<MCPos>>)entry.getValue());
            controller.setColors(controller.colors, controller.width, controller.height, controller.startX, controller.startZ);
            cache.put(entry.getKey(), controller);
        }
        return cache;
    }

    private void rebuild(Collection<INetworkObject<MCPos>> objects) {
        this.startX = Integer.MAX_VALUE;
        this.startZ = Integer.MAX_VALUE;
        int endX = Integer.MIN_VALUE;
        int endZ = Integer.MIN_VALUE;
        for (INetworkObject<MCPos> obj : objects) {
            MCPos pos = obj.getPos();
            this.startX = Math.min(this.startX, pos.getX());
            this.startZ = Math.min(this.startZ, pos.getZ());
            endX = Math.max(endX, pos.getX());
            endZ = Math.max(endZ, pos.getZ());
        }
        this.width = endX - this.startX + 1;
        this.height = endZ - this.startZ + 1;
        this.colors = new int[this.width * this.height];
        Arrays.fill(this.colors, -14540254);
        for (INetworkObject<MCPos> obj : objects) {
            this.setColor(obj.getPos().getX(), obj.getPos().getZ(), obj.getColor(), false);
        }
    }
}

