/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.network;

import com.google.common.collect.ImmutableList;
import com.minemaarten.signals.network.AbstractPacket;
import com.minemaarten.signals.rail.network.RailRoute;
import com.minemaarten.signals.rail.network.mc.MCPos;
import com.minemaarten.signals.rail.network.mc.MCTrain;
import com.minemaarten.signals.rail.network.mc.RailNetworkManager;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;

public class PacketUpdateTrainPath
extends AbstractPacket<PacketUpdateTrainPath> {
    private int trainID;
    private RailRoute<MCPos> path;

    public PacketUpdateTrainPath() {
    }

    public PacketUpdateTrainPath(MCTrain train) {
        this.trainID = train.id;
        this.path = train.getCurRoute();
    }

    public void toBytes(ByteBuf b) {
        b.writeInt(this.trainID);
        b.writeBoolean(this.path != null);
        if (this.path != null) {
            b.writeInt(this.path.routeRails.size());
            for (MCPos pos : this.path.routeRails) {
                pos.writeToBuf(b);
            }
        }
    }

    public void fromBytes(ByteBuf b) {
        this.trainID = b.readInt();
        if (b.readBoolean()) {
            int count = b.readInt();
            ImmutableList.Builder routeRails = ImmutableList.builder();
            for (int i = 0; i < count; ++i) {
                routeRails.add((Object)new MCPos(b));
            }
            this.path = new RailRoute(ImmutableList.of(), routeRails.build(), ImmutableList.of(), ImmutableList.of());
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        MCTrain train = RailNetworkManager.getClientInstance().getTrainByID(this.trainID);
        if (train != null) {
            train.setPath(this.path);
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

