/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.network;

import com.google.common.collect.ImmutableSet;
import com.minemaarten.signals.network.AbstractPacket;
import com.minemaarten.signals.rail.network.mc.MCPos;
import com.minemaarten.signals.rail.network.mc.MCTrain;
import com.minemaarten.signals.rail.network.mc.MCTrainClient;
import com.minemaarten.signals.rail.network.mc.RailNetworkManager;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;

public class PacketAddOrUpdateTrain
extends AbstractPacket<PacketAddOrUpdateTrain> {
    private int trainID;
    private ImmutableSet<UUID> cartIDs;
    private ImmutableSet<MCPos> positions;

    public PacketAddOrUpdateTrain() {
    }

    public PacketAddOrUpdateTrain(MCTrain train) {
        this.trainID = train.id;
        this.cartIDs = train.cartIDs;
        this.positions = train.getPositions();
    }

    public void toBytes(ByteBuf b) {
        b.writeInt(this.trainID);
        b.writeInt(this.cartIDs.size());
        PacketBuffer pb = new PacketBuffer(b);
        for (UUID cartID : this.cartIDs) {
            pb.func_179252_a(cartID);
        }
        b.writeInt(this.positions.size());
        for (MCPos pos : this.positions) {
            pos.writeToBuf(b);
        }
    }

    public void fromBytes(ByteBuf b) {
        this.trainID = b.readInt();
        int ids = b.readInt();
        PacketBuffer pb = new PacketBuffer(b);
        ImmutableSet.Builder cartIDs = new ImmutableSet.Builder();
        for (int i = 0; i < ids; ++i) {
            cartIDs.add((Object)pb.func_179253_g());
        }
        this.cartIDs = cartIDs.build();
        int posCount = b.readInt();
        ImmutableSet.Builder positions = new ImmutableSet.Builder();
        for (int i = 0; i < posCount; ++i) {
            positions.add((Object)new MCPos(b));
        }
        this.positions = positions.build();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        MCTrainClient train = new MCTrainClient(this.trainID, this.cartIDs);
        train.setPositions(null, null, this.positions);
        RailNetworkManager.getClientInstance().addTrain(train);
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

