/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.item;

import com.google.common.collect.Lists;
import com.minemaarten.signals.Signals;
import com.minemaarten.signals.SignalsAccessor;
import com.minemaarten.signals.api.access.IDestinationAccessor;
import com.minemaarten.signals.capabilities.CapabilityMinecartDestination;
import com.minemaarten.signals.item.ItemSignals;
import com.minemaarten.signals.proxy.CommonProxy;
import com.minemaarten.signals.tileentity.TileEntityStationMarker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;

public class ItemTicket
extends ItemSignals {
    public ItemTicket() {
        super("ticket");
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (!worldIn.field_72995_K) {
            ItemStack stack = playerIn.func_184586_b(hand);
            if (playerIn.func_70093_af()) {
                ItemTicket.setDestinations(stack, Collections.emptyList());
                stack.func_135074_t();
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("signals.message.cleared_ticket", new Object[0]));
            } else {
                playerIn.openGui((Object)Signals.instance, CommonProxy.EnumGuiId.TICKET_DESTINATION.ordinal(), worldIn, 0, 0, 0);
            }
        }
        return super.func_77659_a(worldIn, playerIn, hand);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity te;
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof TileEntityStationMarker) {
            TileEntityStationMarker stationMarker = (TileEntityStationMarker)te;
            String stationName = stationMarker.getStationName();
            ItemTicket.appendDestination(stack, stationName);
            String concatDestinations = ItemTicket.getConcattedDestinations(stack);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("signals.message.added_destination", new Object[]{TextFormatting.GOLD + stationName + TextFormatting.WHITE, TextFormatting.GOLD + concatDestinations + TextFormatting.WHITE}));
            return EnumActionResult.SUCCESS;
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    @Override
    public void func_77624_a(ItemStack stack, World world, List<String> curInfo, ITooltipFlag flag) {
        curInfo.add(ItemTicket.getConcattedDestinations(stack));
        super.func_77624_a(stack, world, curInfo, flag);
    }

    public int getMetadata(ItemStack stack) {
        return Math.min(ItemTicket.getDestinations(stack).size(), 4);
    }

    private static void appendDestination(ItemStack stack, String destination) {
        ArrayList newDestinations = Lists.newArrayList(ItemTicket.getDestinations(stack));
        newDestinations.add(destination);
        ItemTicket.setDestinations(stack, newDestinations);
    }

    public static void setDestinations(ItemStack stack, List<String> destinations) {
        if (destinations.isEmpty()) {
            stack.func_190919_e("destinations");
        } else {
            NBTTagCompound tag = stack.func_190925_c("destinations");
            NBTTagList tagList = new NBTTagList();
            for (String destination : destinations) {
                tagList.func_74742_a((NBTBase)new NBTTagString(destination));
            }
            tag.func_74782_a("destinations", (NBTBase)tagList);
        }
    }

    public static List<String> getDestinations(ItemStack stack) {
        NBTTagCompound tag = stack.func_179543_a("destinations");
        if (tag != null) {
            NBTTagList tagList = tag.func_150295_c("destinations", 8);
            return StreamSupport.stream(tagList.spliterator(), false).map(nbt -> ((NBTTagString)nbt).func_150285_a_()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static void writeNBTFromCap(ItemStack stack) {
        CapabilityMinecartDestination cap = ItemTicket.getCap(stack);
        if (cap != null) {
            ItemTicket.setDestinations(stack, Arrays.asList(cap.getDestinations()));
        }
    }

    public static void readNBTIntoCap(ItemStack stack) {
        CapabilityMinecartDestination cap = ItemTicket.getCap(stack);
        if (cap != null) {
            cap.setDestinations(ItemTicket.getDestinations(stack));
        }
    }

    public static CapabilityMinecartDestination getCap(ItemStack stack) {
        return (CapabilityMinecartDestination)stack.getCapability(CapabilityMinecartDestination.INSTANCE, null);
    }

    public static String getConcattedDestinations(ItemStack stack) {
        List<String> destinations = ItemTicket.getDestinations(stack);
        return destinations.isEmpty() ? "-" : StringUtils.join(destinations, (String)", ");
    }

    public static void applyDestinations(EntityMinecart cart, ItemStack stack) {
        IDestinationAccessor accessor = new SignalsAccessor().getDestinationAccessor(cart);
        accessor.setDestinations(ItemTicket.getDestinations(stack));
        accessor.setCurrentDestinationIndex(0);
    }
}

