/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.packet;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.common.network.ExtendedPacketBuffer;
import reborncore.common.network.INetworkPacket;
import reborncore.common.network.NetworkManager;
import vswe.stevescarts.blocks.BlockCartAssembler;
import vswe.stevescarts.blocks.ModBlocks;
import vswe.stevescarts.blocks.tileentities.TileEntityBase;
import vswe.stevescarts.containers.ContainerBase;
import vswe.stevescarts.containers.ContainerMinecart;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.modules.ModuleBase;

public class PacketStevesCarts
implements INetworkPacket<PacketStevesCarts> {
    private byte[] bytes;

    public PacketStevesCarts(byte[] bytes) {
        this.bytes = bytes;
    }

    public PacketStevesCarts() {
    }

    public void writeData(ExtendedPacketBuffer buffer) {
        buffer.func_179250_a(this.bytes);
    }

    public void readData(ExtendedPacketBuffer buffer) {
        this.bytes = buffer.func_179251_a();
    }

    public void processData(PacketStevesCarts message, MessageContext context) {
        if (context.side == Side.CLIENT) {
            FMLClientHandler.instance().getClient().func_152344_a(() -> this.processDataClient(message, context));
        } else {
            FMLCommonHandler.instance().getMinecraftServerInstance().func_175586_a(() -> this.processDataServer(message, context));
        }
    }

    private boolean processDataServer(PacketStevesCarts message, MessageContext context) {
        EntityPlayerMP player = context.getServerHandler().field_147369_b;
        World world = player.field_70170_p;
        ByteArrayDataInput reader = ByteStreams.newDataInput((byte[])message.bytes);
        byte id = reader.readByte();
        if (player.field_71070_bA instanceof ContainerPlayer) {
            int entityid = reader.readInt();
            int len = this.bytes.length - 5;
            byte[] data = new byte[len];
            for (int i = 0; i < len; ++i) {
                data[i] = reader.readByte();
            }
            EntityMinecartModular cart = this.getCart(entityid, world);
            if (cart != null) {
                this.receivePacketAtCart(cart, id, data, (EntityPlayer)player);
            }
        } else {
            ContainerBase conBase;
            TileEntityBase base;
            int len = this.bytes.length - 1;
            byte[] data2 = new byte[len];
            for (int j = 0; j < len; ++j) {
                data2[j] = reader.readByte();
            }
            Container con = player.field_71070_bA;
            if (con instanceof ContainerMinecart) {
                ContainerMinecart conMC = (ContainerMinecart)con;
                EntityMinecartModular cart2 = conMC.cart;
                this.receivePacketAtCart(cart2, id, data2, (EntityPlayer)player);
            } else if (con instanceof ContainerBase && (base = (conBase = (ContainerBase)con).getTileEntity()) != null) {
                base.receivePacket(id, data2, (EntityPlayer)player);
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void processDataClient(PacketStevesCarts message, MessageContext context) {
        EntityPlayerSP player = FMLClientHandler.instance().getClient().field_71439_g;
        ByteArrayDataInput reader = ByteStreams.newDataInput((byte[])message.bytes);
        World world = player.field_70170_p;
        byte id = reader.readByte();
        if (id == -1) {
            int x = reader.readInt();
            int y = reader.readInt();
            int z = reader.readInt();
            int len = this.bytes.length - 13;
            byte[] data = new byte[len];
            for (int i = 0; i < len; ++i) {
                data[i] = reader.readByte();
            }
            ((BlockCartAssembler)ModBlocks.CART_ASSEMBLER.getBlock()).updateMultiBlock(world, new BlockPos(x, y, z));
        } else {
            int entityid = reader.readInt();
            int len = this.bytes.length - 5;
            byte[] data = new byte[len];
            for (int j = 0; j < len; ++j) {
                data[j] = reader.readByte();
            }
            EntityMinecartModular cart = this.getCart(entityid, world);
            if (cart != null) {
                this.receivePacketAtCart(cart, id, data, (EntityPlayer)player);
            }
        }
    }

    private void receivePacketAtCart(EntityMinecartModular cart, int id, byte[] data, EntityPlayer player) {
        for (ModuleBase module : cart.getModules()) {
            if (id < module.getPacketStart() || id >= module.getPacketStart() + module.totalNumberOfPackets()) continue;
            module.delegateReceivedPacket(id - module.getPacketStart(), data, player);
            break;
        }
    }

    private EntityMinecartModular getCart(int ID, World world) {
        for (Object e : world.field_72996_f) {
            if (!(e instanceof Entity) || ((Entity)e).func_145782_y() != ID || !(e instanceof EntityMinecartModular)) continue;
            return (EntityMinecartModular)((Object)e);
        }
        return null;
    }

    public static void sendPacket(int id, byte[] extraData) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(bs);
        try {
            ds.writeByte((byte)id);
            for (byte b : extraData) {
                ds.writeByte(b);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        NetworkManager.sendToServer((INetworkPacket)new PacketStevesCarts(bs.toByteArray()));
    }

    private static byte[] makeCartPacket(EntityMinecartModular cart, int id, byte[] data) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(bs);
        try {
            ds.writeByte((byte)id);
            ds.writeInt(cart.func_145782_y());
            for (byte b : data) {
                ds.writeByte(b);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bs.toByteArray();
    }

    public static void sendPacket(EntityMinecartModular cart, int id, byte[] extraData) {
        NetworkManager.sendToServer((INetworkPacket)new PacketStevesCarts(PacketStevesCarts.makeCartPacket(cart, id, extraData)));
    }

    public static void sendPacketToPlayer(int id, byte[] data, EntityPlayer player, EntityMinecartModular cart) {
        NetworkManager.sendToPlayer((INetworkPacket)new PacketStevesCarts(PacketStevesCarts.makeCartPacket(cart, id, data)), (EntityPlayerMP)((EntityPlayerMP)player));
    }

    public static void sendPacketToAllAround(int id, byte[] data, EntityMinecartModular cart) {
        PacketStevesCarts.sendToAllAround(new PacketStevesCarts(PacketStevesCarts.makeCartPacket(cart, id, data)), cart.getExactPosition(), cart.func_130014_f_());
    }

    public static void sendBlockInfoToClients(World world, byte[] data, BlockPos pos) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(bs);
        try {
            ds.writeByte(-1);
            ds.writeInt(pos.func_177958_n());
            ds.writeInt(pos.func_177956_o());
            ds.writeInt(pos.func_177952_p());
            for (byte b : data) {
                ds.writeByte(b);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        PacketStevesCarts.sendToAllAround(new PacketStevesCarts(bs.toByteArray()), pos, world);
    }

    private static void sendToAllAround(INetworkPacket packet, BlockPos pos, World world) {
        if (!(world instanceof WorldServer)) {
            return;
        }
        WorldServer worldServer = (WorldServer)world;
        PlayerChunkMap playerManager = worldServer.func_184164_w();
        int chunkX = pos.func_177958_n() >> 4;
        int chunkZ = pos.func_177952_p() >> 4;
        for (Object playerObj : world.field_73010_i) {
            EntityPlayerMP player;
            if (!(playerObj instanceof EntityPlayerMP) || !playerManager.func_72694_a(player = (EntityPlayerMP)playerObj, chunkX, chunkZ)) continue;
            NetworkManager.sendToPlayer((INetworkPacket)packet, (EntityPlayerMP)player);
        }
    }
}

