/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.arcade.tracks;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.arcade.tracks.LevelMessage;
import vswe.stevescarts.arcade.tracks.Track;
import vswe.stevescarts.arcade.tracks.TrackEditor;
import vswe.stevescarts.arcade.tracks.TrackOrientation;
import vswe.stevescarts.helpers.Localization;

public class TrackLevel {
    public static final TrackLevel editor = new TrackLevel(Localization.STORIES.THE_BEGINNING.MAP_EDITOR, 0, 0, TrackOrientation.DIRECTION.RIGHT, 26, 9);
    private static String MAP_FOLDER_PATH = "sc2/arcade/trackoperator/";
    private String name;
    private int playerX;
    private int playerY;
    private TrackOrientation.DIRECTION playerDir;
    private int itemX;
    private int itemY;
    private ArrayList<Track> tracks;
    private ArrayList<LevelMessage> messages;

    private static byte getFileVersion() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static ArrayList<TrackLevel> loadMapsFromFolder() {
        ArrayList<TrackLevel> maps = new ArrayList<TrackLevel>();
        try {
            File dir = new File(Minecraft.func_71410_x().field_71412_D, MAP_FOLDER_PATH);
            File[] children = dir.listFiles();
            if (children != null) {
                for (File child : children) {
                    String name;
                    TrackLevel map;
                    if (!child.isFile() || (map = TrackLevel.loadMap(name = child.getName())) == null) continue;
                    maps.add(map);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Failed to load the maps");
        }
        return maps;
    }

    @SideOnly(value=Side.CLIENT)
    public static TrackLevel loadMap(String filename) {
        try {
            byte[] bytes = TrackLevel.readFromFile(new File(Minecraft.func_71410_x().field_71412_D, MAP_FOLDER_PATH + filename));
            return TrackLevel.loadMapData(bytes);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static TrackLevel loadMap(byte[] bytes) {
        try {
            return TrackLevel.loadMapData(bytes);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static TrackLevel loadMapData(byte[] bytes) throws IOException {
        ByteArrayInputStream data = new ByteArrayInputStream(bytes);
        int version = data.read();
        int namelength = data.read();
        byte[] namebytes = new byte[namelength];
        data.read(namebytes, 0, namelength);
        String name = new String(namebytes, Charset.forName("UTF-8"));
        int header = data.read() << 24 | data.read() << 16 | data.read() << 8 | data.read() << 0;
        int playerX = header & 0x1F;
        int playerY = header >> 5 & 0xF;
        TrackOrientation.DIRECTION playerDir = TrackOrientation.DIRECTION.fromInteger(header >> 9 & 3);
        int itemX = header >> 11 & 0x1F;
        int itemY = header >> 16 & 0xF;
        int tracksize = header >> 20 & 0x1FF;
        TrackLevel map = new TrackLevel(null, playerX, playerY, playerDir, itemX, itemY);
        if (!name.isEmpty()) {
            map.setName(name);
        }
        for (int i = 0; i < tracksize; ++i) {
            int trackdata = data.read() << 16 | data.read() << 8 | data.read() << 0;
            int trackX = trackdata & 0x1F;
            int trackY = trackdata >> 5 & 0xF;
            int type = trackdata >> 9 & 7;
            TrackOrientation orientation = TrackOrientation.ALL.get(trackdata >> 12 & 0x3F);
            int extraLength = trackdata >> 18 & 0x3F;
            Track track = TrackEditor.getRealTrack(trackX, trackY, type, orientation);
            byte[] extraData = new byte[extraLength];
            data.read(extraData);
            track.setExtraInfo(extraData);
            map.getTracks().add(track);
        }
        return map;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean saveMap(String name, int playerX, int playerY, TrackOrientation.DIRECTION playerDir, int itemX, int itemY, ArrayList<Track> tracks) {
        try {
            byte[] bytes = TrackLevel.saveMapData(name, playerX, playerY, playerDir, itemX, itemY, tracks);
            TrackLevel.writeToFile(new File(Minecraft.func_71410_x().field_71412_D, "sc2/arcade/trackoperator/" + name.replace(" ", "_") + ".dat"), bytes);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static String saveMapToString(String name, int playerX, int playerY, TrackOrientation.DIRECTION playerDir, int itemX, int itemY, ArrayList<Track> tracks) {
        try {
            byte[] bytes = TrackLevel.saveMapData(name, playerX, playerY, playerDir, itemX, itemY, tracks);
            String str = "TrackLevel.loadMap(new byte[] {";
            for (int i = 0; i < bytes.length; ++i) {
                if (i != 0) {
                    str = str + ",";
                }
                str = str + bytes[i];
            }
            str = str + "});";
            return str;
        }
        catch (IOException ex) {
            return "";
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static byte[] saveMapData(String name, int playerX, int playerY, TrackOrientation.DIRECTION playerDir, int itemX, int itemY, ArrayList<Track> tracks) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(stream);
        data.writeByte(TrackLevel.getFileVersion());
        data.writeByte(name.length());
        data.writeBytes(name);
        int header = 0;
        header |= playerX;
        header |= playerY << 5;
        header |= playerDir.toInteger() << 9;
        header |= itemX << 11;
        header |= itemY << 16;
        data.writeInt(header |= tracks.size() << 20);
        for (Track track : tracks) {
            int trackdata = 0;
            byte[] extraData = track.getExtraInfo();
            trackdata |= track.getX();
            trackdata |= track.getY() << 5;
            trackdata |= track.getU() << 9;
            trackdata |= track.getOrientation().toInteger() << 12;
            data.write(((trackdata |= extraData.length << 18) & 0xFF0000) >> 16);
            data.write((trackdata & 0xFF00) >> 8);
            data.write(trackdata & 0xFF);
            data.write(extraData);
        }
        return stream.toByteArray();
    }

    @SideOnly(value=Side.CLIENT)
    private static void writeToFile(File file, byte[] bytes) throws IOException {
        TrackLevel.createFolder(file.getParentFile());
        FileOutputStream writer = new FileOutputStream(file);
        writer.write(bytes);
        writer.close();
    }

    @SideOnly(value=Side.CLIENT)
    private static byte[] readFromFile(File file) throws IOException {
        TrackLevel.createFolder(file.getParentFile());
        FileInputStream reader = new FileInputStream(file);
        byte[] bytes = new byte[(int)file.length()];
        reader.read(bytes);
        reader.close();
        return bytes;
    }

    @SideOnly(value=Side.CLIENT)
    private static void createFolder(File dir) throws IOException {
        if (dir == null) {
            return;
        }
        File parent = dir.getParentFile();
        TrackLevel.createFolder(parent);
        if (!dir.isDirectory()) {
            dir.mkdirs();
        }
    }

    public TrackLevel(Localization.STORIES.THE_BEGINNING name, int playerX, int playerY, TrackOrientation.DIRECTION playerDir, int itemX, int itemY) {
        if (name != null) {
            this.name = name.translate(new String[0]);
        }
        this.playerX = playerX;
        this.playerY = playerY;
        this.playerDir = playerDir;
        this.itemX = itemX;
        this.itemY = itemY;
        this.tracks = new ArrayList();
        this.messages = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public void setName(Localization.STORIES.THE_BEGINNING name) {
        this.name = name.translate(new String[0]);
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPlayerStartX() {
        return this.playerX;
    }

    public int getPlayerStartY() {
        return this.playerY;
    }

    public TrackOrientation.DIRECTION getPlayerStartDirection() {
        return this.playerDir;
    }

    public int getItemX() {
        return this.itemX;
    }

    public int getItemY() {
        return this.itemY;
    }

    public ArrayList<Track> getTracks() {
        return this.tracks;
    }

    public ArrayList<LevelMessage> getMessages() {
        return this.messages;
    }

    public void addMessage(LevelMessage levelMessage) {
        this.messages.add(levelMessage);
    }
}

