/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.teleport.telepad;

import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.fluid.SmartTank;
import com.enderio.core.common.inventory.EnderInventory;
import com.enderio.core.common.inventory.Filters;
import com.enderio.core.common.inventory.InventorySlot;
import com.enderio.core.common.util.NullHelper;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import crazypants.enderio.api.ILocalizable;
import crazypants.enderio.api.teleport.ITelePad;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.base.capacitor.DefaultCapacitorData;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.item.coordselector.TelepadTarget;
import crazypants.enderio.base.machine.interfaces.INotifier;
import crazypants.enderio.base.machine.sound.MachineSound;
import crazypants.enderio.base.teleport.TeleportUtil;
import crazypants.enderio.machines.capacitor.CapacitorKey;
import crazypants.enderio.machines.config.config.TelePadConfig;
import crazypants.enderio.machines.lang.Lang;
import crazypants.enderio.machines.machine.teleport.anchor.TileTravelAnchor;
import crazypants.enderio.machines.machine.teleport.telepad.packet.PacketSetTarget;
import crazypants.enderio.machines.machine.teleport.telepad.packet.PacketTelePadFluidLevel;
import crazypants.enderio.machines.machine.teleport.telepad.packet.PacketTeleport;
import crazypants.enderio.machines.machine.teleport.telepad.packet.PacketTeleportTrigger;
import crazypants.enderio.machines.machine.teleport.telepad.render.BlockType;
import crazypants.enderio.machines.network.PacketHandler;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileTelePad
extends TileTravelAnchor
implements ITelePad,
IProgressTile,
ITankAccess.IExtendedTankAccess,
INotifier {
    @Nonnull
    public static final Predicate<ItemStack> LOCATION_PRINTOUTS = new Filters.PredicateItemStack(){

        public boolean doApply(@Nonnull ItemStack input) {
            return TelepadTarget.readFromNBT(input) != null;
        }
    };
    private TileTelePad masterTile = null;
    private boolean coordsChanged = false;
    @Store
    @Nonnull
    private TelepadTarget target = new TelepadTarget(new BlockPos(0, 0, 0), Integer.MIN_VALUE);
    private Queue<Entity> toTeleport = Queues.newArrayDeque();
    private int powerUsed;
    private int requiredPower;
    @Nonnull
    public static final ResourceLocation ACTIVE_RES = new ResourceLocation("enderio", "telepad.active");
    @SideOnly(value=Side.CLIENT)
    private MachineSound activeSound;
    @Store
    private boolean redstoneActivePrev;
    private final Fluid fluidType;
    @Store
    @Nonnull
    protected final SmartTank tank;
    private boolean tankDirty = false;
    @Nonnull
    public static final String TELEPORTING_KEY = "eio:teleporting";
    @Nonnull
    public static final String PROGRESS_KEY = "teleportprogress";
    boolean wasBlocked = false;
    public float[] bladeRots = new float[3];
    public float spinSpeed = 0.0f;
    public float speedMult = 2.5f;

    public TileTelePad() {
        super(CapacitorKey.TELEPAD_POWER_INTAKE, CapacitorKey.TELEPAD_POWER_BUFFER, CapacitorKey.TELEPAD_POWER_USE);
        this.getInventory().add(EnderInventory.Type.INPUT, "INPUT", new InventorySlot(LOCATION_PRINTOUTS, 1));
        this.getInventory().add(EnderInventory.Type.OUTPUT, "OUTPUT", new InventorySlot(1));
        this.fluidType = (Fluid)TelePadConfig.telepadFluidType.get();
        int tankCap = (Integer)TelePadConfig.telepadFluidUse.get() * 10;
        this.tank = new SmartTank(this.fluidType, tankCap);
        if (tankCap <= 0) {
            this.tank.setCanFill(false);
        }
        this.tank.setCanDrain(false);
        this.tank.setTileEntity((TileEntity)this);
        this.getInventory().getSlot("cap").set(new ItemStack(ModObject.itemBasicCapacitor.getItemNN(), 1, DefaultCapacitorData.ENDER_CAPACITOR.ordinal()));
    }

    public boolean isFluidEnabled() {
        return this.tank.getCapacity() > 0;
    }

    public boolean wasBlocked() {
        return this.wasBlocked;
    }

    public void setBlocked(boolean blocked) {
        this.wasBlocked = blocked;
    }

    @Override
    public boolean isMaster() {
        return BlockType.getType(this.func_145832_p()) == BlockType.MASTER;
    }

    @Override
    public TileTelePad getMaster() {
        if (BlockType.getType(this.func_145832_p()) == BlockType.MASTER) {
            return this;
        }
        BlockPos offset = BlockType.getType(this.func_145832_p()).getOffsetToMaster();
        if (offset == null) {
            return null;
        }
        BlockPos materPos = this.func_174877_v().func_177982_a(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p());
        if (!this.field_145850_b.func_175667_e(materPos)) {
            return null;
        }
        TileEntity res = this.field_145850_b.func_175625_s(materPos);
        if (res instanceof TileTelePad) {
            return (TileTelePad)res;
        }
        return null;
    }

    @Override
    public boolean inNetwork() {
        return this.getMaster() != null;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        if (!this.isMaster()) {
            return false;
        }
        if (this.target.getDimension() == Integer.MIN_VALUE) {
            this.target.setDimension(this.field_145850_b.field_73011_w.getDimension());
        }
        if (!this.getInventory().getSlot("INPUT").isEmpty() && this.getInventory().getSlot("OUTPUT").isEmpty()) {
            ItemStack stack = this.getInventory().getSlot("INPUT").get();
            this.setTarget(TelepadTarget.readFromNBT(stack));
            this.getInventory().getSlot("INPUT").clear();
            this.getInventory().getSlot("OUTPUT").set(stack);
        }
        if (this.tankDirty && this.shouldDoWorkThisTick(10)) {
            PacketHandler.sendToAllAround((IMessage)new PacketTelePadFluidLevel(this), (TileEntity)this);
            this.tankDirty = false;
        }
        if (this.active()) {
            if (this.powerUsed >= this.requiredPower) {
                this.teleport(this.toTeleport.poll());
                this.powerUsed = 0;
            } else {
                int usable = Math.min(Math.min(this.getUsage(), this.requiredPower), this.getEnergy().getEnergyStored());
                this.getEnergy().setEnergyStored(this.getEnergy().getEnergyStored() - usable);
                this.powerUsed += usable;
            }
            if (this.shouldDoWorkThisTick(5)) {
                this.updateQueuedEntities();
            }
            PacketHandler.INSTANCE.sendToAllAround(this.getProgressPacket(), (TileEntity)this);
        }
        if (this.coordsChanged) {
            this.coordsChanged = false;
            PacketHandler.sendToAllAround((IMessage)new PacketSetTarget(this, this.target), (TileEntity)this);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void updateEntityClient() {
        this.updateRotations();
        if (this.activeSound != null) {
            this.activeSound.setPitch(MathHelper.func_76131_a((float)(0.5f + this.spinSpeed / 1.5f), (float)0.5f, (float)2.0f));
        }
        if (this.active()) {
            if (this.activeSound == null) {
                BlockPos p = this.func_174877_v();
                this.activeSound = new MachineSound(ACTIVE_RES, p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), 0.3f, 1.0f);
                FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)this.activeSound);
            }
            this.updateQueuedEntities();
        } else if (!this.active() && this.activeSound != null && this.activeSound.func_147655_f() <= 0.5f) {
            this.activeSound.endPlaying();
            this.activeSound = null;
        }
    }

    private void updateQueuedEntities() {
        if (this.field_145850_b.field_72995_K && this.active()) {
            this.getCurrentTarget().getEntityData().func_74776_a(PROGRESS_KEY, this.getProgress());
        }
        ArrayList toRemove = Lists.newArrayList();
        for (Entity e : this.toTeleport) {
            if (this.isEntityInRange(e) && !e.field_70128_L) continue;
            toRemove.add(e);
        }
        for (Entity e : toRemove) {
            this.dequeueTeleport(e, true);
        }
    }

    public void updateRedstoneState() {
        if (!this.inNetwork()) {
            return;
        }
        boolean redstone = this.isPoweredRedstone();
        if (!this.getMasterTile().redstoneActivePrev && redstone) {
            this.teleportAll();
        }
        this.getMasterTile().redstoneActivePrev = redstone;
    }

    public boolean isPainted() {
        return this.sourceBlock != null;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            this.stopPlayingSound();
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.field_145850_b.field_72995_K) {
            this.stopPlayingSound();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void stopPlayingSound() {
        if (this.activeSound != null) {
            this.activeSound.endPlaying();
            this.activeSound = null;
        }
    }

    public int getPowerScaled(int scale) {
        return (int)((float)this.getEnergy().getEnergyStored() / (float)this.getEnergy().getMaxEnergyStored() * (float)scale);
    }

    private int calculateTeleportPower() {
        if (this.field_145850_b.field_73011_w.getDimension() == this.target.getDimension()) {
            int distance = (int)Math.ceil(this.field_174879_c.func_185332_f(this.target.getLocation().func_177958_n(), this.target.getLocation().func_177956_o(), this.target.getLocation().func_177952_p()));
            double base = Math.log(0.005 * (double)distance + 1.0);
            this.requiredPower = (int)(base * (double)((Integer)TelePadConfig.telepadPowerCoefficient.get()).intValue());
        } else {
            this.requiredPower = (Integer)TelePadConfig.telepadPowerInterdimensional.get();
        }
        int res = MathHelper.func_76125_a((int)this.requiredPower, (int)5000, (int)((Integer)TelePadConfig.telepadPowerInterdimensional.get()));
        return res;
    }

    public boolean active() {
        return !this.toTeleport.isEmpty();
    }

    public Entity getCurrentTarget() {
        return this.toTeleport.peek();
    }

    @Nonnull
    public AxisAlignedBB getBoundingBox() {
        BlockPos p = this.func_174877_v();
        if (!this.inNetwork()) {
            return new AxisAlignedBB(p, p.func_177972_a(EnumFacing.UP).func_177972_a(EnumFacing.SOUTH).func_177972_a(EnumFacing.EAST));
        }
        p = this.getMaster().getLocation();
        return new AxisAlignedBB((double)(p.func_177958_n() - 1), (double)p.func_177956_o(), (double)(p.func_177952_p() - 1), (double)(p.func_177958_n() + 2), (double)(p.func_177956_o() + 1), (double)(p.func_177952_p() + 2));
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return this.getBoundingBox();
    }

    public void updateRotations() {
        this.spinSpeed = this.active() ? this.getProgress() * 2.0f : Math.max(0.0f, this.spinSpeed - 0.025f);
        int i = 0;
        while (i < this.bladeRots.length) {
            int n = i;
            this.bladeRots[n] = this.bladeRots[n] + this.spinSpeed * (float)(i * 2 + 20);
            int n2 = i++;
            this.bladeRots[n2] = this.bladeRots[n2] % 360.0f;
        }
    }

    public float getProgress() {
        return (float)this.powerUsed / (float)this.requiredPower;
    }

    public void setProgress(float progress) {
        this.powerUsed = progress < 0.0f ? 0 : (int)((float)this.requiredPower * progress);
    }

    @Nonnull
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public int getX() {
        if (this.inNetwork()) {
            return this.getMasterTile().target.getX();
        }
        return this.target.getX();
    }

    @Override
    public int getY() {
        if (this.inNetwork()) {
            return this.getMasterTile().target.getY();
        }
        return this.target.getY();
    }

    @Override
    public int getZ() {
        if (this.inNetwork()) {
            return this.getMasterTile().target.getZ();
        }
        return this.target.getZ();
    }

    @Override
    public int getTargetDim() {
        if (this.inNetwork()) {
            return this.getMasterTile().target.getDimension();
        }
        return this.target.getDimension();
    }

    @Override
    public void setX(int x) {
        if (((Boolean)TelePadConfig.telepadLockCoords.get()).booleanValue()) {
            return;
        }
        this.setTarget(this.getTarget().setX(x));
    }

    @Override
    public void setY(int y) {
        if (((Boolean)TelePadConfig.telepadLockCoords.get()).booleanValue()) {
            return;
        }
        this.setTarget(this.getTarget().setY(y));
    }

    @Override
    public void setZ(int z) {
        if (((Boolean)TelePadConfig.telepadLockCoords.get()).booleanValue()) {
            return;
        }
        this.setTarget(this.getTarget().setZ(z));
    }

    @Override
    public void setTargetDim(int dimID) {
        if (((Boolean)TelePadConfig.telepadLockCoords.get()).booleanValue()) {
            return;
        }
        this.setTarget(this.getTarget().setDimension(dimID));
    }

    @Override
    public void setCoords(@Nonnull BlockPos coords) {
        if (((Boolean)TelePadConfig.telepadLockCoords.get()).booleanValue()) {
            return;
        }
        this.setTarget(this.getTarget().setLocation(coords));
    }

    public void setTarget(@Nullable TelepadTarget newTarget) {
        if (this.inNetwork() && !this.isMaster()) {
            this.getMaster().setTarget(newTarget);
            return;
        }
        if (newTarget == null) {
            newTarget = new TelepadTarget();
        }
        this.target = new TelepadTarget(newTarget);
        this.coordsChanged = true;
        this.func_70296_d();
    }

    @Nonnull
    public TelepadTarget getTarget() {
        if (!this.inNetwork() || this.isMaster()) {
            return this.target;
        }
        return this.getMaster().getTarget();
    }

    @Override
    public void teleportSpecific(@Nonnull Entity entity) {
        if (!this.inNetwork()) {
            return;
        }
        if (this.isMaster()) {
            if (this.isEntityInRange(entity)) {
                this.enqueueTeleport(entity, true);
            }
        } else {
            this.getMasterTile().teleportSpecific(entity);
        }
    }

    @Override
    public void teleportAll() {
        TileTelePad m = this.getMasterTile();
        if (m == null) {
            return;
        }
        if (this.target.getY() <= 0) {
            return;
        }
        if (m.field_145850_b.field_72995_K) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketTeleportTrigger(m));
        } else {
            for (Entity e : m.getEntitiesInRange()) {
                m.enqueueTeleport(e, true);
            }
        }
    }

    @Nonnull
    private List<Entity> getEntitiesInRange() {
        return this.field_145850_b.func_72872_a(Entity.class, this.getRange());
    }

    private boolean isEntityInRange(Entity entity) {
        return this.getRange().func_72318_a(new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
    }

    @Nonnull
    private AxisAlignedBB getRange() {
        BlockPos p = this.func_174877_v();
        return new AxisAlignedBB((double)(p.func_177958_n() - 1), (double)p.func_177956_o(), (double)(p.func_177952_p() - 1), (double)(p.func_177958_n() + 2), (double)(p.func_177956_o() + 3), (double)(p.func_177952_p() + 2));
    }

    public void enqueueTeleport(Entity entity, boolean sendUpdate) {
        if (entity == null || this.toTeleport.contains(entity)) {
            return;
        }
        this.calculateTeleportPower();
        entity.getEntityData().func_74757_a(TELEPORTING_KEY, true);
        this.toTeleport.add(entity);
        if (sendUpdate && !entity.field_70170_p.field_72995_K) {
            PacketHandler.INSTANCE.sendToAll((IMessage)new PacketTeleport(PacketTeleport.Type.BEGIN, this, entity));
        }
    }

    public void dequeueTeleport(Entity entity, boolean sendUpdate) {
        if (entity == null) {
            return;
        }
        this.toTeleport.remove(entity);
        entity.getEntityData().func_74757_a(TELEPORTING_KEY, false);
        if (sendUpdate && !this.field_145850_b.field_72995_K) {
            PacketHandler.INSTANCE.sendToAll((IMessage)new PacketTeleport(PacketTeleport.Type.END, this, entity));
        }
        if (!this.active()) {
            this.powerUsed = 0;
        }
    }

    private boolean teleport(Entity entity) {
        if (this.requiredPower <= 0) {
            return false;
        }
        if ((Integer)TelePadConfig.telepadFluidUse.get() > 0) {
            if (this.tank.getFluidAmount() < (Integer)TelePadConfig.telepadFluidUse.get()) {
                this.tank.drain(((Integer)TelePadConfig.telepadFluidUse.get()).intValue(), true);
                if (entity instanceof EntityPlayer) {
                    ((EntityPlayer)entity).func_145747_a((ITextComponent)Lang.GUI_TELEPAD_NOFLUID.toChatServer(new FluidStack(this.fluidType, 1).getLocalizedName()));
                }
                this.wasBlocked = true;
                return true;
            }
            this.tank.drainInternal(((Integer)TelePadConfig.telepadFluidUse.get()).intValue(), true);
        }
        entity.getEntityData().func_74757_a(TELEPORTING_KEY, false);
        this.wasBlocked = !(!entity.field_70170_p.field_72995_K ? this.serverTeleport(entity) : this.clientTeleport(entity));
        PacketHandler.INSTANCE.sendToAll((IMessage)new PacketTeleport(PacketTeleport.Type.TELEPORT, this, this.wasBlocked));
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).func_71053_j();
        }
        return !this.wasBlocked;
    }

    private boolean clientTeleport(@Nonnull Entity entity) {
        return TeleportUtil.checkClientTeleport(entity, this.target.getLocation(), this.target.getDimension(), TravelSource.TELEPAD);
    }

    private boolean serverTeleport(@Nonnull Entity entity) {
        this.dequeueTeleport(entity, true);
        return TeleportUtil.serverTeleport(entity, this.target.getLocation(), this.target.getDimension(), false, TravelSource.TELEPAD);
    }

    @Override
    public boolean canSeeBlock(@Nonnull EntityPlayer playerName) {
        return this.isMaster() && this.inNetwork();
    }

    public int getUsage() {
        return this.getEnergy().getMaxUsage();
    }

    private TileTelePad getMasterTile() {
        if (this.masterTile != null) {
            return this.masterTile;
        }
        this.masterTile = this.getMaster();
        return this.masterTile;
    }

    @Override
    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facingIn) {
        if (this.isMaster()) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
            }
            return super.getCapability(capability, facingIn);
        }
        if (this.inNetwork()) {
            return ((TileTelePad)NullHelper.notnull((Object)this.getMaster(), (String)"Telepad master is null while in network!")).getCapability(capability, facingIn);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY) {
            return null;
        }
        return super.getCapability(capability, facingIn);
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        if (forFluidType == null || forFluidType.getFluid() != this.fluidType) {
            return null;
        }
        TileTelePad master = this.getMaster();
        if (master == null) {
            return null;
        }
        return master.tank;
    }

    @Nonnull
    public FluidTank[] getOutputTanks() {
        return new FluidTank[0];
    }

    public void setTanksDirty() {
        this.tankDirty = true;
        this.func_70296_d();
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public void setFluidAmount(int level) {
        this.tank.setFluidAmount(level);
    }

    @Nonnull
    public FluidTank getTank() {
        return this.tank;
    }

    public Fluid getFluidType() {
        return this.fluidType;
    }

    @Nonnull
    public List<ITankAccess.ITankData> getTankDisplayData() {
        if (this.inNetwork()) {
            return this.getMaster().createDisplayData();
        }
        return Collections.emptyList();
    }

    @Nonnull
    private List<ITankAccess.ITankData> createDisplayData() {
        TankData data = new TankData();
        return Collections.singletonList(data);
    }

    @Override
    public boolean isTravelSource() {
        return this.isMaster() && this.inNetwork() && (Boolean)TelePadConfig.telepadIsTravelAnchor.get() != false;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.isTravelSource();
    }

    @Override
    @Nonnull
    public Set<? extends ILocalizable> getNotification() {
        return this.inNetwork() ? Collections.emptySet() : Collections.singleton(new ILocalizable(){

            @Override
            @Nonnull
            public String getUnlocalizedName() {
                return Lang.STATUS_TELEPAD_UNFORMED.getKey();
            }
        });
    }

    @Override
    protected void onAfterNbtRead() {
        this.getInventory().getSlot("cap").set(new ItemStack(ModObject.itemBasicCapacitor.getItemNN(), 1, DefaultCapacitorData.ENDER_CAPACITOR.ordinal()));
        super.onAfterNbtRead();
    }

    private class TankData
    implements ITankAccess.ITankData {
        private TankData() {
        }

        @Nonnull
        public ITankAccess.ITankData.EnumTankType getTankType() {
            return ITankAccess.ITankData.EnumTankType.INPUT;
        }

        public FluidStack getContent() {
            return TileTelePad.this.getTank().getFluid();
        }

        public int getCapacity() {
            return TileTelePad.this.tank.getCapacity();
        }
    }
}

