/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.soul;

import com.enderio.core.client.render.ManagedTESR;
import com.enderio.core.common.util.IBlockAccessWrapper;
import crazypants.enderio.base.paint.YetaUtil;
import crazypants.enderio.base.render.property.EnumRenderMode;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.machine.soul.TileSoulBinder;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class SoulBinderTESR
extends ManagedTESR<TileSoulBinder> {
    public SoulBinderTESR() {
        super(MachineObject.block_soul_binder.getBlock());
    }

    protected boolean shouldRender(@Nonnull TileSoulBinder te, @Nonnull IBlockState blockState, int renderPass) {
        return te.isWorking() && (te.getPaintSource() == null || YetaUtil.shouldHeldItemHideFacadesClient());
    }

    protected void renderTileEntity(@Nonnull TileSoulBinder te, @Nonnull IBlockState blockState, float partialTicks, int destroyStage) {
        GlStateManager.func_179109_b((float)0.5f, (float)0.0f, (float)0.5f);
        GlStateManager.func_179114_b((float)(360.0f * te.getProgress()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)-0.5f, (float)0.0f, (float)-0.5f);
        GL11.glDisable((int)2896);
        EnumRenderMode renderMode = te.isActive() ? EnumRenderMode.FRONT_ON : EnumRenderMode.FRONT;
        SoulBinderTESR.renderBlockModel(te.func_145831_w(), te.func_174877_v(), blockState.func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)renderMode.rotate(te.getFacing()))), true, (double)te.getProgress() > 0.005 && (double)te.getProgress() < 0.995);
        GL11.glEnable((int)2896);
    }

    public static void renderBlockModel(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean translateToOrigin, boolean relight) {
        BufferBuilder wr = Tessellator.func_178181_a().func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        if (translateToOrigin) {
            wr.func_178969_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        }
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
        BlockModelShapes modelShapes = blockrendererdispatcher.func_175023_a();
        IBakedModel ibakedmodel = modelShapes.func_178125_b(state);
        Object worldWrapper = relight ? new WorldWrapper(world, pos) : world;
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            if (!state.func_177230_c().canRenderInLayer(state, layer)) continue;
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
            blockrendererdispatcher.func_175019_b().func_178267_a((IBlockAccess)worldWrapper, ibakedmodel, state, pos, wr, false);
        }
        ForgeHooksClient.setRenderLayer(null);
        if (translateToOrigin) {
            wr.func_178969_c(0.0, 0.0, 0.0);
        }
        Tessellator.func_178181_a().func_78381_a();
    }

    private static class WorldWrapper
    extends IBlockAccessWrapper {
        private final Map<BlockPos, Pair<Integer, Integer>> light = new HashMap<BlockPos, Pair<Integer, Integer>>();

        public WorldWrapper(@Nonnull World world, @Nonnull BlockPos pos) {
            super((IBlockAccess)world);
            int maxSky = 0;
            int maxBlk = 0;
            for (EnumFacing face : EnumFacing.Plane.HORIZONTAL) {
                maxSky = Math.max(maxSky, world.func_175705_a(EnumSkyBlock.SKY, pos.func_177972_a(face)));
                maxBlk = Math.max(maxBlk, world.func_175705_a(EnumSkyBlock.BLOCK, pos.func_177972_a(face)));
            }
            for (EnumFacing face : EnumFacing.Plane.HORIZONTAL) {
                this.light.put(pos.func_177972_a(face), (Pair<Integer, Integer>)Pair.of((Object)maxSky, (Object)maxBlk));
            }
            maxBlk = 0;
            maxSky = 0;
            for (EnumFacing face : EnumFacing.Plane.HORIZONTAL) {
                maxSky = Math.max(maxSky, world.func_175705_a(EnumSkyBlock.SKY, pos.func_177972_a(face).func_177984_a()));
                maxBlk = Math.max(maxBlk, world.func_175705_a(EnumSkyBlock.BLOCK, pos.func_177972_a(face).func_177984_a()));
            }
            for (EnumFacing face : EnumFacing.Plane.HORIZONTAL) {
                this.light.put(pos.func_177972_a(face).func_177984_a(), (Pair<Integer, Integer>)Pair.of((Object)maxSky, (Object)maxBlk));
            }
            maxBlk = 0;
            maxSky = 0;
            for (EnumFacing face : EnumFacing.Plane.HORIZONTAL) {
                maxSky = Math.max(maxSky, world.func_175705_a(EnumSkyBlock.SKY, pos.func_177972_a(face).func_177977_b()));
                maxBlk = Math.max(maxBlk, world.func_175705_a(EnumSkyBlock.BLOCK, pos.func_177972_a(face).func_177977_b()));
            }
            for (EnumFacing face : EnumFacing.Plane.HORIZONTAL) {
                this.light.put(pos.func_177972_a(face).func_177977_b(), (Pair<Integer, Integer>)Pair.of((Object)maxSky, (Object)maxBlk));
            }
            maxBlk = 0;
            maxSky = 0;
            for (EnumFacing face : EnumFacing.Plane.HORIZONTAL) {
                maxSky = Math.max(maxSky, world.func_175705_a(EnumSkyBlock.SKY, pos.func_177972_a(face).func_177984_a().func_177972_a(face.func_176746_e())));
                maxBlk = Math.max(maxBlk, world.func_175705_a(EnumSkyBlock.BLOCK, pos.func_177972_a(face).func_177984_a().func_177972_a(face.func_176746_e())));
            }
            for (EnumFacing face : EnumFacing.Plane.HORIZONTAL) {
                this.light.put(pos.func_177972_a(face).func_177984_a().func_177972_a(face.func_176746_e()), (Pair<Integer, Integer>)Pair.of((Object)maxSky, (Object)maxBlk));
            }
            maxBlk = 0;
            maxSky = 0;
            for (EnumFacing face : EnumFacing.Plane.HORIZONTAL) {
                maxSky = Math.max(maxSky, world.func_175705_a(EnumSkyBlock.SKY, pos.func_177972_a(face).func_177977_b().func_177972_a(face.func_176746_e())));
                maxBlk = Math.max(maxBlk, world.func_175705_a(EnumSkyBlock.BLOCK, pos.func_177972_a(face).func_177977_b().func_177972_a(face.func_176746_e())));
            }
            for (EnumFacing face : EnumFacing.Plane.HORIZONTAL) {
                this.light.put(pos.func_177972_a(face).func_177977_b().func_177972_a(face.func_176746_e()), (Pair<Integer, Integer>)Pair.of((Object)maxSky, (Object)maxBlk));
            }
            maxBlk = 0;
            maxSky = 0;
            for (EnumFacing face : EnumFacing.Plane.HORIZONTAL) {
                maxSky = Math.max(maxSky, world.func_175705_a(EnumSkyBlock.SKY, pos.func_177972_a(face).func_177972_a(face.func_176746_e())));
                maxBlk = Math.max(maxBlk, world.func_175705_a(EnumSkyBlock.BLOCK, pos.func_177972_a(face).func_177972_a(face.func_176746_e())));
            }
            for (EnumFacing face : EnumFacing.Plane.HORIZONTAL) {
                this.light.put(pos.func_177972_a(face).func_177972_a(face.func_176746_e()), (Pair<Integer, Integer>)Pair.of((Object)maxSky, (Object)maxBlk));
            }
        }

        public int func_175626_b(@Nonnull BlockPos pos, int lightValue) {
            if (this.light.containsKey(pos)) {
                Pair<Integer, Integer> pair = this.light.get(pos);
                int sky = (Integer)pair.getLeft();
                int blk = (Integer)pair.getRight();
                if (blk < lightValue) {
                    blk = lightValue;
                }
                return sky << 20 | blk << 4;
            }
            return this.wrapped.func_175626_b(pos, lightValue);
        }

        @Nonnull
        public IBlockState func_180495_p(@Nonnull BlockPos pos) {
            if (this.light.containsKey(pos)) {
                return Blocks.field_150350_a.func_176223_P();
            }
            return super.func_180495_p(pos);
        }

        public boolean func_175623_d(@Nonnull BlockPos pos) {
            if (this.light.containsKey(pos)) {
                return true;
            }
            return super.func_175623_d(pos);
        }
    }
}

