/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.event.abstractbase;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ServerMessage;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.User;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.abstractbase.ActorEventBase;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.helper.UserInfoChangeEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Change;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public class UserInfoChangeEventBase<Type>
extends ActorEventBase<User>
implements UserInfoChangeEvent<Type> {
    private final User newUser;
    private final Change<Type> change;

    protected UserInfoChangeEventBase(@Nonnull Client client, @Nonnull List<ServerMessage> originalMessages, @Nonnull User oldUser, @Nonnull User newUser, @Nonnull Function<User, Type> changedInfoGetter) {
        super(client, originalMessages, oldUser);
        this.newUser = Sanity.nullCheck(newUser, "New user cannot be null");
        this.change = new Change<Type>(changedInfoGetter.apply(oldUser), changedInfoGetter.apply(newUser));
    }

    @Override
    @Nonnull
    public User getOldUser() {
        return (User)this.getActor();
    }

    @Override
    @Nonnull
    public User getNewUser() {
        return this.newUser;
    }

    @Override
    @Nonnull
    public Change<Type> getChange() {
        return this.change;
    }

    @Override
    @Nonnull
    protected ToStringer toStringer() {
        return super.toStringer().add("newUser", this.newUser).add("change", this.change);
    }
}

