/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library;

import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.TrustManagerFactory;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.AwayCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.CapabilityRequestCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.ChannelModeCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.KickCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.MonitorCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.OperCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.TopicCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.WallopsCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.WhoisCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.Channel;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.MessageReceiver;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.User;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ModeStatusList;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.UserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.ActorTracker;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.AuthManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.CapabilityManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.EventManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.ISupportManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.MessageTagManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.ServerInfo;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.defaultmessage.DefaultMessageMap;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sending.MessageSendingQueue;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsMachine;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsStorageManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Cutter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Listener;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Pair;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;

public interface Client {
    @Nonnull
    public static Builder builder() {
        try {
            Constructor<?> constructor = Class.forName(Client.class.getPackage().getName() + ".defaults.DefaultBuilder").getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (Builder)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Kitteh IRC Client Library cannot create a Client builder.", e);
        }
    }

    public void addChannel(String ... var1);

    public void addKeyProtectedChannel(@Nonnull String var1, @Nonnull String var2);

    public void addKeyProtectedChannel(Pair<String, String> ... var1);

    @Nonnull
    public Commands commands();

    @Nonnull
    public AuthManager getAuthManager();

    @Nonnull
    public CapabilityManager getCapabilityManager();

    @Nonnull
    public Optional<Channel> getChannel(@Nonnull String var1);

    @Nonnull
    public Set<Channel> getChannels();

    @Nonnull
    public Set<Channel> getChannels(@Nonnull Collection<String> var1);

    @Nonnull
    public DefaultMessageMap getDefaultMessageMap();

    @Nonnull
    public EventManager getEventManager();

    @Nonnull
    public Listener<Exception> getExceptionListener();

    @Nonnull
    public String getIntendedNick();

    @Nonnull
    public Optional<StsMachine> getStsMachine();

    @Nonnull
    public ISupportManager getISupportManager();

    @Nonnull
    public Cutter getMessageCutter();

    @Nonnull
    public Function<WithManagement, ? extends MessageSendingQueue> getMessageSendingQueueSupplier();

    @Nonnull
    public MessageTagManager getMessageTagManager();

    @Nonnull
    public String getName();

    @Nonnull
    public String getNick();

    @Nonnull
    public ServerInfo getServerInfo();

    @Nonnull
    public Optional<User> getUser();

    @Nonnull
    public Optional<ModeStatusList<UserMode>> getUserModes();

    default public boolean isUser(@Nullable User user) {
        return user != null && user.equals(this.getUser().orElse(null));
    }

    public void knockChannel(@Nonnull String var1);

    public void reconnect();

    public void reconnect(@Nullable String var1);

    public void removeChannel(@Nonnull String var1);

    public void removeChannel(@Nonnull String var1, @Nullable String var2);

    public void sendCtcpMessage(@Nonnull String var1, @Nonnull String var2);

    default public void sendCtcpMessage(@Nonnull MessageReceiver target, @Nonnull String message) {
        Sanity.nullCheck(target, "Target cannot be null");
        this.sendCtcpMessage(target.getMessagingName(), message);
    }

    public void sendCtcpReply(@Nonnull String var1, @Nonnull String var2);

    default public void sendCtcpReply(@Nonnull MessageReceiver target, @Nonnull String message) {
        Sanity.nullCheck(target, "Target cannot be null");
        this.sendCtcpMessage(target.getMessagingName(), message);
    }

    public void sendMessage(@Nonnull String var1, @Nonnull String var2);

    default public void sendMessage(@Nonnull MessageReceiver target, @Nonnull String message) {
        Sanity.nullCheck(target, "Target cannot be null");
        this.sendMessage(target.getMessagingName(), message);
    }

    public void sendNotice(@Nonnull String var1, @Nonnull String var2);

    default public void sendNotice(@Nonnull MessageReceiver target, @Nonnull String message) {
        Sanity.nullCheck(target, "Target cannot be null");
        this.sendNotice(target.getMessagingName(), message);
    }

    default public void sendMultiLineMessage(@Nonnull String target, @Nonnull String message) {
        this.sendMultiLineMessage(target, message, this.getMessageCutter());
    }

    public void sendMultiLineMessage(@Nonnull String var1, @Nonnull String var2, @Nonnull Cutter var3);

    default public void sendMultiLineMessage(@Nonnull MessageReceiver target, @Nonnull String message) {
        this.sendMultiLineMessage(target, message, this.getMessageCutter());
    }

    default public void sendMultiLineMessage(@Nonnull MessageReceiver target, @Nonnull String message, @Nonnull Cutter cutter) {
        Sanity.nullCheck(target, "Target cannot be null");
        this.sendMultiLineMessage(target.getMessagingName(), message, cutter);
    }

    default public void sendMultiLineNotice(@Nonnull String target, @Nonnull String message) {
        this.sendMultiLineNotice(target, message, this.getMessageCutter());
    }

    public void sendMultiLineNotice(@Nonnull String var1, @Nonnull String var2, @Nonnull Cutter var3);

    default public void sendMultiLineNotice(@Nonnull MessageReceiver target, @Nonnull String message) {
        this.sendMultiLineNotice(target, message, this.getMessageCutter());
    }

    default public void sendMultiLineNotice(@Nonnull MessageReceiver target, @Nonnull String message, @Nonnull Cutter cutter) {
        Sanity.nullCheck(target, "Target cannot be null");
        this.sendMultiLineNotice(target.getMessagingName(), message, cutter);
    }

    public void sendRawLine(@Nonnull String var1);

    public void sendRawLineAvoidingDuplication(@Nonnull String var1);

    public void sendRawLineImmediately(@Nonnull String var1);

    public void setExceptionListener(@Nullable Consumer<Exception> var1);

    public void setDefaultMessageMap(@Nonnull DefaultMessageMap var1);

    public void setInputListener(@Nullable Consumer<String> var1);

    public void setMessageCutter(@Nonnull Cutter var1);

    public void setMessageSendingQueueSupplier(@Nonnull Function<WithManagement, ? extends MessageSendingQueue> var1);

    public void setNick(@Nonnull String var1);

    public void setOutputListener(@Nullable Consumer<String> var1);

    public void connect();

    public void shutdown();

    public void shutdown(@Nullable String var1);

    public static interface WithManagement
    extends Client {
        public void beginMessageSendingImmediate(@Nonnull Consumer<String> var1);

        @Nonnull
        public ActorTracker getActorTracker();

        @Nonnull
        public InetSocketAddress getBindAddress();

        @Override
        @Nonnull
        public CapabilityManager.WithManagement getCapabilityManager();

        @Nonnull
        public Listener<String> getInputListener();

        @Nonnull
        public Set<String> getIntendedChannels();

        @Nonnull
        public Listener<String> getOutputListener();

        @Nonnull
        public String getRequestedNick();

        @Nullable
        public Path getSecureKey();

        @Nullable
        public Path getSecureKeyCertChain();

        @Nullable
        public String getSecureKeyPassword();

        @Nullable
        public TrustManagerFactory getSecureTrustManagerFactory();

        @Nonnull
        public InetSocketAddress getServerAddress();

        @Override
        @Nonnull
        public ServerInfo.WithManagement getServerInfo();

        public void pauseMessageSending();

        public void ping();

        public void processLine(@Nonnull String var1);

        public void sendNickChange(@Nonnull String var1);

        public void setCurrentNick(@Nonnull String var1);

        public void setServerAddress(@Nonnull InetSocketAddress var1);

        public void initialize(@Nonnull String var1, @Nonnull InetSocketAddress var2, @Nullable String var3, @Nullable InetSocketAddress var4, @Nonnull String var5, @Nonnull String var6, @Nonnull String var7, @Nonnull ActorTracker var8, @Nonnull AuthManager var9, @Nonnull CapabilityManager.WithManagement var10, @Nonnull EventManager var11, @Nonnull MessageTagManager var12, @Nonnull ISupportManager var13, @Nullable DefaultMessageMap var14, @Nonnull Function<WithManagement, ? extends MessageSendingQueue> var15, @Nonnull Function<WithManagement, ? extends ServerInfo.WithManagement> var16, @Nullable Consumer<Exception> var17, @Nullable Consumer<String> var18, @Nullable Consumer<String> var19, boolean var20, @Nullable Path var21, @Nullable Path var22, @Nullable String var23, @Nullable TrustManagerFactory var24, @Nullable StsStorageManager var25, @Nullable String var26, @Nullable InetAddress var27, @Nullable String var28, @Nullable String var29);

        public void setUserModes(@Nonnull ModeStatusList<UserMode> var1);

        public void startSending();

        public void updateUserModes(@Nonnull ModeStatusList<UserMode> var1);

        public boolean isSecureConnection();
    }

    public static interface Commands {
        @Nonnull
        public AwayCommand away();

        @Nonnull
        public CapabilityRequestCommand capabilityRequest();

        @Nonnull
        public ChannelModeCommand mode(@Nonnull Channel var1);

        @Nonnull
        public KickCommand kick(@Nonnull Channel var1);

        @Nonnull
        public MonitorCommand monitor();

        @Nonnull
        public OperCommand oper();

        @Nonnull
        public TopicCommand topic(@Nonnull Channel var1);

        @Nonnull
        public WallopsCommand wallops();

        @Nonnull
        public WhoisCommand whois();
    }

    public static interface Builder {
        @Nonnull
        public Builder actorTracker(@Nonnull Function<WithManagement, ? extends ActorTracker> var1);

        @Nonnull
        public Builder authManager(@Nonnull Function<WithManagement, ? extends AuthManager> var1);

        @Nonnull
        public Builder bindHost(@Nullable String var1);

        @Nonnull
        public Builder bindPort(int var1);

        @Nonnull
        public Builder capabilityManager(@Nonnull Function<WithManagement, ? extends CapabilityManager.WithManagement> var1);

        @Nonnull
        public Builder defaultMessageMap(@Nonnull DefaultMessageMap var1);

        @Nonnull
        public Builder eventManager(@Nonnull Function<WithManagement, ? extends EventManager> var1);

        @Nonnull
        public Builder exceptionListener(@Nullable Consumer<Exception> var1);

        @Nonnull
        public Builder inputListener(@Nullable Consumer<String> var1);

        @Nonnull
        public Builder iSupportManager(@Nonnull Function<WithManagement, ? extends ISupportManager> var1);

        @Nonnull
        public Builder messageSendingQueueSupplier(@Nonnull Function<WithManagement, ? extends MessageSendingQueue> var1);

        @Nonnull
        public Builder messageTagManager(@Nonnull Function<WithManagement, ? extends MessageTagManager> var1);

        @Nonnull
        public Builder name(@Nonnull String var1);

        @Nonnull
        public Builder nick(@Nonnull String var1);

        @Nonnull
        public Builder outputListener(@Nullable Consumer<String> var1);

        @Nonnull
        public Builder realName(@Nonnull String var1);

        @Nonnull
        public Builder serverPassword(@Nullable String var1);

        @Nonnull
        public Builder secure(boolean var1);

        @Nonnull
        public Builder secureKeyCertChain(@Nullable Path var1);

        @Nonnull
        public Builder secureKey(@Nullable Path var1);

        @Nonnull
        public Builder secureKeyPassword(@Nullable String var1);

        @Nonnull
        public Builder secureTrustManagerFactory(@Nullable TrustManagerFactory var1);

        @Nonnull
        public Builder serverHost(@Nonnull String var1);

        @Nonnull
        public Builder serverPort(int var1);

        @Nonnull
        public Builder serverInfo(@Nonnull Function<WithManagement, ? extends ServerInfo.WithManagement> var1);

        @Nonnull
        public Builder user(@Nonnull String var1);

        @Nonnull
        public Builder webirc(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3, @Nonnull InetAddress var4);

        @Nonnull
        public Builder webircRemove();

        @Nonnull
        public Builder stsStorageManager(@Nullable StsStorageManager var1);

        @Nonnull
        public Client build();

        @Nonnull
        public Client buildAndConnect();
    }
}

