/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import soot.util.FluidModifier;
import soot.util.FluidUtil;

public class CaskManager {
    public static ArrayList<CaskLiquid> liquids = new ArrayList();

    @Nullable
    public static CaskLiquid getFromFluid(FluidStack fluidStack) {
        if (fluidStack != null) {
            return CaskManager.getFromFluid(fluidStack.getFluid());
        }
        return null;
    }

    @Nullable
    public static CaskLiquid getFromFluid(Fluid fluid) {
        for (CaskLiquid liquid : liquids) {
            if (!liquid.fluid.equals(fluid)) continue;
            return liquid;
        }
        return null;
    }

    public static void register(CaskLiquid liquid) {
        liquids.add(liquid);
    }

    public static class CaskLiquid {
        public Fluid fluid;
        public int model;
        public int color;
        public ArrayList<CaskPotionEffect> effects = new ArrayList();

        public CaskLiquid(Fluid fluid, int model, int color) {
            this.fluid = fluid;
            this.model = model;
            this.color = color;
        }

        public CaskLiquid addEffect(PotionEffect effect, int maxstack) {
            this.effects.add(new CaskPotionEffect(effect, maxstack));
            return this;
        }

        public List<PotionEffect> getEffects() {
            return this.effects.stream().map(x -> x.potionEffect).collect(Collectors.toCollection(ArrayList::new));
        }

        public void applyEffects(EntityLivingBase target, EntityLivingBase source, EntityLivingBase indirectsource, FluidStack fluid) {
            Fluid internal = fluid != null ? fluid.getFluid() : null;
            NBTTagCompound compound = FluidUtil.getModifiers(fluid);
            for (String key : compound.func_150296_c()) {
                FluidModifier modifier = FluidUtil.MODIFIERS.get(key);
                if (modifier == null) continue;
                modifier.applyEffect(target, compound, internal);
            }
            float duration_modifier = FluidUtil.getModifier(compound, internal, "duration");
            boolean concentrated = FluidUtil.getModifier(compound, internal, "concentration") >= 100.0f;
            boolean showParticles = FluidUtil.getModifier(compound, internal, "concentration") >= 50.0f;
            for (CaskPotionEffect effect : this.effects) {
                int concentration_bonus;
                PotionEffect potioneffect = effect.potionEffect;
                PotionEffect currentStack = target.func_70660_b(potioneffect.func_188419_a());
                int n = concentration_bonus = concentrated ? 1 : 0;
                if (potioneffect.func_188419_a().func_76403_b()) {
                    potioneffect.func_188419_a().func_180793_a((Entity)source, (Entity)indirectsource, target, potioneffect.func_76458_c() + concentration_bonus, 1.0);
                    continue;
                }
                int amplifier = potioneffect.func_76458_c();
                int duration = (int)((float)potioneffect.func_76459_b() * duration_modifier);
                if (currentStack != null && (amplifier = Math.min(amplifier + currentStack.func_76458_c() + 1, effect.maxStack + concentration_bonus)) != currentStack.func_76458_c()) {
                    duration += currentStack.func_76459_b();
                }
                PotionEffect newStack = new PotionEffect(potioneffect.func_188419_a(), duration, amplifier, false, showParticles);
                target.func_70690_d(newStack);
            }
        }
    }

    public static class CaskPotionEffect {
        public PotionEffect potionEffect;
        public int maxStack;

        public CaskPotionEffect(PotionEffect effect, int maxStack) {
            this.potionEffect = effect;
            this.maxStack = maxStack;
        }
    }
}

