/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import soot.util.MiscUtil;

public class Attributes {
    public static final IAttribute PHYSICAL_DAMAGE_RATE = new RangedAttribute(null, "generic.physicalDamageRate", 1.0, 0.0, 2048.0);
    public static final IAttribute FIRE_DAMAGE_RATE = new RangedAttribute(null, "generic.fireDamageRate", 1.0, 0.0, 2048.0);
    public static final IAttribute FIRE_ASPECT = new RangedAttribute(null, "generic.fireAspect", 0.0, 0.0, 72000.0);
    public static final IAttribute BAREHANDED_POWER = new RangedAttribute(null, "generic.barehandedPower", 1.0, 0.0, 2048.0);

    @SubscribeEvent
    public static void onEntityConstructEvent(EntityEvent.EntityConstructing event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_110140_aT().func_111150_b(PHYSICAL_DAMAGE_RATE);
            ((EntityLivingBase)entity).func_110140_aT().func_111150_b(FIRE_DAMAGE_RATE);
            ((EntityLivingBase)entity).func_110140_aT().func_111150_b(FIRE_ASPECT);
            ((EntityLivingBase)entity).func_110140_aT().func_111150_b(BAREHANDED_POWER);
        }
    }

    @SubscribeEvent
    public static void onStrikeEvent(LivingHurtEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        DamageSource damageSource = event.getSource();
        float damage = event.getAmount();
        EntityLivingBase attacker = null;
        if (damageSource.func_76364_f() instanceof EntityLivingBase) {
            attacker = (EntityLivingBase)damageSource.func_76364_f();
        } else if (damageSource.func_76346_g() instanceof EntityLivingBase) {
            attacker = (EntityLivingBase)damageSource.func_76346_g();
        }
        if (entity != null && attacker != null) {
            int fire_aspect = (int)entity.func_110148_a(FIRE_ASPECT).func_111126_e();
            if (MiscUtil.isBarehandedDamage(damageSource, attacker)) {
                damage = (float)((double)damage * entity.func_110148_a(BAREHANDED_POWER).func_111126_e());
            }
            if (fire_aspect > 0) {
                entity.func_70015_d(fire_aspect);
            }
        }
        event.setAmount(damage);
    }

    @SubscribeEvent
    public static void onHurtEvent(LivingHurtEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        DamageSource damageSource = event.getSource();
        float damage = event.getAmount();
        if (entity != null) {
            IAttributeInstance damageRate = null;
            if (MiscUtil.isPhysicalDamage(damageSource)) {
                damageRate = entity.func_110148_a(PHYSICAL_DAMAGE_RATE);
            }
            if (damageSource.func_76347_k()) {
                damageRate = entity.func_110148_a(FIRE_DAMAGE_RATE);
            }
            if (damageRate != null) {
                damage = (float)((double)damage * damageRate.func_111126_e());
            }
        }
        event.setAmount(damage);
    }
}

