/*
 * Decompiled with CFR 0.152.
 */
package soot.upgrade;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import soot.SoundEvents;
import soot.network.PacketHandler;
import soot.network.message.MessageMixerFailFX;
import soot.recipe.CraftingRegistry;
import soot.recipe.RecipeAlchemicalMixer;
import soot.tile.TileEntityAlchemyGlobe;
import teamroots.embers.api.alchemy.AlchemyResult;
import teamroots.embers.api.upgrades.IUpgradeProvider;
import teamroots.embers.api.upgrades.UpgradeUtil;
import teamroots.embers.recipe.FluidMixingRecipe;
import teamroots.embers.tileentity.TileEntityMixerBottom;
import teamroots.embers.tileentity.TileEntityMixerTop;
import teamroots.embers.util.DefaultUpgradeProvider;

public class UpgradeAlchemyGlobe
extends DefaultUpgradeProvider {
    int failure = 0;

    public UpgradeAlchemyGlobe(TileEntity tile) {
        super("alchemy_globe", tile);
    }

    public int getLimit(TileEntity tile) {
        return 1;
    }

    public boolean doWork(TileEntity tile, List<IUpgradeProvider> upgrades) {
        if (this.failure > 0) {
            --this.failure;
        }
        if (tile instanceof TileEntityMixerBottom && this.failure <= 0) {
            this.doAlchemicMixing((TileEntityMixerBottom)tile, upgrades);
            return true;
        }
        return false;
    }

    public void doAlchemicMixing(TileEntityMixerBottom bottom, List<IUpgradeProvider> upgrades) {
        if (!(this.tile instanceof TileEntityAlchemyGlobe)) {
            return;
        }
        TileEntityAlchemyGlobe globe = (TileEntityAlchemyGlobe)this.tile;
        World world = bottom.func_145831_w();
        TileEntityMixerTop top = (TileEntityMixerTop)world.func_175625_s(bottom.func_174877_v().func_177984_a());
        if (top != null) {
            ArrayList fluids;
            RecipeAlchemicalMixer recipe;
            double emberCost = UpgradeUtil.getTotalEmberConsumption((TileEntity)bottom, (double)2.0, upgrades);
            if (top.capability.getEmber() >= emberCost && (recipe = CraftingRegistry.getAlchemicalMixingRecipe(fluids = bottom.getFluids())) != null && !world.field_72995_K) {
                AlchemyResult result = recipe.matchAshes(globe.getAspects(), world);
                if (result.getAccuracy() == 1.0) {
                    FluidStack output;
                    IFluidHandler tank = (IFluidHandler)top.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                    int amount = tank.fill(output = UpgradeUtil.transformOutput((TileEntity)bottom, (FluidStack)recipe.output, upgrades), false);
                    if (amount != 0) {
                        tank.fill(output, true);
                        bottom.consumeFluids((FluidMixingRecipe)recipe);
                        top.capability.removeAmount(emberCost, true);
                        bottom.func_70296_d();
                        top.func_70296_d();
                    }
                } else if (result.areAllPresent()) {
                    ItemStack failure = result.createFailure();
                    BlockPos topPos = top.func_174877_v();
                    this.ejectFailure(world, topPos, failure, EnumFacing.field_176754_o);
                    bottom.consumeFluids((FluidMixingRecipe)recipe);
                    top.capability.removeAmount(emberCost * 200.0, true);
                    this.fail(world.field_73012_v.nextInt(100) + 200);
                    globe.consumeAsh();
                }
            }
        }
    }

    private void fail(int time) {
        this.failure = time;
    }

    @Nullable
    public void ejectFailure(World world, BlockPos pos, ItemStack failure, EnumFacing[] directions) {
        int ioff = 0;
        for (int i = 0; i < directions.length; ++i) {
            EnumFacing direction = directions[(i + ioff) % directions.length];
            BlockPos ejectPos = pos.func_177972_a(direction);
            IBlockState state = world.func_180495_p(ejectPos);
            if (state.func_193401_d((IBlockAccess)world, ejectPos, direction.func_176734_d()) != BlockFaceShape.UNDEFINED) continue;
            this.ejectFailure(world, pos, failure, direction);
            return;
        }
        this.ejectFailure(world, pos, failure, EnumFacing.UP);
    }

    public void ejectFailure(World world, BlockPos pos, ItemStack failure, EnumFacing direction) {
        float xEject = direction.func_82601_c();
        float zEject = direction.func_82599_e();
        float xOff = world.field_73012_v.nextFloat() * 0.05f + 0.475f + xEject * 0.7f;
        float yOff = 0.5f;
        float zOff = world.field_73012_v.nextFloat() * 0.05f + 0.475f + zEject * 0.7f;
        world.func_184148_a(null, (double)((float)pos.func_177958_n() + xOff), (double)((float)pos.func_177956_o() + yOff), (double)((float)pos.func_177952_p() + zOff), SoundEvents.ALCHEMICAL_MIXER_WASTE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageMixerFailFX((float)pos.func_177958_n() + xOff, (float)pos.func_177956_o() + yOff, (float)pos.func_177952_p() + zOff, direction));
        EntityItem item = new EntityItem(world, (double)((float)pos.func_177958_n() + xOff), (double)((float)pos.func_177956_o() + yOff - 0.4f), (double)((float)pos.func_177952_p() + zOff), failure);
        item.field_70159_w = xEject * 0.1f;
        item.field_70181_x = 0.0;
        item.field_70179_y = zEject * 0.1f;
        item.func_174869_p();
        world.func_72838_d((Entity)item);
    }
}

