/*
 * Decompiled with CFR 0.152.
 */
package soot.tile;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import soot.block.BlockEmberBurst;
import teamroots.embers.SoundManager;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.power.IEmberPacketProducer;
import teamroots.embers.api.power.IEmberPacketReceiver;
import teamroots.embers.block.BlockEmberEmitter;
import teamroots.embers.entity.EntityEmberPacket;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEntityEmberBurst
extends TileEntity
implements ITileEntityBase,
ITickable,
IEmberPacketProducer {
    public static final double TRANSFER_RATE = 80.0;
    public static final double PULL_RATE = 100.0;
    public IEmberCapability capability = new DefaultEmberCapability();
    public BlockPos[] targets = new BlockPos[6];
    int targetIndex = 0;
    public long ticksExisted = 0L;
    Random random = new Random();
    int offset = this.random.nextInt(40);
    public EnumConnection up = EnumConnection.NONE;
    public EnumConnection down = EnumConnection.NONE;
    public EnumConnection north = EnumConnection.NONE;
    public EnumConnection south = EnumConnection.NONE;
    public EnumConnection east = EnumConnection.NONE;
    public EnumConnection west = EnumConnection.NONE;

    public static EnumConnection connectionFromInt(int value) {
        switch (value) {
            case 0: {
                return EnumConnection.NONE;
            }
            case 1: {
                return EnumConnection.LEVER;
            }
        }
        return EnumConnection.NONE;
    }

    public TileEntityEmberBurst() {
        this.capability.setEmberCapacity(200.0);
    }

    public void updateNeighbors(IBlockAccess world) {
        this.up = this.getConnection(world, this.func_174877_v().func_177984_a(), EnumFacing.DOWN);
        this.down = this.getConnection(world, this.func_174877_v().func_177977_b(), EnumFacing.UP);
        this.north = this.getConnection(world, this.func_174877_v().func_177978_c(), EnumFacing.NORTH);
        this.south = this.getConnection(world, this.func_174877_v().func_177968_d(), EnumFacing.SOUTH);
        this.west = this.getConnection(world, this.func_174877_v().func_177976_e(), EnumFacing.WEST);
        this.east = this.getConnection(world, this.func_174877_v().func_177974_f(), EnumFacing.EAST);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("up", this.up.ordinal());
        tag.func_74768_a("down", this.down.ordinal());
        tag.func_74768_a("north", this.north.ordinal());
        tag.func_74768_a("south", this.south.ordinal());
        tag.func_74768_a("west", this.west.ordinal());
        tag.func_74768_a("east", this.east.ordinal());
        for (int i = 0; i < 6; ++i) {
            EnumFacing facing = EnumFacing.func_82600_a((int)i);
            String key = "target" + facing.func_176610_l();
            BlockPos target = this.targets[i];
            if (target == null) continue;
            NBTTagCompound targetCompound = new NBTTagCompound();
            targetCompound.func_74768_a("x", target.func_177958_n());
            targetCompound.func_74768_a("y", target.func_177956_o());
            targetCompound.func_74768_a("z", target.func_177952_p());
            tag.func_74782_a(key, (NBTBase)targetCompound);
        }
        this.capability.writeToNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.up = TileEntityEmberBurst.connectionFromInt(tag.func_74762_e("up"));
        this.down = TileEntityEmberBurst.connectionFromInt(tag.func_74762_e("down"));
        this.north = TileEntityEmberBurst.connectionFromInt(tag.func_74762_e("north"));
        this.south = TileEntityEmberBurst.connectionFromInt(tag.func_74762_e("south"));
        this.west = TileEntityEmberBurst.connectionFromInt(tag.func_74762_e("west"));
        this.east = TileEntityEmberBurst.connectionFromInt(tag.func_74762_e("east"));
        for (int i = 0; i < 6; ++i) {
            BlockPos target;
            EnumFacing facing = EnumFacing.func_82600_a((int)i);
            String key = "target" + facing.func_176610_l();
            if (!tag.func_74764_b(key)) continue;
            NBTTagCompound targetCompound = tag.func_74775_l(key);
            this.targets[i] = target = new BlockPos(targetCompound.func_74762_e("x"), targetCompound.func_74762_e("y"), targetCompound.func_74762_e("z"));
        }
        this.capability.readFromNBT(tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public EnumConnection getConnection(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return Misc.isValidLever((IBlockAccess)world, (BlockPos)pos, (EnumFacing)side) ? EnumConnection.LEVER : EnumConnection.NONE;
    }

    public void func_70296_d() {
        super.func_70296_d();
        Misc.syncTE((TileEntity)this);
    }

    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        EnumFacing targetFacing;
        IEmberCapability cap;
        ++this.ticksExisted;
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockEmberBurst.facing);
        TileEntity attachedTile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing.func_176734_d()));
        if (this.ticksExisted % 5L == 0L && attachedTile != null && attachedTile.hasCapability(EmbersCapabilities.EMBER_CAPABILITY, null) && (cap = (IEmberCapability)attachedTile.getCapability(EmbersCapabilities.EMBER_CAPABILITY, null)).getEmber() > 0.0 && this.capability.getEmber() < this.capability.getEmberCapacity()) {
            double removed = cap.removeAmount(100.0, true);
            this.capability.addAmount(removed, true);
            this.func_70296_d();
            attachedTile.func_70296_d();
        }
        if ((targetFacing = EnumFacing.func_82600_a((int)this.targetIndex)) == facing.func_176734_d()) {
            this.nextTarget();
        }
        if (!this.field_145850_b.field_72995_K && (this.ticksExisted + (long)this.offset) % 4L == 0L && this.field_145850_b.func_175687_A(this.field_174879_c) != 0 && this.capability.getEmber() > 10.0) {
            TileEntity targetTile;
            BlockPos target = this.targets[this.targetIndex];
            this.nextTarget();
            if (target != null && (targetTile = this.field_145850_b.func_175625_s(target)) instanceof IEmberPacketReceiver && !((IEmberPacketReceiver)targetTile).isFull()) {
                EntityEmberPacket packet = new EntityEmberPacket(this.field_145850_b);
                Vec3d velocity = this.getBurstVelocity(targetFacing);
                packet.initCustom(this.field_174879_c, target, velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c, Math.min(80.0, this.capability.getEmber()));
                packet.func_70107_b((double)((float)this.field_174879_c.func_177958_n() + 0.5f + (float)facing.func_82601_c() * 0.4f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f + (float)facing.func_96559_d() * 0.4f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f + (float)facing.func_82599_e() * 0.4f));
                this.capability.removeAmount(Math.min(80.0, this.capability.getEmber()), true);
                this.func_145831_w().func_72838_d((Entity)packet);
                this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundManager.EMBER_EMIT, SoundCategory.BLOCKS, 1.0f, this.random.nextFloat() + 0.5f);
                this.func_70296_d();
            }
        }
    }

    private Vec3d getBurstVelocity(EnumFacing facing) {
        switch (facing) {
            case DOWN: {
                return new Vec3d(0.0, -0.5, 0.0);
            }
            case UP: {
                return new Vec3d(0.0, 0.5, 0.0);
            }
            case NORTH: {
                return new Vec3d(0.0, -0.01, -0.5);
            }
            case SOUTH: {
                return new Vec3d(0.0, -0.01, 0.5);
            }
            case WEST: {
                return new Vec3d(-0.5, -0.01, 0.0);
            }
            case EAST: {
                return new Vec3d(0.5, -0.01, 0.0);
            }
        }
        return Vec3d.field_186680_a;
    }

    private void nextTarget() {
        this.targetIndex = (this.targetIndex + 1) % this.targets.length;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmbersCapabilities.EMBER_CAPABILITY) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void setTargetPosition(BlockPos targetpos, EnumFacing side) {
        EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockEmberEmitter.facing);
        if (side != facing.func_176734_d()) {
            this.targets[side.func_176745_a()] = targetpos;
            this.func_70296_d();
        }
    }

    public static enum EnumConnection {
        NONE,
        LEVER;

    }
}

