/*
 * Decompiled with CFR 0.152.
 */
package soot.tile;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import soot.block.BlockAlchemyGlobe;
import soot.upgrade.UpgradeAlchemyGlobe;
import teamroots.embers.api.alchemy.AspectList;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.tileentity.TileEntityAlchemyPedestal;
import teamroots.embers.util.AlchemyUtil;

public class TileEntityAlchemyGlobe
extends TileEntity
implements ITickable {
    public static final int UPDATE_INTERVAL = 20;
    AspectList aspectList = new AspectList();
    int lifeTime;
    int nextCheck;
    UpgradeAlchemyGlobe upgrade = new UpgradeAlchemyGlobe(this);

    public AspectList getAspects() {
        return this.aspectList;
    }

    public void consumeAsh() {
        List pedestals = AlchemyUtil.getNearbyPedestals((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
        for (TileEntityAlchemyPedestal pedestal : pedestals) {
            pedestal.inventory.setStackInSlot(0, ItemStack.field_190927_a);
        }
    }

    public EnumFacing getFacing() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockAlchemyGlobe) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockAlchemyGlobe.FACING);
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY && this.getFacing().func_176734_d() == facing || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY && this.getFacing().func_176734_d() == facing ? this.upgrade : super.getCapability(capability, facing));
    }

    public void func_73660_a() {
        ++this.lifeTime;
        if (this.lifeTime > this.nextCheck) {
            this.nextCheck = this.lifeTime + 20;
            List pedestals = AlchemyUtil.getNearbyPedestals((World)this.func_145831_w(), (BlockPos)this.func_174877_v());
            this.aspectList.reset();
            this.aspectList.collect(pedestals);
        }
        if (this.field_145850_b.field_72995_K) {
            int i;
            Random random = this.field_145850_b.field_73012_v;
            for (i = 0; i < 3; ++i) {
                ParticleUtil.spawnParticleTyrfing((World)this.field_145850_b, (float)((float)this.field_174879_c.func_177958_n() + 0.5f), (float)((float)this.field_174879_c.func_177956_o() + 0.5f), (float)((float)this.field_174879_c.func_177952_p() + 0.5f), (float)((random.nextFloat() - 0.5f) * 0.01f), (float)((random.nextFloat() - 0.5f) * 0.007f), (float)((random.nextFloat() - 0.5f) * 0.01f), (float)2.5f, (int)20);
            }
            for (i = 0; i < 5; ++i) {
                float velocityFactor = random.nextFloat() * 1.0f + 0.5f;
                double yaw = (double)random.nextFloat() * Math.PI * 2.0;
                double pitch = (double)random.nextFloat() * Math.PI * 2.0;
                float dist = 0.4f;
                Vec3d vector = new Vec3d(Math.sin(yaw) * Math.cos(pitch), Math.sin(pitch), Math.cos(yaw) * Math.cos(pitch)).func_72432_b();
                ParticleUtil.spawnParticleGlow((World)this.field_145850_b, (float)((float)this.field_174879_c.func_177958_n() + 0.5f + (float)vector.field_72450_a * dist), (float)((float)this.field_174879_c.func_177956_o() + 0.5f + (float)vector.field_72448_b * dist), (float)((float)this.field_174879_c.func_177952_p() + 0.5f + (float)vector.field_72449_c * dist), (float)((float)vector.field_72450_a * -0.01f * velocityFactor), (float)((float)vector.field_72448_b * -0.01f * velocityFactor), (float)((float)vector.field_72449_c * -0.01f * velocityFactor), (float)64.0f, (float)32.0f, (float)90.0f, (float)(1.5f / velocityFactor * 0.5f), (int)((int)(50.0f / velocityFactor)));
            }
        }
    }
}

