/*
 * Decompiled with CFR 0.152.
 */
package soot.recipe;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import soot.tile.TileEntityStillBase;

public class RecipeStill {
    public FluidStack input;
    public Ingredient catalystInput;
    public int catalystConsumed;
    public FluidStack output;
    boolean exactMatch = false;

    public RecipeStill(FluidStack input, Ingredient catalystInput, int catalystConsumed, FluidStack output) {
        this.input = input;
        this.catalystInput = catalystInput;
        this.output = output;
        this.catalystConsumed = catalystConsumed;
    }

    public RecipeStill setExact() {
        this.exactMatch = true;
        return this;
    }

    public List<FluidStack> getInputs() {
        return Lists.newArrayList((Object[])new FluidStack[]{this.input});
    }

    public List<FluidStack> getOutputs() {
        return Lists.newArrayList((Object[])new FluidStack[]{this.output});
    }

    public void modifyTooltip(List<String> tooltip) {
    }

    public int getInputConsumed() {
        return this.input != null ? this.input.amount : 0;
    }

    public boolean matches(TileEntityStillBase tile, FluidStack stack, ItemStack catalyst) {
        return this.catalystInput.apply(catalyst) && (this.input == null || stack != null && (this.exactMatch ? this.input.isFluidEqual(stack) : this.input.getFluid() == stack.getFluid()) && stack.amount >= this.getInputConsumed());
    }

    public FluidStack getOutput(TileEntityStillBase tile, FluidStack input) {
        return this.output.copy();
    }
}

