/*
 * Decompiled with CFR 0.152.
 */
package soot.potion;

import java.awt.Color;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import soot.Soot;
import soot.network.PacketHandler;
import soot.network.message.MessageWitchBurnFX;
import soot.potion.PotionBase;
import teamroots.embers.particle.ParticleUtil;

public class PotionWitchBurn
extends PotionBase {
    public static DamageSource damageSource = new DamageSource("witchBurn");
    public static WeakHashMap<EntityLivingBase, Boolean> appliedEntities = new WeakHashMap();

    public PotionWitchBurn() {
        super(true, new Color(64, 255, 16).getRGB());
        this.func_76390_b("effect.witchburn");
        this.func_76399_b(2, 1);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return duration % 20 == 0;
    }

    public void func_76394_a(EntityLivingBase entity, int amplifier) {
        entity.func_70097_a(damageSource, 2.0f);
    }

    public boolean shouldRender(PotionEffect effect) {
        return false;
    }

    public boolean shouldRenderHUD(PotionEffect effect) {
        return false;
    }

    public boolean shouldRenderInvText(PotionEffect effect) {
        return false;
    }

    @SubscribeEvent
    public void onTick(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        boolean wasApplied = appliedEntities.getOrDefault(entity, false);
        boolean isApplied = entity.func_70644_a((Potion)this);
        if (wasApplied && entity.field_70170_p.field_72995_K) {
            Random rand = entity.func_70681_au();
            for (int i = 0; i < 10; ++i) {
                ParticleUtil.spawnParticleVapor((World)entity.field_70170_p, (float)((float)entity.field_70165_t + (rand.nextFloat() - 0.5f) * entity.field_70130_N), (float)((float)entity.field_70163_u + rand.nextFloat() * entity.field_70131_O), (float)((float)entity.field_70161_v + (rand.nextFloat() - 0.5f) * entity.field_70130_N), (float)((rand.nextFloat() - 0.5f) * 0.02f), (float)(rand.nextFloat() * 0.04f), (float)((rand.nextFloat() - 0.5f) * 0.02f), (float)64.0f, (float)255.0f, (float)16.0f, (float)1.0f, (float)2.0f, (float)4.0f, (int)(10 + rand.nextInt(20)));
            }
        }
        if (isApplied != wasApplied && !entity.field_70170_p.field_72995_K) {
            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageWitchBurnFX(entity));
            appliedEntities.put(entity, isApplied);
        }
    }

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        World world = event.getWorld();
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            for (EntityLivingBase key : appliedEntities.keySet()) {
                if (key.field_70170_p != world || !appliedEntities.get(key).booleanValue()) continue;
                PacketHandler.INSTANCE.sendTo((IMessage)new MessageWitchBurnFX(key), (EntityPlayerMP)entity);
            }
        }
    }

    @SubscribeEvent
    public void onLeaveWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity == Soot.proxy.getMainPlayer()) {
            appliedEntities.clear();
        }
    }

    @SubscribeEvent
    public void onHeal(LivingHealEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        PotionEffect effect = entity.func_70660_b((Potion)this);
        if (effect != null) {
            event.setAmount(0.0f);
        }
    }
}

