/*
 * Decompiled with CFR 0.152.
 */
package soot.itemmod;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import soot.Registry;
import teamroots.embers.api.event.EmberProjectileEvent;
import teamroots.embers.api.itemmod.ItemModUtil;
import teamroots.embers.api.itemmod.ModifierBase;
import teamroots.embers.api.projectile.EffectArea;
import teamroots.embers.api.projectile.EffectDamage;
import teamroots.embers.api.projectile.EffectMulti;
import teamroots.embers.api.projectile.EffectPotion;
import teamroots.embers.api.projectile.IProjectileEffect;
import teamroots.embers.api.projectile.IProjectilePreset;
import teamroots.embers.itemmod.ModifierProjectileBase;

public class ModifierWitchburn
extends ModifierProjectileBase {
    public ModifierWitchburn() {
        super("witchburn", 8.0, true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onProjectileFire(EmberProjectileEvent event) {
        int level;
        ListIterator projectiles = event.getProjectiles().listIterator();
        ItemStack weapon = event.getStack();
        if (!weapon.func_190926_b() && ItemModUtil.hasHeat((ItemStack)weapon) && (level = ItemModUtil.getModifierLevel((ItemStack)weapon, (ModifierBase)Registry.WITCHBURN)) > 0) {
            while (projectiles.hasNext()) {
                IProjectilePreset projectile = (IProjectilePreset)projectiles.next();
                projectile.setColor(new Color(64, 255, 16));
                projectile.setEffect(this.adjustEffect(projectile.getEffect()));
            }
        }
    }

    private IProjectileEffect adjustEffect(IProjectileEffect effect) {
        if (effect instanceof EffectArea) {
            EffectArea areaEffect = (EffectArea)effect;
            areaEffect.setEffect(this.adjustEffect(areaEffect.getEffect()));
            return areaEffect;
        }
        if (effect instanceof EffectMulti) {
            ((EffectMulti)effect).addEffect((IProjectileEffect)new EffectPotion(new PotionEffect(Registry.POTION_WITCHBURN, 200, 0, false, false)));
            return effect;
        }
        if (effect instanceof EffectDamage) {
            ((EffectDamage)effect).setFire(0);
        }
        EffectMulti multiEffect = new EffectMulti((List)Lists.newArrayList((Object[])new IProjectileEffect[]{effect}));
        return this.adjustEffect((IProjectileEffect)multiEffect);
    }
}

