/*
 * Decompiled with CFR 0.152.
 */
package soot.handler;

import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import soot.Config;
import teamroots.embers.RegistryManager;

public class GolemHandler {
    static Object2BooleanOpenHashMap<Class> golemClassCache = new Object2BooleanOpenHashMap();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityDamaged(LivingHurtEvent event) {
        EntityLivingBase attacker;
        EntityLivingBase target = event.getEntityLiving();
        float damage = event.getAmount();
        DamageSource source = event.getSource();
        if (Config.GOLEMS_TYRFING_WEAK && source.func_76364_f() instanceof EntityLivingBase && (attacker = (EntityLivingBase)source.func_76364_f()).func_184614_ca().func_77973_b() == RegistryManager.tyrfing && GolemHandler.isGolem(target)) {
            event.setAmount(damage * 2.5f + 1.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityTick(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase target = event.getEntityLiving();
        if (Config.GOLEMS_POISON_IMMUNE && GolemHandler.isGolem(target) && target.func_70644_a(MobEffects.field_76436_u)) {
            target.func_184589_d(MobEffects.field_76436_u);
        }
    }

    private static boolean isGolem(EntityLivingBase target) {
        Class<?> targetClass = target.getClass();
        if (golemClassCache.containsKey(targetClass)) {
            return golemClassCache.getBoolean(targetClass);
        }
        ResourceLocation location = EntityList.func_191301_a((Entity)target);
        boolean isGolem = location != null && location.func_110623_a().toLowerCase().contains("golem");
        golemClassCache.put(targetClass, isGolem);
        return isGolem;
    }
}

