/*
 * Decompiled with CFR 0.152.
 */
package soot.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import soot.Registry;
import soot.Soot;
import teamroots.embers.particle.ParticleUtil;

public class EntityMuse
extends EntityMob {
    protected static final DataParameter<Byte> MUSE_FLAGS = EntityDataManager.func_187226_a(EntityMuse.class, (DataSerializer)DataSerializers.field_187191_a);
    private EntityPlayer boundPlayer;
    private boolean limitedLifespan;
    private int limitedLifeTicks;

    public EntityMuse(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
        this.field_70765_h = new AIMoveControl(this);
        this.func_70105_a(1.0f, 2.0f);
        this.field_70728_aV = 3;
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
        this.func_145775_I();
    }

    public boolean func_70652_k(Entity target) {
        if (!(target instanceof EntityLivingBase) || !this.isVisibleTo((EntityLivingBase)target)) {
            return false;
        }
        boolean flag = super.func_70652_k(target);
        if (flag && target instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)target;
            player.func_82242_a(-1);
        }
        return flag;
    }

    public void func_70071_h_() {
        EntityPlayer mainPlayer;
        this.field_70145_X = true;
        super.func_70071_h_();
        this.field_70145_X = false;
        this.func_189654_d(true);
        if (this.field_70170_p.field_72995_K && (mainPlayer = Soot.proxy.getMainPlayer()) != null && this.isVisibleTo((EntityLivingBase)mainPlayer)) {
            ParticleUtil.spawnParticleGlow((World)this.field_70170_p, (float)((float)this.field_70165_t + (this.field_70146_Z.nextFloat() - 0.5f) * 0.4f), (float)((float)this.field_70163_u + 1.0f + (this.field_70146_Z.nextFloat() - 0.5f) * 0.4f), (float)((float)this.field_70161_v + (this.field_70146_Z.nextFloat() - 0.5f) * 0.4f), (float)((this.field_70146_Z.nextFloat() - 0.5f) * 0.1f), (float)(this.field_70146_Z.nextFloat() * 0.1f), (float)((this.field_70146_Z.nextFloat() - 0.5f) * 0.1f), (float)64.0f, (float)255.0f, (float)64.0f, (float)16.0f, (float)10.0f, (int)50);
        }
        if (this.boundPlayer == null || !this.isVisibleTo((EntityLivingBase)this.boundPlayer) || this.limitedLifespan && --this.limitedLifeTicks <= 0) {
            this.limitedLifeTicks = 10;
            this.func_70097_a(DamageSource.field_76366_f, 100.0f);
        }
    }

    public boolean isVisibleTo(EntityLivingBase entity) {
        EntityPlayer player;
        if (entity instanceof EntityPlayer && ((player = (EntityPlayer)entity).func_175149_v() || player.func_184812_l_())) {
            return true;
        }
        return entity.func_70644_a(Registry.POTION_INSPIRATION);
    }

    public boolean func_70685_l(Entity entityIn) {
        return (!(entityIn instanceof EntityLivingBase) || this.isVisibleTo((EntityLivingBase)entityIn)) && super.func_70685_l(entityIn);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIChargeAttack());
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new AIMoveRandom());
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityMuse.class}));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MUSE_FLAGS, (Object)0);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("LifeTicks")) {
            this.setLimitedLife(compound.func_74762_e("LifeTicks"));
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.limitedLifespan) {
            compound.func_74768_a("LifeTicks", this.limitedLifeTicks);
        }
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundPlayer != null ? this.boundPlayer.func_180425_c() : null;
    }

    @Nullable
    public EntityPlayer getBoundPlayer() {
        return this.boundPlayer;
    }

    public void setBoundPlayer(EntityPlayer player) {
        this.boundPlayer = player;
    }

    private boolean getMuseFlag(int mask) {
        byte i = (Byte)this.field_70180_af.func_187225_a(MUSE_FLAGS);
        return (i & mask) != 0;
    }

    private void setMuseFlag(int mask, boolean value) {
        int i = ((Byte)this.field_70180_af.func_187225_a(MUSE_FLAGS)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.field_70180_af.func_187227_b(MUSE_FLAGS, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.getMuseFlag(1);
    }

    public void setCharging(boolean charging) {
        this.setMuseFlag(1, charging);
    }

    public void setLimitedLife(int limitedLifeTicksIn) {
        this.limitedLifespan = true;
        this.limitedLifeTicks = limitedLifeTicksIn;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191264_hc;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191266_he;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_191267_hf;
    }

    public boolean func_70687_e(PotionEffect potionEffect) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    class AIMoveRandom
    extends EntityAIBase {
        public AIMoveRandom() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return !EntityMuse.this.func_70605_aq().func_75640_a() && EntityMuse.this.field_70146_Z.nextInt(7) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = EntityMuse.this.getBoundOrigin();
            if (blockpos == null) {
                blockpos = new BlockPos((Entity)EntityMuse.this);
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityMuse.this.field_70146_Z.nextInt(15) - 7, EntityMuse.this.field_70146_Z.nextInt(11) - 5, EntityMuse.this.field_70146_Z.nextInt(15) - 7);
                if (!EntityMuse.this.field_70170_p.func_175623_d(blockpos1)) continue;
                EntityMuse.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 1.0);
                if (EntityMuse.this.func_70638_az() != null) break;
                EntityMuse.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityMuse vex) {
            super((EntityLiving)vex);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityMuse.this.field_70165_t;
                double d1 = this.field_75647_c - EntityMuse.this.field_70163_u;
                double d2 = this.field_75644_d - EntityMuse.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityMuse.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityMuse.this.field_70159_w *= 0.5;
                    EntityMuse.this.field_70181_x *= 0.5;
                    EntityMuse.this.field_70179_y *= 0.5;
                } else {
                    EntityMuse.this.field_70159_w += d0 / d3 * 0.05 * this.field_75645_e;
                    EntityMuse.this.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                    EntityMuse.this.field_70179_y += d2 / d3 * 0.05 * this.field_75645_e;
                    if (EntityMuse.this.func_70638_az() == null) {
                        EntityMuse.this.field_70761_aq = EntityMuse.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityMuse.this.field_70159_w, (double)EntityMuse.this.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = EntityMuse.this.func_70638_az().field_70165_t - EntityMuse.this.field_70165_t;
                        double d5 = EntityMuse.this.func_70638_az().field_70161_v - EntityMuse.this.field_70161_v;
                        EntityMuse.this.field_70761_aq = EntityMuse.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }

    class AIChargeAttack
    extends EntityAIBase {
        Vec3d target;

        public AIChargeAttack() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (EntityMuse.this.func_70638_az() != null && !EntityMuse.this.func_70605_aq().func_75640_a() && EntityMuse.this.field_70146_Z.nextInt(3) == 0) {
                return EntityMuse.this.func_70068_e((Entity)EntityMuse.this.func_70638_az()) > 3.0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return EntityMuse.this.func_70605_aq().func_75640_a() && EntityMuse.this.isCharging() && EntityMuse.this.func_70638_az() != null && EntityMuse.this.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            EntityLivingBase entitylivingbase = EntityMuse.this.func_70638_az();
            Vec3d start = EntityMuse.this.func_174791_d();
            Vec3d mid = entitylivingbase.func_174791_d();
            this.target = start.func_178787_e(mid.func_178788_d(start).func_186678_a(2.0));
            EntityMuse.this.field_70765_h.func_75642_a(this.target.field_72450_a, this.target.field_72448_b, this.target.field_72449_c, 1.0);
            EntityMuse.this.setCharging(true);
            EntityMuse.this.func_184185_a(SoundEvents.field_191265_hd, 1.0f, 1.0f);
        }

        public void func_75251_c() {
            EntityMuse.this.setCharging(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = EntityMuse.this.func_70638_az();
            if (EntityMuse.this.func_174813_aQ().func_72326_a(entitylivingbase.func_174813_aQ())) {
                EntityMuse.this.func_70652_k((Entity)entitylivingbase);
                EntityMuse.this.setCharging(false);
            } else {
                double d0 = EntityMuse.this.func_70068_e((Entity)entitylivingbase);
                if (d0 < 9.0) {
                    EntityMuse.this.field_70765_h.func_75642_a(this.target.field_72450_a, this.target.field_72448_b, this.target.field_72449_c, 1.0);
                }
            }
        }
    }
}

