/*
 * Decompiled with CFR 0.152.
 */
package soot.block;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import soot.tile.TileEntityStillBase;
import soot.tile.TileEntityStillTip;
import teamroots.embers.tileentity.ITileEntityBase;

public class BlockStill
extends Block {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyInteger PART = PropertyInteger.func_177719_a((String)"part", (int)0, (int)2);

    public BlockStill() {
        super(Material.field_151573_f);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, PART});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() | (Integer)state.func_177229_b((IProperty)PART) << 2;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)PART, (Comparable)Integer.valueOf(meta >> 2));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int part = (Integer)state.func_177229_b((IProperty)PART);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (part) {
            case 2: {
                switch (facing) {
                    case NORTH: {
                        return new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.875, 1.0);
                    }
                    case SOUTH: {
                        return new AxisAlignedBB(0.3125, 0.0, 0.0, 0.6875, 0.875, 0.6875);
                    }
                    case EAST: {
                        return new AxisAlignedBB(0.0, 0.0, 0.3125, 0.6875, 0.875, 0.6875);
                    }
                    case WEST: {
                        return new AxisAlignedBB(0.3125, 0.0, 0.3125, 1.0, 0.875, 0.6875);
                    }
                }
                return new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.875, 0.6875);
            }
            case 1: {
                return new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.875, 0.8125);
            }
        }
        return field_185505_j;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.updateConnections(state, worldIn, pos);
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    public void updateConnections(IBlockState state, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityStillTip) {
            TileEntityStillTip tip = (TileEntityStillTip)tile;
            tip.updateConnections();
        }
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, new ItemStack((Block)this, 1, 0)));
        }
        this.deleteParts(world, pos, true, null);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d && this.isIntact(world, pos)) {
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, new ItemStack((Block)this, 1, 0)));
        }
        this.deleteParts(world, pos, true, player);
    }

    private boolean isIntact(World world, BlockPos pos) {
        EnumFacing facing;
        IBlockState state = world.func_180495_p(pos);
        int part = (Integer)state.func_177229_b((IProperty)PART);
        BlockPos base = this.getBase(pos, part, facing = (EnumFacing)state.func_177229_b((IProperty)FACING));
        return world.func_180495_p(base).func_177230_c() == this && world.func_180495_p(base.func_177984_a()).func_177230_c() == this && world.func_180495_p(base.func_177984_a().func_177972_a(facing)).func_177230_c() == this;
    }

    private void deleteParts(World world, BlockPos pos, boolean notifyTile, EntityPlayer player) {
        IBlockState state = world.func_180495_p(pos);
        int part = (Integer)state.func_177229_b((IProperty)PART);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockPos base = this.getBase(pos, part, facing);
        this.deletePart(world, base, notifyTile, player);
        this.deletePart(world, base.func_177984_a(), notifyTile, player);
        this.deletePart(world, base.func_177984_a().func_177972_a(facing), notifyTile, player);
    }

    private void deletePart(World world, BlockPos pos, boolean notifyTile, EntityPlayer player) {
        TileEntity te;
        if (notifyTile && (te = world.func_175625_s(pos)) instanceof ITileEntityBase) {
            ((ITileEntityBase)te).breakBlock(world, pos, world.func_180495_p(pos), player);
        }
        world.func_175698_g(pos);
    }

    private BlockPos getBase(BlockPos pos, int part, EnumFacing facing) {
        BlockPos base = pos;
        switch (part) {
            case 2: {
                base = base.func_177977_b().func_177972_a(facing.func_176734_d());
                break;
            }
            case 1: {
                base = base.func_177977_b();
            }
        }
        return base;
    }

    public BlockPos getTip(BlockPos pos, IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockPos base = this.getBase(pos, (Integer)state.func_177229_b((IProperty)PART), facing);
        return base.func_177984_a().func_177972_a(facing);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        int part = (Integer)state.func_177229_b((IProperty)PART);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockPos base = pos;
        switch (part) {
            case 2: {
                base = base.func_177977_b().func_177972_a(facing.func_176734_d());
                break;
            }
            case 1: {
                base = base.func_177977_b();
            }
        }
        if (part != 0) {
            world.func_175656_a(base, state.func_177226_a((IProperty)PART, (Comparable)Integer.valueOf(0)));
        }
        if (part != 1) {
            world.func_175656_a(base.func_177984_a(), state.func_177226_a((IProperty)PART, (Comparable)Integer.valueOf(1)));
        }
        if (part != 2) {
            world.func_175656_a(base.func_177984_a().func_177972_a(facing), state.func_177226_a((IProperty)PART, (Comparable)Integer.valueOf(2)));
        }
        this.updateConnections(state, world, pos);
    }

    public boolean hasTileEntity(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)PART) != 1;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        int part = (Integer)state.func_177229_b((IProperty)PART);
        switch (part) {
            case 0: {
                return new TileEntityStillBase();
            }
            case 2: {
                return new TileEntityStillTip();
            }
        }
        return null;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_177226_a((IProperty)FACING, (Comparable)mirrorIn.func_185803_b((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }
}

