/*
 * Decompiled with CFR 0.152.
 */
package soot.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import soot.tile.TileEntityEmberBurst;
import teamroots.embers.tileentity.ITileEntityBase;

public class BlockEmberBurst
extends Block {
    public static final PropertyDirection facing = PropertyDirection.func_177714_a((String)"facing");

    public BlockEmberBurst(Material material) {
        super(material, MapColor.field_151676_q);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ITileEntityBase) {
            return ((ITileEntityBase)tileEntity).activate(world, pos, state, player, hand, side, hitX, hitY, hitZ);
        }
        return false;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ITileEntityBase) {
            ((ITileEntityBase)tileEntity).breakBlock(world, pos, state, player);
        }
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{facing});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)facing)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)facing, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing face, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)facing, (Comparable)face);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side != state.func_177229_b((IProperty)facing);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityEmberBurst();
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityEmberBurst) {
            ((TileEntityEmberBurst)tileEntity).updateNeighbors((IBlockAccess)world);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        TileEntity t = world.func_175625_s(pos);
        if (t instanceof TileEntityEmberBurst) {
            ((TileEntityEmberBurst)t).updateNeighbors((IBlockAccess)world);
            t.func_70296_d();
        }
        if (world.func_175623_d(pos.func_177967_a((EnumFacing)state.func_177229_b((IProperty)facing), -1))) {
            world.func_175698_g(pos);
            this.func_176226_b(world, pos, state, 0);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)facing)) {
            case UP: {
                return new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
            }
            case DOWN: {
                return new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
            }
            case NORTH: {
                return new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 1.0);
            }
            case SOUTH: {
                return new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 1.0);
            }
            case WEST: {
                return new AxisAlignedBB(0.0, 0.25, 0.25, 1.0, 0.75, 0.75);
            }
            case EAST: {
                return new AxisAlignedBB(0.0, 0.25, 0.25, 1.0, 0.75, 0.75);
            }
        }
        return field_185505_j;
    }
}

