/*
 * Decompiled with CFR 0.152.
 */
package soot.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import soot.block.BlockStill;
import soot.tile.TileEntityDistillationPipe;

public class BlockDistillationPipe
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockDistillationPipe(Material blockMaterialIn) {
        super(blockMaterialIn);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityDistillationPipe();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149710_n(IBlockState state) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkAndDrop(worldIn, state, pos);
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    public void checkAndDrop(World worldIn, IBlockState state, BlockPos pos) {
        if (!worldIn.field_72995_K && !this.canBlockStay(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING))) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public boolean canBlockStay(World worldIn, BlockPos pos, EnumFacing attachDir) {
        BlockPos attachPos = pos.func_177972_a(attachDir);
        IBlockState attach = worldIn.func_180495_p(attachPos);
        return attach.func_177230_c() instanceof BlockStill && (Integer)attach.func_177229_b((IProperty)BlockStill.PART) == 0;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        boolean canStay = false;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!this.canBlockStay(worldIn, pos, facing)) continue;
            canStay = true;
        }
        return super.func_176196_c(worldIn, pos) && canStay;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing attachDir = facing.func_176740_k() != EnumFacing.Axis.Y ? facing : placer.func_174811_aO();
        if (this.canBlockStay(world, pos, attachDir)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)attachDir);
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!this.canBlockStay(world, pos, enumfacing)) continue;
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
        return this.func_176223_P();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() & 3;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }
}

