/*
 * Decompiled with CFR 0.152.
 */
package soot;

import com.google.common.collect.Sets;
import java.util.HashSet;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class Config {
    static Configuration configuration;
    public static boolean DEBUG_MODE;
    public static boolean TRADING_ANTIMONY;
    public static boolean GOLEMS_TYRFING_WEAK;
    public static boolean GOLEMS_POISON_IMMUNE;
    public static boolean ASH_FIRST;
    public static boolean OVERRIDE_BORE;
    public static boolean OVERRIDE_DAWNSTONE_ANVIL;
    public static boolean OVERRIDE_HEARTH_COIL;
    public static boolean OVERRIDE_MIXER;
    public static boolean OVERRIDE_STAMPER;
    public static boolean OVERRIDE_BEAM_CANNON;
    public static boolean OVERRIDE_ALCHEMY_TABLET;
    public static boolean OVERRIDE_MECH_ACCESSOR;
    public static boolean OVERRIDE_ALCHEMY_PEDESTAL;
    public static boolean OVERRIDE_CRYSTAL_CELL;
    public static boolean GENERATE_SULFUR_ORE;

    public static void preInit(FMLPreInitializationEvent event) {
        configuration = new Configuration(event.getSuggestedConfigurationFile());
        configuration.load();
        DEBUG_MODE = Config.loadPropBool("debug", "Debug", "Enables full stack traces when something goes wrong", false);
        OVERRIDE_BORE = Config.loadPropBool("bore", "Overrides", "Overrides the Ember Bore", true);
        OVERRIDE_STAMPER = Config.loadPropBool("stamper", "Overrides", "Overrides the Stamper", true);
        OVERRIDE_MECH_ACCESSOR = Config.loadPropBool("mechAccessor", "Overrides", "Overrides the Mech Accessor", true);
        OVERRIDE_DAWNSTONE_ANVIL = Config.loadPropBool("dawnstoneAnvil", "Overrides", "Overrides the Dawnstone Anvil", true);
        OVERRIDE_HEARTH_COIL = Config.loadPropBool("hearthCoil", "Overrides", "Overrides the Hearth Coil", true);
        OVERRIDE_MIXER = Config.loadPropBool("mixer", "Overrides", "Overrides the Mixer Centrifuge", true);
        OVERRIDE_BEAM_CANNON = Config.loadPropBool("beamCannon", "Overrides", "Overrides the Beam Cannon", true);
        OVERRIDE_ALCHEMY_TABLET = Config.loadPropBool("alchemyTablet", "Overrides", "Overrides the Exchange Tablet", true);
        OVERRIDE_ALCHEMY_PEDESTAL = Config.loadPropBool("alchemyPedestal", "Overrides", "Overrides the Alchemy Pedestal", true);
        OVERRIDE_CRYSTAL_CELL = Config.loadPropBool("crystalCell", "Overrides", "Overrides the Crystal Cell", true);
        TRADING_ANTIMONY = Config.loadPropBool("tradingAntimony", "Features", "Allows trading signet of antimony with villagers instead of emeralds.", true);
        GOLEMS_TYRFING_WEAK = Config.loadPropBool("golemsTyrfingWeak", "Features", "Golems take extra damage from the Tyrfing.", true);
        GOLEMS_POISON_IMMUNE = Config.loadPropBool("golemsPoisonImmune", "Features", "Golems are immune to poison.", true);
        ASH_FIRST = Config.loadPropBool("ashFirst", "Features", "Ash is removed before the aspect from pedestals.", true);
        GENERATE_SULFUR_ORE = Config.loadPropBool("sulfurOre", "Generation", "Whether sulfur ore generates in new chunks.", true);
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static boolean loadPropBool(String propName, String category, String desc, boolean default_) {
        Property prop = configuration.get(category, propName, default_);
        prop.setComment(desc);
        return prop.getBoolean(default_);
    }

    public static int loadPropInt(String propName, String category, String desc, int default_) {
        Property prop = configuration.get(category, propName, default_);
        prop.setComment(desc);
        return prop.getInt(default_);
    }

    public static String[] loadPropStringList(String propName, String category, String desc, String[] default_) {
        Property prop = configuration.get(category, propName, default_);
        prop.setComment(desc);
        return prop.getStringList();
    }

    public static HashSet<String> loadPropStringSet(String propName, String category, String desc, String[] default_) {
        Property prop = configuration.get(category, propName, default_);
        prop.setComment(desc);
        return Sets.newHashSet((Object[])prop.getStringList());
    }
}

