/*
 * Decompiled with CFR 0.152.
 */
package extracells.part.fluid;

import appeng.api.config.RedstoneMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import com.google.common.collect.ImmutableList;
import extracells.api.gas.IAEGasStack;
import extracells.container.fluid.ContainerFluidEmitter;
import extracells.gui.fluid.GuiFluidEmitter;
import extracells.gui.widget.fluid.IFluidSlotListener;
import extracells.models.PartModels;
import extracells.network.packet.other.PacketFluidSlotUpdate;
import extracells.network.packet.part.PacketPartConfig;
import extracells.part.PartECBase;
import extracells.util.NetworkUtil;
import extracells.util.PermissionUtil;
import extracells.util.StorageChannels;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class PartFluidLevelEmitter
extends PartECBase
implements IStackWatcherHost,
IFluidSlotListener {
    protected Fluid selectedFluid;
    private RedstoneMode mode = RedstoneMode.HIGH_SIGNAL;
    private IStackWatcher watcher;
    private long wantedAmount;
    protected long currentAmount;
    private boolean clientRedstoneOutput = false;
    protected boolean isGas = false;

    public float getCableConnectionLength(AECableType aeCableType) {
        return 16.0f;
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    public void changeWantedAmount(int modifier, EntityPlayer player) {
        this.setWantedAmount(this.wantedAmount + (long)modifier, player);
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(7.0, 7.0, 11.0, 9.0, 9.0, 16.0);
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiFluidEmitter(this, player);
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerFluidEmitter(this, player);
    }

    private boolean isLevelEmitterOn() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return this.clientRedstoneOutput;
        }
        IGridNode gridNode = this.getGridNode();
        if (gridNode == null || !gridNode.isActive()) {
            return false;
        }
        switch (this.mode) {
            case LOW_SIGNAL: {
                return this.wantedAmount >= this.currentAmount;
            }
            case HIGH_SIGNAL: {
                return this.wantedAmount <= this.currentAmount;
            }
        }
        return false;
    }

    @Override
    public int isProvidingStrongPower() {
        return this.isLevelEmitterOn() ? 15 : 0;
    }

    @Override
    public int isProvidingWeakPower() {
        return this.isProvidingStrongPower();
    }

    protected void notifyTargetBlock(TileEntity tileEntity, EnumFacing facing) {
        tileEntity.func_145831_w().func_175685_c(tileEntity.func_174877_v(), Blocks.field_150350_a, true);
        tileEntity.func_145831_w().func_175685_c(tileEntity.func_174877_v().func_177972_a(facing), Blocks.field_150350_a, true);
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (PermissionUtil.hasPermission(player, SecurityPermissions.BUILD, this)) {
            return super.onActivate(player, hand, pos);
        }
        return false;
    }

    public void onStackChange(IItemList o, IAEStack fullStack, IAEStack diffStack, IActionSource src, IStorageChannel chan) {
        if (this.isGas && chan == StorageChannels.GAS()) {
            this.onStackChangeGas((IAEGasStack)fullStack, (IAEGasStack)diffStack);
        } else if (chan == StorageChannels.FLUID() && diffStack != null && ((IAEFluidStack)diffStack).getFluid() == this.selectedFluid) {
            this.currentAmount = fullStack != null ? fullStack.getStackSize() : 0L;
            IGridNode node = this.getGridNode();
            if (node != null) {
                this.setActive(node.isActive());
                this.getHost().markForUpdate();
                this.notifyTargetBlock(this.getHostTile(), this.getFacing());
            }
        }
    }

    protected void onStackChangeGas(IAEGasStack fullStack, IAEGasStack diffStack) {
    }

    @Override
    public void randomDisplayTick(World world, BlockPos blockPos, Random random) {
        if (this.isLevelEmitterOn()) {
            EnumFacing facing = this.getFacing();
            double d0 = (double)((float)facing.func_82601_c() * 0.45f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            double d1 = (double)((float)facing.func_96559_d() * 0.45f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            double d2 = (double)((float)facing.func_82599_e() * 0.45f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            world.func_175688_a(EnumParticleTypes.REDSTONE, 0.5 + (double)blockPos.func_177958_n() + d0, 0.5 + (double)blockPos.func_177956_o() + d1, 0.5 + (double)blockPos.func_177952_p() + d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.selectedFluid = FluidRegistry.getFluid((String)data.func_74779_i("fluid"));
        this.mode = RedstoneMode.values()[data.func_74762_e("mode")];
        this.wantedAmount = data.func_74763_f("wantedAmount");
        if (this.wantedAmount < 0L) {
            this.wantedAmount = 0L;
        }
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        super.readFromStream(data);
        this.clientRedstoneOutput = data.readBoolean();
        if (this.getHost() != null) {
            this.getHost().markForUpdate();
        }
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        if (this.selectedFluid != null) {
            data.func_74778_a("fluid", this.selectedFluid.getName());
        } else {
            data.func_82580_o("fluid");
        }
        data.func_74768_a("mode", this.mode.ordinal());
        data.func_74772_a("wantedAmount", this.wantedAmount);
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeBoolean(this.isLevelEmitterOn());
    }

    @Override
    public void setFluid(int index, Fluid fluid, EntityPlayer player) {
        this.selectedFluid = fluid;
        if (this.watcher == null) {
            return;
        }
        this.watcher.reset();
        this.updateWatcher(this.watcher);
        if (this.selectedFluid != null) {
            NetworkUtil.sendToPlayer(new PacketFluidSlotUpdate((List<Fluid>)ImmutableList.of((Object)this.selectedFluid)), player);
        }
        this.saveData();
    }

    public void setWantedAmount(long wantedAmount, EntityPlayer player) {
        this.wantedAmount = wantedAmount;
        if (this.wantedAmount < 0L) {
            this.wantedAmount = 0L;
        }
        this.notifyTargetBlock(this.getHostTile(), this.getFacing());
        if (this.getHost() != null) {
            this.getHost().markForUpdate();
        }
        this.saveData();
    }

    public void syncClientGui(EntityPlayer player) {
        NetworkUtil.sendToPlayer(new PacketPartConfig(this, "FluidEmitter.Mode", this.mode.toString()), player);
        NetworkUtil.sendToPlayer(new PacketPartConfig(this, "FluidEmitter.Amount", Long.toString(this.wantedAmount)), player);
        if (this.selectedFluid != null) {
            NetworkUtil.sendToPlayer(new PacketFluidSlotUpdate((List<Fluid>)ImmutableList.of((Object)this.selectedFluid)), player);
        }
    }

    public long getWantedAmount() {
        return this.wantedAmount;
    }

    public void toggleMode(EntityPlayer player) {
        switch (this.mode) {
            case LOW_SIGNAL: {
                this.mode = RedstoneMode.HIGH_SIGNAL;
                break;
            }
            default: {
                this.mode = RedstoneMode.LOW_SIGNAL;
            }
        }
        this.notifyTargetBlock(this.getHostTile(), this.getFacing());
        NetworkUtil.sendToPlayer(new PacketPartConfig(this, "FluidEmitter.Mode", this.mode.toString()), player);
        if (this.getHost() != null) {
            this.getHost().markForUpdate();
        }
        this.saveData();
    }

    public void updateWatcher(IStackWatcher newWatcher) {
        this.watcher = newWatcher;
        if (this.selectedFluid != null) {
            if (this.isGas) {
                this.watcher.add(StorageChannels.GAS().createStack(new FluidStack(this.selectedFluid, 1)));
            } else {
                this.watcher.add(StorageChannels.FLUID().createStack((Object)new FluidStack(this.selectedFluid, 1)));
            }
        }
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return this.isLevelEmitterOn() ? PartModels.EMITTER_ON_HAS_CHANNEL : PartModels.EMITTER_OFF_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return this.isLevelEmitterOn() ? PartModels.EMITTER_ON_ON : PartModels.EMITTER_OFF_ON;
        }
        return this.isLevelEmitterOn() ? PartModels.EMITTER_ON_OFF : PartModels.EMITTER_OFF_OFF;
    }
}

