/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbguides.gui.components;

import com.feed_the_beast.ftbguides.FTBGuides;
import com.feed_the_beast.ftbguides.gui.GuiGuide;
import com.feed_the_beast.ftbguides.gui.components.CombinedGuideComponent;
import com.feed_the_beast.ftbguides.gui.components.ComponentPanel;
import com.feed_the_beast.ftbguides.gui.components.GuideComponent;
import com.feed_the_beast.ftbguides.gui.components.IGuideComponentWidget;
import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.MismatchingParentPanelException;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class TableGuideComponent
extends CombinedGuideComponent {
    public boolean hasHead = true;
    public final List<HeadCellComponent> rows = new ArrayList<HeadCellComponent>();

    public HeadCellComponent addRow() {
        HeadCellComponent component = new HeadCellComponent(this);
        this.rows.add(component);
        return component;
    }

    @Override
    public IGuideComponentWidget createWidget(ComponentPanel parent) {
        return new PanelTable(parent, this);
    }

    private static class PanelTable
    extends ComponentPanel {
        private TableGuideComponent table;
        public int padding;
        public boolean drawBorders;

        private PanelTable(ComponentPanel parent, TableGuideComponent c) {
            super(parent);
            this.setUnicode(true);
            this.table = c;
            this.padding = Integer.parseInt(this.table.getProperty("padding", true, "2"));
            this.drawBorders = this.table.getProperty("borders", true, "true").equals("true");
        }

        @Override
        public List<GuideComponent> getComponents() {
            return this.table.components;
        }

        @Override
        public void refreshWidgets() {
            int i;
            if (FTBLibConfig.debugging.print_more_info) {
                // empty if block
            }
            boolean printInfo = false;
            this.totalWidth = 0;
            this.totalHeight = 0;
            this.widgets.clear();
            Theme theme = this.getGui().getTheme();
            theme.pushFontUnicode(true);
            int[] widths = new int[this.table.rows.size()];
            int[] heights = new int[this.table.components.size() / widths.length + (this.table.hasHead ? 1 : 0)];
            if (printInfo) {
                FTBGuides.LOGGER.info("Table: Begin [" + widths.length * heights.length + " cells, " + widths.length + "x" + heights.length + "]");
            }
            int[] minWidths = new int[widths.length];
            int[] maxWidths = new int[widths.length];
            int[] xpos = new int[widths.length];
            int[] ypos = new int[heights.length];
            if (this.getComponents().size() % widths.length != 0) {
                FTBGuides.LOGGER.error("There is something wrong with this table! " + widths.length + "x" + heights.length + " & " + this.getComponents().size() + " elements: " + this.getComponents());
            }
            for (i = 0; i < maxWidths.length; ++i) {
                maxWidths[i] = Integer.parseInt(this.table.rows.get(i).getProperty("max_width", true, Integer.toString(Integer.MAX_VALUE)));
                minWidths[i] = Integer.parseInt(this.table.rows.get(i).getProperty("min_width", true, "8"));
            }
            try {
                if (this.table.hasHead) {
                    for (i = 0; i < widths.length; ++i) {
                        ComponentPanel widget = (ComponentPanel)this.table.rows.get(i).createWidget(this);
                        widget.maxWidth = maxWidths[i];
                        widget.refreshWidgets();
                        widths[i] = Math.max(widths[i], widget.width);
                        heights[0] = Math.max(heights[0], widget.height);
                        if (printInfo) {
                            FTBGuides.LOGGER.info("Table Head " + i + ": " + widget.width + ":" + widget.height);
                        }
                        this.add((Widget)widget);
                    }
                }
                i = this.table.hasHead ? widths.length : 0;
                for (GuideComponent component : this.getComponents()) {
                    Widget widget = (Widget)component.createWidget(this);
                    int hi = i % widths.length;
                    int vi = i / widths.length;
                    if (widget instanceof ComponentPanel) {
                        ((ComponentPanel)widget).maxWidth = maxWidths[hi];
                    }
                    if (widget instanceof Panel) {
                        ((Panel)widget).refreshWidgets();
                    }
                    widths[hi] = Math.max(widths[hi], widget.width);
                    heights[vi] = Math.max(heights[vi], widget.height);
                    if (printInfo) {
                        FTBGuides.LOGGER.info("Table Cell " + hi + ":" + vi + ": " + widget.width + ":" + widget.height);
                    }
                    this.add(widget);
                    ++i;
                }
            }
            catch (MismatchingParentPanelException ex) {
                FTBGuides.LOGGER.error(ex.getMessage());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            for (i = 0; i < widths.length; ++i) {
                widths[i] = Math.max(minWidths[i], widths[i]) + 4;
                int n = i;
                widths[n] = widths[n] + this.padding * 2;
                this.totalWidth += widths[i];
                for (int j = 0; j < i; ++j) {
                    int n2 = i;
                    xpos[n2] = xpos[n2] + widths[j];
                }
            }
            for (i = 0; i < heights.length; ++i) {
                int n = i;
                heights[n] = heights[n] + this.padding * 2;
                this.totalHeight += heights[i];
                for (int j = 0; j < i; ++j) {
                    int n3 = i;
                    ypos[n3] = ypos[n3] + heights[j];
                }
            }
            for (i = 0; i < this.widgets.size(); ++i) {
                Widget widget = (Widget)this.widgets.get(i);
                int hi = i % widths.length;
                int vi = i / widths.length;
                if (widget instanceof Panel) {
                    for (Widget w : ((Panel)widget).widgets) {
                        w.posX += this.padding;
                        w.posY += this.padding + (heights[vi] - widget.height) / 2;
                    }
                }
                widget.posX = xpos[hi];
                widget.posY = ypos[vi];
                widget.width = widths[hi];
                widget.height = heights[vi];
            }
            this.setSize(this.totalWidth, this.totalHeight);
            if (printInfo) {
                FTBGuides.LOGGER.info("Table: End " + this.width + ":" + this.height);
            }
            theme.popFontUnicode();
        }

        @Override
        public void addWidgets() {
        }

        @Override
        public void alignWidgets() {
        }

        @Override
        public void drawOffsetBackground(Theme theme, int x, int y, int w, int h) {
            super.drawOffsetBackground(theme, x, y, w, h);
            if (!this.drawBorders) {
                return;
            }
            GlStateManager.func_179090_x();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            Color4I color = ((GuiGuide)this.getGui()).page.lineColor;
            for (Widget widget : this.widgets) {
                int wx = widget.getX();
                int hy = widget.getY();
                GuiHelper.addRectToBuffer((BufferBuilder)buffer, (int)wx, (int)hy, (int)widget.width, (int)1, (Color4I)color);
                GuiHelper.addRectToBuffer((BufferBuilder)buffer, (int)wx, (int)hy, (int)1, (int)widget.height, (Color4I)color);
            }
            GuiHelper.addRectToBuffer((BufferBuilder)buffer, (int)x, (int)(y + h - 1), (int)w, (int)1, (Color4I)color);
            GuiHelper.addRectToBuffer((BufferBuilder)buffer, (int)(x + w - 1), (int)y, (int)1, (int)h, (Color4I)color);
            tessellator.func_78381_a();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179098_w();
        }
    }

    public static class CellComponent
    extends CombinedGuideComponent {
        public final HeadCellComponent head;

        public CellComponent(HeadCellComponent h) {
            this.head = h;
        }

        @Override
        public String getProperty(String key, boolean includeParent) {
            String p;
            String string = p = this.hasProperties() ? (String)this.properties.get(key) : null;
            if (p == null) {
                String string2 = p = this.head.style != null && !this.head.style.isEmpty() ? this.head.style.get(key) : null;
            }
            return p == null ? (this.parent == null || !includeParent ? "" : this.parent.getProperty(key, true)) : p;
        }
    }

    public static class HeadCellComponent
    extends CombinedGuideComponent {
        public final TableGuideComponent table;
        public Map<String, String> style = null;

        public HeadCellComponent(TableGuideComponent t) {
            this.table = t;
            this.setProperty("bold", "true");
        }
    }

    public static enum Align {
        NONE(" --- |"),
        LEFT(" :-- |"),
        RIGHT(" --: |"),
        CENTER(" :-: |");

        public final String md;

        private Align(String s) {
            this.md = s;
        }
    }
}

