/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.tile;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.dave.compactmachines3.block.BlockMachine;
import org.dave.compactmachines3.integration.CapabilityNullHandlerRegistry;
import org.dave.compactmachines3.misc.ConfigurationHandler;
import org.dave.compactmachines3.reference.EnumMachineSize;
import org.dave.compactmachines3.tile.TileEntityRedstoneTunnel;
import org.dave.compactmachines3.tile.TileEntityTunnel;
import org.dave.compactmachines3.utility.Logz;
import org.dave.compactmachines3.world.ChunkLoadingMachines;
import org.dave.compactmachines3.world.WorldSavedDataMachines;
import org.dave.compactmachines3.world.data.RedstoneTunnelData;
import org.dave.compactmachines3.world.tools.DimensionTools;
import org.dave.compactmachines3.world.tools.SpawnTools;
import org.dave.compactmachines3.world.tools.StructureTools;

public class TileEntityMachine
extends TileEntity
implements ICapabilityProvider,
ITickable {
    public int coords = -1;
    private boolean initialized = false;
    public long lastNeighborUpdateTick = 0L;
    public long nextSpawnTick = 0L;
    protected String customName = "";
    protected UUID owner;
    protected String schema;
    protected boolean locked = false;
    protected Set<String> playerWhiteList = new HashSet<String>();

    public EnumMachineSize getSize() {
        return (EnumMachineSize)((Object)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b(BlockMachine.SIZE));
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.coords = compound.func_74762_e("coords");
        this.customName = compound.func_74779_i("CustomName");
        this.owner = compound.func_74764_b("ownerLeast") && compound.func_74764_b("ownerMost") ? compound.func_186857_a("owner") : null;
        this.nextSpawnTick = compound.func_74763_f("spawntick");
        this.schema = compound.func_74764_b("schema") ? compound.func_74779_i("schema") : null;
        this.locked = compound.func_74764_b("locked") ? compound.func_74767_n("locked") : false;
        this.playerWhiteList = new HashSet<String>();
        if (compound.func_74764_b("playerWhiteList")) {
            NBTTagList list = compound.func_150295_c("playerWhiteList", 8);
            for (NBTBase nameTagBase : list) {
                NBTTagString nameTag = (NBTTagString)nameTagBase;
                this.playerWhiteList.add(nameTag.func_150285_a_());
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("coords", this.coords);
        compound.func_74778_a("CustomName", this.customName);
        if (this.hasOwner()) {
            compound.func_186854_a("owner", this.owner);
        }
        compound.func_74772_a("spawntick", this.nextSpawnTick);
        if (this.schema != null) {
            compound.func_74778_a("schema", this.schema);
        }
        compound.func_74757_a("locked", this.locked);
        if (this.playerWhiteList.size() > 0) {
            NBTTagList list = new NBTTagList();
            for (String playerName : this.playerWhiteList) {
                NBTTagString nameTag = new NBTTagString(playerName);
                list.func_74742_a((NBTBase)nameTag);
            }
            compound.func_74782_a("playerWhiteList", (NBTBase)list);
        }
        return compound;
    }

    public void initStructure() {
        if (this.coords != -1) {
            return;
        }
        StructureTools.generateCubeForMachine(this);
        double[] destination = new double[]{(double)(this.coords * 1024) + 0.5 + (double)(this.getSize().getDimension() / 2), 42.0, 0.5 + (double)(this.getSize().getDimension() / 2)};
        WorldSavedDataMachines.INSTANCE.addSpawnPoint(this.coords, destination);
    }

    public boolean isAllowedToEnter(EntityPlayer player) {
        if (!this.isLocked()) {
            return true;
        }
        if (!this.hasOwner()) {
            return true;
        }
        if (player.func_110124_au().equals(this.owner)) {
            return true;
        }
        return this.isOnWhiteList(player);
    }

    public boolean isOnWhiteList(EntityPlayer player) {
        return this.playerWhiteList.contains(player.func_70005_c_());
    }

    public boolean isOnWhiteList(String name) {
        return this.playerWhiteList.contains(name);
    }

    public void addToWhiteList(EntityPlayer player) {
        this.playerWhiteList.add(player.func_70005_c_());
    }

    public void addToWhiteList(String playerName) {
        this.playerWhiteList.add(playerName);
    }

    public void removeFromWhiteList(EntityPlayer player) {
        this.playerWhiteList.remove(player.func_70005_c_());
    }

    public void removeFromWhiteList(String playerName) {
        this.playerWhiteList.remove(playerName);
    }

    public Set<String> getWhiteList() {
        HashSet<String> result = new HashSet<String>();
        if (this.field_145850_b.field_72995_K) {
            Logz.warn("The TileEntityMachine#getWhiteList method should not be called on the client. Please report this to the mod author here: https://github.com/thraaawn/CompactMachines/issues/ Thanks!", new Object[0]);
            return result;
        }
        for (String name : this.playerWhiteList) {
            result.add(name);
        }
        return result;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void toggleLocked() {
        this.locked = !this.locked;
    }

    public void setLocked(boolean state) {
        this.locked = state;
    }

    public boolean hasNewSchema() {
        return this.schema != null && this.schema.length() > 0;
    }

    public String getSchemaName() {
        return this.schema;
    }

    public void setSchema(String schemaName) {
        this.schema = schemaName;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public String getOwnerName() {
        GameProfile profile = FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152652_a(this.getOwner());
        if (profile == null) {
            Logz.warn("Profile not found for owner: %s", this.getOwner());
            return "Unknown";
        }
        return profile.getName();
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public void setOwner(EntityPlayer player) {
        if (player == null) {
            return;
        }
        this.setOwner(player.func_110124_au());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    private void initialize() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (!ChunkLoadingMachines.isMachineChunkLoaded(this.coords)) {
            ChunkLoadingMachines.forceChunk(this.coords);
        }
    }

    public void func_73660_a() {
        if (!this.initialized && !this.func_145837_r() && this.coords != -1) {
            this.initialize();
            this.initialized = true;
        }
        if (this.nextSpawnTick == 0L) {
            this.nextSpawnTick = this.func_145831_w().func_82737_E() + (long)ConfigurationHandler.MachineSettings.spawnRate;
        }
        if (!this.func_145831_w().field_72995_K && this.coords != -1 && this.isInsideItself() && this.func_145831_w().func_82737_E() % 20L == 0L) {
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.wither.spawn")), SoundCategory.MASTER, 1.0f, 1.0f);
        }
        if (!this.func_145831_w().field_72995_K && this.coords != -1 && this.func_145831_w().func_82737_E() > this.nextSpawnTick) {
            if (ConfigurationHandler.MachineSettings.allowPeacefulSpawns || ConfigurationHandler.MachineSettings.allowHostileSpawns) {
                SpawnTools.spawnEntitiesInMachine(this.coords);
            }
            this.nextSpawnTick = this.func_145831_w().func_82737_E() + (long)ConfigurationHandler.MachineSettings.spawnRate;
            this.func_70296_d();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (ConfigurationHandler.Settings.forceLoadChunks) {
            return;
        }
        ChunkLoadingMachines.unforceChunk(this.coords);
    }

    public RedstoneTunnelData getRedstoneTunnelForSide(EnumFacing side) {
        if (!WorldSavedDataMachines.INSTANCE.redstoneTunnels.containsKey(this.coords)) {
            return null;
        }
        return WorldSavedDataMachines.INSTANCE.redstoneTunnels.get(this.coords).get(side);
    }

    public BlockPos getTunnelForSide(EnumFacing side) {
        if (WorldSavedDataMachines.INSTANCE == null || WorldSavedDataMachines.INSTANCE.tunnels == null) {
            return null;
        }
        if (!WorldSavedDataMachines.INSTANCE.tunnels.containsKey(this.coords)) {
            return null;
        }
        return WorldSavedDataMachines.INSTANCE.tunnels.get(this.coords).get(side);
    }

    public BlockPos getMachineWorldInsetPos(EnumFacing facing) {
        BlockPos tunnelPos = this.getTunnelForSide(facing);
        if (tunnelPos == null) {
            return null;
        }
        EnumFacing insetDirection = StructureTools.getInsetWallFacing(tunnelPos, this.getSize().getDimension());
        return tunnelPos.func_177972_a(insetDirection);
    }

    public IBlockState getConnectedBlockState(EnumFacing facing) {
        BlockPos insetPos = this.getMachineWorldInsetPos(facing);
        if (insetPos == null) {
            return null;
        }
        WorldServer machineWorld = DimensionTools.getServerMachineWorld();
        return machineWorld.func_180495_p(insetPos);
    }

    public TileEntity getConnectedTileEntity(EnumFacing facing) {
        BlockPos insetPos = this.getMachineWorldInsetPos(facing);
        if (insetPos == null) {
            return null;
        }
        WorldServer machineWorld = DimensionTools.getServerMachineWorld();
        return machineWorld.func_175625_s(insetPos);
    }

    public boolean isInsideItself() {
        if (this.func_145831_w().field_73011_w.getDimension() != ConfigurationHandler.Settings.dimensionId) {
            return false;
        }
        return StructureTools.getCoordsForPos(this.func_174877_v()) == this.coords;
    }

    public ItemStack getConnectedPickBlock(EnumFacing facing) {
        BlockPos insetPos = this.getMachineWorldInsetPos(facing);
        if (insetPos == null) {
            return ItemStack.field_190927_a;
        }
        WorldServer machineWorld = DimensionTools.getServerMachineWorld();
        IBlockState state = machineWorld.func_180495_p(insetPos);
        return state.func_177230_c().func_185473_a((World)machineWorld, insetPos, state);
    }

    public int getRedstonePowerOutput(EnumFacing facing) {
        if (this.coords == -1) {
            return 0;
        }
        if (WorldSavedDataMachines.INSTANCE == null || WorldSavedDataMachines.INSTANCE.redstoneTunnels == null) {
            return 0;
        }
        HashMap<EnumFacing, RedstoneTunnelData> tunnelMapping = WorldSavedDataMachines.INSTANCE.redstoneTunnels.get(this.coords);
        if (tunnelMapping == null) {
            return 0;
        }
        RedstoneTunnelData tunnelData = tunnelMapping.get(facing);
        if (tunnelData == null) {
            return 0;
        }
        if (!tunnelData.isOutput) {
            return 0;
        }
        WorldServer machineWorld = DimensionTools.getServerMachineWorld();
        if (!(machineWorld.func_175625_s(tunnelData.pos) instanceof TileEntityRedstoneTunnel)) {
            return 0;
        }
        EnumFacing insetDirection = StructureTools.getInsetWallFacing(tunnelData.pos, this.getSize().getDimension());
        BlockPos insetPos = tunnelData.pos.func_177972_a(insetDirection);
        IBlockState insetBlockState = machineWorld.func_180495_p(insetPos);
        int power = 0;
        power = insetBlockState.func_177230_c() instanceof BlockRedstoneWire ? ((Integer)insetBlockState.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O)).intValue() : machineWorld.func_175651_c(insetPos, insetDirection);
        return power;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.isInsideItself()) {
            return false;
        }
        if (this.func_145831_w().field_72995_K || facing == null) {
            if (CapabilityNullHandlerRegistry.hasNullHandler(capability)) {
                return true;
            }
            return super.hasCapability(capability, facing);
        }
        BlockPos tunnelPos = this.getTunnelForSide(facing);
        if (tunnelPos == null) {
            return false;
        }
        WorldServer machineWorld = DimensionTools.getServerMachineWorld();
        if (!(machineWorld.func_175625_s(tunnelPos) instanceof TileEntityTunnel)) {
            return false;
        }
        EnumFacing insetDirection = StructureTools.getInsetWallFacing(tunnelPos, this.getSize().getDimension());
        BlockPos insetPos = tunnelPos.func_177972_a(insetDirection);
        TileEntity te = machineWorld.func_175625_s(insetPos);
        if (te != null && te instanceof ICapabilityProvider && te.hasCapability(capability, insetDirection.func_176734_d())) {
            return true;
        }
        return CapabilityNullHandlerRegistry.hasNullHandler(capability);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.isInsideItself()) {
            return null;
        }
        if (this.func_145831_w().field_72995_K || facing == null) {
            if (CapabilityNullHandlerRegistry.hasNullHandler(capability)) {
                return CapabilityNullHandlerRegistry.getNullHandler(capability);
            }
            return (T)super.getCapability(capability, facing);
        }
        BlockPos tunnelPos = this.getTunnelForSide(facing);
        if (tunnelPos == null) {
            return null;
        }
        WorldServer machineWorld = DimensionTools.getServerMachineWorld();
        if (!(machineWorld.func_175625_s(tunnelPos) instanceof TileEntityTunnel)) {
            return null;
        }
        EnumFacing insetDirection = StructureTools.getInsetWallFacing(tunnelPos, this.getSize().getDimension());
        BlockPos insetPos = tunnelPos.func_177972_a(insetDirection);
        TileEntity te = machineWorld.func_175625_s(insetPos);
        if (te instanceof ICapabilityProvider && te.hasCapability(capability, insetDirection.func_176734_d())) {
            return (T)machineWorld.func_175625_s(insetPos).getCapability(capability, insetDirection.func_176734_d());
        }
        if (CapabilityNullHandlerRegistry.hasNullHandler(capability)) {
            return CapabilityNullHandlerRegistry.getNullHandler(capability);
        }
        return null;
    }
}

