/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretroomsmod.tileentity;

import com.wynprice.secretroomsmod.SecretRooms5;
import com.wynprice.secretroomsmod.base.interfaces.ISecretBlock;
import com.wynprice.secretroomsmod.base.interfaces.ISecretTileEntity;
import com.wynprice.secretroomsmod.handler.ParticleHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;

public class TileEntityInfomationHolder
extends TileEntity
implements ITickable,
ISecretTileEntity {
    protected IBlockState mirrorState;
    private boolean locked;

    @Override
    public void loadFromNBT(NBTTagCompound compound) {
        this.func_145839_a(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        ISecretTileEntity.TileEntityData data = ISecretTileEntity.super.readDataFromNBT(compound, this.getTileData());
        this.mirrorState = data.getMirroredState();
        this.locked = data.isLocked();
    }

    public void func_73660_a() {
        if (this.mirrorState != null) {
            ParticleHandler.BLOCKBRAKERENDERMAP.put(this.field_174879_c, this.mirrorState.func_177230_c().func_176203_a(this.mirrorState.func_177230_c().func_176201_c(this.mirrorState)));
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, -1, -1), this.func_174877_v().func_177982_a(1, 1, 1));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        ISecretTileEntity.super.writeDataToNBT(compound, new ISecretTileEntity.TileEntityData().setMirroredState(this.getMirrorStateSafely()).setLocked(this.locked));
        return super.func_189515_b(compound);
    }

    @Override
    public IBlockState getMirrorState() {
        if (this.mirrorState == null && ParticleHandler.BLOCKBRAKERENDERMAP.containsKey(this.field_174879_c)) {
            this.mirrorState = ParticleHandler.BLOCKBRAKERENDERMAP.get(this.field_174879_c);
        }
        if (this.mirrorState == null && RENDER_MAP.containsKey(this.field_174879_c)) {
            this.mirrorState = ISecretTileEntity.getMap(this.field_145850_b).get(this.field_174879_c);
        }
        return this.mirrorState;
    }

    public double func_145833_n() {
        return Double.MAX_VALUE;
    }

    @Override
    public void setMirrorState(IBlockState mirrorState) {
        if (!this.locked) {
            this.setMirrorStateForcable(mirrorState);
        }
        this.locked = true;
    }

    @Override
    public void setMirrorStateForcable(IBlockState mirrorState) {
        if (mirrorState.func_177230_c() == null) {
            SecretRooms5.LOGGER.error("Null BlockState passed in at: {}, {}, {}. This is most likely doue to world corruption. Setting mirrored state to {}", (Object)this.func_174877_v().func_177958_n(), (Object)this.func_174877_v().func_177956_o(), (Object)this.func_174877_v().func_177952_p(), (Object)(this.mirrorState == null ? "default (stone)" : this.mirrorState));
            if (this.mirrorState == null) {
                mirrorState = Blocks.field_150348_b.func_176223_P();
            } else {
                return;
            }
        }
        if (mirrorState.func_177230_c() instanceof ISecretBlock) {
            mirrorState = Blocks.field_150348_b.func_176223_P();
        }
        ISecretTileEntity.getMap(this.field_145850_b).put(this.field_174879_c, mirrorState);
        this.mirrorState = mirrorState.func_177230_c().func_176203_a(mirrorState.func_177230_c().func_176201_c(mirrorState));
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        int metadata = this.func_145832_p();
        return new SPacketUpdateTileEntity(this.field_174879_c, metadata, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }
}

