/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shaper;

import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.ColorChoiceLabel;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.tileentity.GenericEnergyStorageTileEntity;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftools.CommandHandler;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.shaper.LocatorTileEntity;
import mcjty.rftools.blocks.shaper.ScannerConfiguration;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.shapes.BeaconType;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiLocator
extends GenericGuiContainer<LocatorTileEntity> {
    private static final int LOCATOR_WIDTH = 256;
    private static final int LOCATOR_HEIGHT = 238;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/locator.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private EnergyBar energyBar;
    private ColorChoiceLabel hostile;
    private ColorChoiceLabel passive;
    private ColorChoiceLabel player;
    private ToggleButton hostileBeacon;
    private ToggleButton passiveBeacon;
    private ToggleButton playerBeacon;
    private TextField filter;
    private ColorChoiceLabel energy;
    private ToggleButton energyBeacon;
    private TextField minEnergy;
    private TextField maxEnergy;
    private Label energyLabel;
    public static int energyConsumption = 0;
    private static final Map<Integer, BeaconType> COLOR_TO_TYPE = new HashMap<Integer, BeaconType>();
    static int cnt = 10;

    public GuiLocator(LocatorTileEntity tileEntity, GenericContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)tileEntity, (Container)container, RFTools.GUI_MANUAL_SHAPE, "locator");
        this.field_146999_f = 256;
        this.field_147000_g = 238;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Panel toplevel = ((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout());
        long maxEnergyStored = ((LocatorTileEntity)this.tileEntity).getCapacity();
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setHorizontal().setMaxValue(maxEnergyStored).setLayoutHint(28, 10, 70, 10)).setShowText(false);
        this.energyBar.setValue(GenericEnergyStorageTileEntity.getCurrentRF());
        toplevel.addChild((Widget)this.energyBar);
        ImageChoiceLabel redstoneMode = this.initRedstoneMode();
        toplevel.addChild((Widget)redstoneMode);
        this.hostile = new ColorChoiceLabel(this.field_146297_k, (Gui)this);
        this.hostileBeacon = new ToggleButton(this.field_146297_k, (Gui)this);
        this.addBeaconSetting(toplevel, this.hostile, this.hostileBeacon, 30, "Hostile");
        this.hostile.setCurrentColor(Integer.valueOf(((LocatorTileEntity)this.tileEntity).getHostileType().getColor()));
        this.hostileBeacon.setPressed(((LocatorTileEntity)this.tileEntity).isHostileBeacon());
        this.passive = new ColorChoiceLabel(this.field_146297_k, (Gui)this);
        this.passiveBeacon = new ToggleButton(this.field_146297_k, (Gui)this);
        this.addBeaconSetting(toplevel, this.passive, this.passiveBeacon, 46, "Passive");
        this.passive.setCurrentColor(Integer.valueOf(((LocatorTileEntity)this.tileEntity).getPassiveType().getColor()));
        this.passiveBeacon.setPressed(((LocatorTileEntity)this.tileEntity).isPassiveBeacon());
        this.player = new ColorChoiceLabel(this.field_146297_k, (Gui)this);
        this.playerBeacon = new ToggleButton(this.field_146297_k, (Gui)this);
        this.addBeaconSetting(toplevel, this.player, this.playerBeacon, 62, "Player");
        this.player.setCurrentColor(Integer.valueOf(((LocatorTileEntity)this.tileEntity).getPlayerType().getColor()));
        this.playerBeacon.setPressed(((LocatorTileEntity)this.tileEntity).isPlayerBeacon());
        toplevel.addChild(((Label)new Label(this.field_146297_k, (Gui)this).setText("Filter")).setLayoutHint(8, 82, 40, 14));
        this.filter = new TextField(this.field_146297_k, (Gui)this);
        this.filter.setLayoutHint(50, 82, 90, 14);
        this.filter.setText(((LocatorTileEntity)this.tileEntity).getFilter());
        this.filter.addTextEvent((parent, newText) -> this.update());
        toplevel.addChild((Widget)this.filter);
        this.energy = new ColorChoiceLabel(this.field_146297_k, (Gui)this);
        this.energyBeacon = new ToggleButton(this.field_146297_k, (Gui)this);
        this.addBeaconSetting(toplevel, this.energy, this.energyBeacon, 98, "Energy");
        this.energy.setCurrentColor(Integer.valueOf(((LocatorTileEntity)this.tileEntity).getEnergyType().getColor()));
        this.energyBeacon.setPressed(((LocatorTileEntity)this.tileEntity).isEnergyBeacon());
        toplevel.addChild(((Label)new Label(this.field_146297_k, (Gui)this).setText("<")).setLayoutHint(153, 98, 10, 14));
        this.minEnergy = (TextField)new TextField(this.field_146297_k, (Gui)this).setLayoutHint(162, 98, 25, 14);
        this.minEnergy.setText(((LocatorTileEntity)this.tileEntity).getMinEnergy() == null ? "" : Integer.toString(((LocatorTileEntity)this.tileEntity).getMinEnergy()));
        this.minEnergy.addTextEvent((parent, newText) -> this.update());
        toplevel.addChild(((Label)new Label(this.field_146297_k, (Gui)this).setText("%")).setLayoutHint(187, 98, 10, 14));
        toplevel.addChild((Widget)this.minEnergy);
        toplevel.addChild(((Label)new Label(this.field_146297_k, (Gui)this).setText(">")).setLayoutHint(205, 98, 10, 14));
        this.maxEnergy = (TextField)new TextField(this.field_146297_k, (Gui)this).setLayoutHint(214, 98, 25, 14);
        this.maxEnergy.setText(((LocatorTileEntity)this.tileEntity).getMaxEnergy() == null ? "" : Integer.toString(((LocatorTileEntity)this.tileEntity).getMaxEnergy()));
        this.maxEnergy.addTextEvent((parent, newText) -> this.update());
        toplevel.addChild((Widget)this.maxEnergy);
        toplevel.addChild(((Label)new Label(this.field_146297_k, (Gui)this).setText("%")).setLayoutHint(238, 98, 10, 14));
        toplevel.addChild(((Label)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setColor(0x993300)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setText("RF per scan (every " + ScannerConfiguration.ticksPerLocatorScan + " ticks):")).setLayoutHint(8, 186, 156, 14));
        this.energyLabel = (Label)new Label(this.field_146297_k, (Gui)this).setText("");
        this.energyLabel.setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        this.energyLabel.setLayoutHint(8, 200, 156, 14);
        toplevel.addChild((Widget)this.energyLabel);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
        ((LocatorTileEntity)this.tileEntity).requestRfFromServer("rftools");
        energyConsumption = 0;
        this.window.bind(RFToolsMessages.INSTANCE, "redstone", this.tileEntity, GenericTileEntity.VALUE_RSMODE.getName());
    }

    private void addBeaconSetting(Panel toplevel, ColorChoiceLabel choice, ToggleButton toggle, int y, String label) {
        toplevel.addChild((Widget)((Label)new Label(this.field_146297_k, (Gui)this).setText(label)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(8, y, 40, 14)));
        choice.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(50, y, 30, 14));
        for (BeaconType type : BeaconType.VALUES) {
            choice.addColors(new Integer[]{type.getColor()});
            COLOR_TO_TYPE.put(type.getColor(), type);
        }
        choice.addChoiceEvent((parent, newColor) -> this.update());
        toplevel.addChild((Widget)choice);
        toggle.setCheckMarker(true).setText("Beacon");
        toggle.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(90, y, 60, 14));
        toggle.addButtonEvent(parent -> this.update());
        toplevel.addChild((Widget)toggle);
    }

    private void update() {
        TypedMap.Builder builder = TypedMap.builder();
        builder.put(LocatorTileEntity.PARAM_HOSTILE_TYPE, (Object)COLOR_TO_TYPE.get(this.hostile.getCurrentColor()).getCode());
        builder.put(LocatorTileEntity.PARAM_PASSIVE_TYPE, (Object)COLOR_TO_TYPE.get(this.passive.getCurrentColor()).getCode());
        builder.put(LocatorTileEntity.PARAM_PLAYER_TYPE, (Object)COLOR_TO_TYPE.get(this.player.getCurrentColor()).getCode());
        builder.put(LocatorTileEntity.PARAM_ENERGY_TYPE, (Object)COLOR_TO_TYPE.get(this.energy.getCurrentColor()).getCode());
        builder.put(LocatorTileEntity.PARAM_HOSTILE_BEACON, (Object)this.hostileBeacon.isPressed());
        builder.put(LocatorTileEntity.PARAM_PASSIVE_BEACON, (Object)this.passiveBeacon.isPressed());
        builder.put(LocatorTileEntity.PARAM_PLAYER_BEACON, (Object)this.playerBeacon.isPressed());
        builder.put(LocatorTileEntity.PARAM_ENERGY_BEACON, (Object)this.energyBeacon.isPressed());
        builder.put(LocatorTileEntity.PARAM_FILTER, (Object)this.filter.getText());
        if (!this.minEnergy.getText().trim().isEmpty()) {
            try {
                builder.put(LocatorTileEntity.PARAM_MIN_ENERGY, (Object)Integer.parseInt(this.minEnergy.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!this.maxEnergy.getText().trim().isEmpty()) {
            try {
                builder.put(LocatorTileEntity.PARAM_MAX_ENERGY, (Object)Integer.parseInt(this.maxEnergy.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.sendServerCommand(RFToolsMessages.INSTANCE, "locator.setSettings", builder.build());
    }

    private ImageChoiceLabel initRedstoneMode() {
        ImageChoiceLabel redstoneMode = ((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setName("redstone")).addChoice(RedstoneMode.REDSTONE_IGNORED.getDescription(), "Redstone mode:\nIgnored", iconGuiElements, 0, 0).addChoice(RedstoneMode.REDSTONE_OFFREQUIRED.getDescription(), "Redstone mode:\nOff to activate", iconGuiElements, 16, 0).addChoice(RedstoneMode.REDSTONE_ONREQUIRED.getDescription(), "Redstone mode:\nOn to activate", iconGuiElements, 32, 0);
        redstoneMode.setLayoutHint(8, 10, 16, 16);
        return redstoneMode;
    }

    protected void func_146976_a(float v, int x, int y) {
        this.drawWindow();
        long currentRF = GenericEnergyStorageTileEntity.getCurrentRF();
        this.energyBar.setValue(currentRF);
        ((LocatorTileEntity)this.tileEntity).requestRfFromServer("rftools");
        if (--cnt < 0) {
            cnt = 10;
            this.sendServerCommand("rftools", "requestLocatorEnergy", TypedMap.builder().put(CommandHandler.PARAM_POS, (Object)((LocatorTileEntity)this.tileEntity).func_174877_v()).build());
        }
        this.energyLabel.setText(energyConsumption + " RF");
    }
}

