/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.types;

import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.tile.TileSpectralBlock;
import WayofTime.bloodmagic.util.Utils;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

@RitualRegister(value="suppression")
public class RitualSuppression
extends Ritual {
    public static final String SUPPRESSION_RANGE = "suppressionRange";

    public RitualSuppression() {
        super("ritualSuppression", 0, 10000, "ritual.bloodmagic.suppressionRitual");
        this.addBlockRange(SUPPRESSION_RANGE, new AreaDescriptor.HemiSphere(new BlockPos(0, 0, 0), 10));
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        int refresh = 100;
        AreaDescriptor suppressionRange = this.getBlockRange(SUPPRESSION_RANGE);
        for (BlockPos blockPos : suppressionRange.getContainedPositions(masterRitualStone.getBlockPos())) {
            IBlockState state = world.func_180495_p(blockPos);
            if (Utils.isBlockLiquid(state) && world.func_175625_s(blockPos) == null) {
                TileSpectralBlock.createSpectralBlock(world, blockPos, 100);
                continue;
            }
            TileEntity tile = world.func_175625_s(blockPos);
            if (!(tile instanceof TileSpectralBlock)) continue;
            ((TileSpectralBlock)tile).resetDuration(100);
        }
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 2;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 2, 0, EnumRuneType.WATER);
        this.addRune(components, -2, 0, -1, EnumRuneType.AIR);
        this.addRune(components, -1, 0, -2, EnumRuneType.AIR);
        this.addRune(components, -2, 0, 1, EnumRuneType.AIR);
        this.addRune(components, 1, 0, -2, EnumRuneType.AIR);
        this.addRune(components, 2, 0, 1, EnumRuneType.AIR);
        this.addRune(components, 1, 0, 2, EnumRuneType.AIR);
        this.addRune(components, 2, 0, -1, EnumRuneType.AIR);
        this.addRune(components, -1, 0, 2, EnumRuneType.AIR);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualSuppression();
    }
}

