/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.types;

import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.BlockLiquidWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBlockWrapper;
import org.apache.commons.lang3.tuple.Pair;

@RitualRegister(value="pump")
public class RitualPump
extends Ritual {
    public static final String PUMP_RANGE = "pumpRange";
    private List<Pair<BlockPos, FluidStack>> liquidsCache;
    private Iterator<Pair<BlockPos, FluidStack>> blockPosIterator;

    public RitualPump() {
        super("ritualPump", 0, 500, "ritual.bloodmagic.pumpRitual");
        this.addBlockRange(PUMP_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-16, -16, -16), new BlockPos(17, 17, 17)));
        this.setMaximumVolumeAndDistanceOfRange(PUMP_RANGE, 0, 16, 16);
        this.liquidsCache = Lists.newArrayList();
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        TileEntity tileEntity = world.func_175625_s(masterRitualStone.getBlockPos().func_177984_a());
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        if (tileEntity != null && tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN)) {
            IFluidHandler fluidHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN);
            IBlockState tankState = world.func_180495_p(masterRitualStone.getBlockPos().func_177984_a());
            int maxDrain = fluidHandler.getTankProperties()[0].getCapacity();
            if (fluidHandler.getTankProperties()[0].getContents() != null && fluidHandler.getTankProperties()[0].getContents().amount >= maxDrain) {
                return;
            }
            for (BlockPos pos : this.getBlockRange(PUMP_RANGE).getContainedPositions(masterRitualStone.getBlockPos())) {
                Pair posInfo;
                FluidStack blockDrain;
                IBlockState state = world.func_180495_p(pos);
                BlockLiquidWrapper blockHandler = null;
                if (state.func_177230_c() instanceof BlockLiquid) {
                    blockHandler = new BlockLiquidWrapper((BlockLiquid)state.func_177230_c(), world, pos);
                } else if (state.func_177230_c() instanceof IFluidHandler) {
                    blockHandler = new FluidBlockWrapper((IFluidBlock)state.func_177230_c(), world, pos);
                }
                if (blockHandler == null || (blockDrain = blockHandler.drain(maxDrain, false)) == null || fluidHandler.fill(blockDrain, false) != blockDrain.amount || this.liquidsCache.contains(posInfo = Pair.of((Object)pos, (Object)blockHandler.drain(maxDrain, false)))) continue;
                this.liquidsCache.add((Pair<BlockPos, FluidStack>)posInfo);
            }
            this.blockPosIterator = this.liquidsCache.iterator();
            if (this.blockPosIterator.hasNext()) {
                Pair<BlockPos, FluidStack> posInfo = this.blockPosIterator.next();
                masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
                fluidHandler.fill((FluidStack)posInfo.getRight(), true);
                world.func_175656_a((BlockPos)posInfo.getLeft(), Blocks.field_150348_b.func_176223_P());
                world.func_184138_a((BlockPos)posInfo.getLeft(), tankState, tankState, 3);
                this.blockPosIterator.remove();
            }
        }
    }

    @Override
    public int getRefreshCost() {
        return 25;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addRune(components, 1, 0, 1, EnumRuneType.WATER);
        this.addRune(components, 1, 0, -1, EnumRuneType.EARTH);
        this.addRune(components, -1, 0, -1, EnumRuneType.AIR);
        this.addRune(components, -1, 0, 1, EnumRuneType.FIRE);
        this.addCornerRunes(components, 1, 1, EnumRuneType.DUSK);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualPump();
    }
}

