/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual.harvest;

import WayofTime.bloodmagic.ritual.harvest.IHarvestHandler;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStem;
import net.minecraft.block.state.IBlockState;

public class HarvestRegistry {
    private static final List<IHarvestHandler> HARVEST_HANDLERS = Lists.newArrayList();
    private static final Map<Block, Integer> STANDARD_CROPS = Maps.newHashMap();
    private static final Set<IBlockState> TALL_CROPS = Sets.newHashSet();
    private static final Map<IBlockState, IBlockState> STEM_CROPS = Maps.newHashMap();
    private static final Map<IBlockState, Integer> AMPLIFIERS = Maps.newHashMap();

    public static void registerHandler(IHarvestHandler handler) {
        if (!HARVEST_HANDLERS.contains(handler)) {
            HARVEST_HANDLERS.add(handler);
        }
    }

    public static void registerStandardCrop(Block crop, int matureMeta) {
        if (!STANDARD_CROPS.containsKey(crop)) {
            STANDARD_CROPS.put(crop, matureMeta);
        }
    }

    public static void registerTallCrop(IBlockState crop) {
        if (!TALL_CROPS.contains(crop)) {
            TALL_CROPS.add(crop);
        }
    }

    public static void registerStemCrop(IBlockState crop, IBlockState stem) {
        if (!STEM_CROPS.containsKey(crop) && stem.func_177230_c() instanceof BlockStem) {
            STEM_CROPS.put(stem, crop);
        }
    }

    public static void registerRangeAmplifier(IBlockState block, int range) {
        if (!AMPLIFIERS.containsKey(block)) {
            AMPLIFIERS.put(block, range);
        }
    }

    public static List<IHarvestHandler> getHarvestHandlers() {
        return ImmutableList.copyOf(HARVEST_HANDLERS);
    }

    public static Map<Block, Integer> getStandardCrops() {
        return ImmutableMap.copyOf(STANDARD_CROPS);
    }

    public static Set<IBlockState> getTallCrops() {
        return ImmutableSet.copyOf(TALL_CROPS);
    }

    public static Map<IBlockState, IBlockState> getStemCrops() {
        return ImmutableMap.copyOf(STEM_CROPS);
    }

    public static Map<IBlockState, Integer> getAmplifiers() {
        return ImmutableMap.copyOf(AMPLIFIERS);
    }
}

